/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;
import org.jdesktop.swingx.color.ColorUtil;

public class ObjectPlacerGraphic
extends JPanel
implements PropertyChangeListener {
    protected static final String OBJECT_POSITION_CHANGED = "OBJECT_POSITION_CHANGED";
    private static final String SOURCE_NODE_TXT = "SOURCE";
    private static final String TARGET_NODE_TXT = "TARGET";
    private static final String CLICK_TXT = "(click and drag)";
    private static final int DEF_PANEL_SIZE = 500;
    private static final int DEF_EDGE_PANEL_WIDTH = 600;
    private static final int DEF_EDGE_PANEL_HEIGHT = 400;
    private static final float TGT_FONT_SIZE = 32.0f;
    private static final float NODES_FONT_SIZE = 18.0f;
    private static final double GRAVITY_DISTANCE = 10.0;
    private final Color BG_COLOR = UIManager.getColor("Table.background");
    private final Color OBJ_FG_COLOR = UIManager.getColor("CyColor.complement(-2)");
    private final Color OBJ_BG_COLOR = ColorUtil.setAlpha((Color)this.OBJ_FG_COLOR, (int)20);
    private final Color OBJ_BORDER_COLOR = ColorUtil.setAlpha((Color)this.OBJ_FG_COLOR, (int)150);
    private final Color OBJ_INFO_COLOR = ColorUtil.setAlpha((Color)this.OBJ_FG_COLOR, (int)150);
    private final Color TGT_FG_COLOR = ColorUtil.setAlpha((Color)this.BG_COLOR, (int)200);
    private final Color TGT_BG_COLOR = ColorUtil.setAlpha((Color)UIManager.getColor("CyColor.complement(+1)"), (int)50);
    private final Color TGT_BORDER_COLOR = ColorUtil.setAlpha((Color)UIManager.getColor("CyColor.complement(+1)"), (int)125);
    private final Color TGT_POINT_COLOR = UIManager.getColor("CyColor.complement(+1)");
    private final Color NODES_BG_COLOR = ColorUtil.setSaturation((Color)ColorUtil.setBrightness((Color)UIManager.getColor("CyColor.complement(+2)"), (float)0.8f), (float)0.25f);
    private final Color NODES_FG_COLOR = ColorUtil.setAlpha((Color)UIManager.getColor("Table.background"), (int)150);
    private final Color POINT_HIGHLIGHT_COLOR = UIManager.getColor("CyColor.primary(+2)");
    private int tw;
    private int th;
    private int[] txPoints;
    private int[] tyPoints;
    private int ow;
    private int oh;
    private int[] oxPoints;
    private int[] oyPoints;
    private int dot;
    private int nd;
    private int xPos;
    private int yPos;
    private int bestObjX = 1;
    private int bestObjY = 1;
    private int bestTgtX = 1;
    private int bestTgtY = 1;
    private boolean canDrag;
    private boolean isDragging;
    private int xClickOffset;
    private int yClickOffset;
    private int xOffset;
    private int yOffset;
    private float offsetRatio;
    private Justification justify;
    private Map<String, Integer> txtWidths = new HashMap<String, Integer>();
    private int txtHeight = -1;
    private int detailStrokeWidth = 3;
    private int lowStrokeWidth = 1;
    private final Stroke detailStroke = new BasicStroke(this.detailStrokeWidth);
    private final Stroke lowStroke = new BasicStroke(this.lowStrokeWidth);
    private ObjectPosition op;
    private final ObjectPositionVisualProperty vp;
    private final boolean fullDetail;
    private final Integer prefWidth;
    private final Integer prefHeight;

    public ObjectPlacerGraphic(ObjectPosition op, ObjectPositionVisualProperty vp, Integer width, Integer height, boolean fullDetail) {
        this.op = op;
        this.vp = vp;
        this.fullDetail = fullDetail;
        this.setBackground(this.BG_COLOR);
        this.addMouseListener(new MouseClickHandler());
        this.addMouseMotionListener(new MouseDragHandler());
        if (width == null) {
            width = BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp) ? 600 : 500;
        }
        if (height == null) {
            height = BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp) ? 400 : 500;
        }
        this.prefWidth = width;
        this.prefHeight = height;
        this.initSize(width, height);
        this.applyPosition();
    }

    public ObjectPlacerGraphic(ObjectPosition op, ObjectPositionVisualProperty vp, boolean fullDetail) {
        this(op, vp, null, null, fullDetail);
    }

    public void applyPosition() {
        Position labelAnchor;
        this.xOffset = (int)(this.op.getOffsetX() * (double)this.offsetRatio);
        this.yOffset = (int)(this.op.getOffsetY() * (double)this.offsetRatio);
        this.justify = this.op.getJustify();
        Position nodeAnchor = this.op.getTargetAnchor();
        if (nodeAnchor != Position.NONE) {
            this.bestTgtX = nodeAnchor.ordinal() % 3;
            this.bestTgtY = nodeAnchor.ordinal() / 3;
        }
        if ((labelAnchor = this.op.getAnchor()) != Position.NONE) {
            this.bestObjX = labelAnchor.ordinal() % 3;
            this.bestObjY = labelAnchor.ordinal() / 3;
        }
        if ((nodeAnchor != Position.NONE || labelAnchor != Position.NONE) && this.txPoints != null && this.tyPoints != null && this.oxPoints != null && this.oyPoints != null) {
            if (this.txPoints.length > this.bestTgtX && this.oxPoints.length > this.bestObjX) {
                this.xPos = this.txPoints[this.bestTgtX] - this.oxPoints[this.bestObjX];
            }
            if (this.tyPoints.length > this.bestTgtY && this.oyPoints.length > this.bestObjY) {
                this.yPos = this.tyPoints[this.bestTgtY] - this.oyPoints[this.bestObjY];
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fm3;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font f1 = g2.getFont();
        Font f2 = this.fullDetail ? this.createTargetFont(f1) : null;
        Font f3 = this.fullDetail ? this.createSrcTgtNodesFont(f1) : null;
        FontMetrics fm1 = g2.getFontMetrics();
        FontMetrics fm2 = f2 != null ? g2.getFontMetrics(f2) : null;
        FontMetrics fontMetrics = fm3 = f3 != null ? g2.getFontMetrics(f3) : null;
        if (this.txtHeight <= 0) {
            this.txtHeight = fm1.getHeight();
        }
        boolean isNodeLabel = this.vp == null || BasicVisualLexicon.NODE_LABEL_POSITION.equals(this.vp);
        boolean isEdgeLabel = BasicVisualLexicon.EDGE_LABEL_POSITION.equals(this.vp);
        boolean isCGLabel = this.vp != null && this.vp.getIdString().startsWith("NODE_CUSTOMGRAPHICS_POSITION");
        String tgtTxt = isEdgeLabel ? "EDGE" : "NODE";
        String objTxt = "OBJECT";
        if (isNodeLabel || isEdgeLabel) {
            objTxt = "LABEL";
        } else if (isCGLabel) {
            objTxt = "IMAGE/CHART";
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 0) {
            w = this.prefWidth;
        }
        if (h <= 0) {
            h = this.prefHeight;
        }
        g2.setColor(this.BG_COLOR);
        g2.fillRect(0, 0, w, h);
        g2.setColor(this.TGT_BG_COLOR);
        int xc = w / 2;
        int yc = h / 2;
        int x = xc - this.tw / 2;
        int y = yc - this.th / 2;
        if (isEdgeLabel) {
            g2.fillRect(x - this.nd / 2, y, this.tw + this.nd, this.th);
            g2.setColor(this.NODES_BG_COLOR);
            int yn = yc - this.nd / 2;
            g2.fillArc(x - this.nd, yn, this.nd, this.nd, -90, 180);
            g2.fillArc(x + this.tw, yn, this.nd, this.nd, -90, -180);
            if (this.fullDetail) {
                int snTxtWidth = this.getTextWidth(fm3, SOURCE_NODE_TXT);
                int hpad = 10;
                int sty = yc + fm3.getMaxAscent() / 2 - fm3.getMaxDescent() / 2;
                g2.setFont(f3);
                g2.setColor(this.NODES_FG_COLOR);
                g2.drawString(SOURCE_NODE_TXT, this.nd / 2 - snTxtWidth - hpad, sty);
                g2.drawString(TARGET_NODE_TXT, x + this.tw + hpad, sty);
                g2.setFont(f1);
            }
        } else {
            g2.fillOval(x, y, this.tw, this.th);
        }
        g2.setStroke(this.fullDetail ? this.detailStroke : this.lowStroke);
        if (!isEdgeLabel) {
            g2.setColor(this.TGT_BORDER_COLOR);
            g2.drawRect(x, y, this.tw, this.th);
        }
        if (this.fullDetail) {
            g2.setFont(f2);
            int tgtTxtWidth = this.getTextWidth(fm2, tgtTxt);
            g2.setColor(this.TGT_FG_COLOR);
            g2.drawString(tgtTxt, xc - tgtTxtWidth / 2, yc + fm2.getMaxAscent() / 2 - fm2.getMaxDescent() / 2);
            g2.setFont(f1);
            for (int i = 0; i < this.txPoints.length; ++i) {
                for (int j = 0; j < this.tyPoints.length; ++j) {
                    if (i == this.bestTgtX && j == this.bestTgtY && !this.isDragging) {
                        g2.setColor(this.POINT_HIGHLIGHT_COLOR);
                    } else {
                        g2.setColor(this.TGT_POINT_COLOR);
                    }
                    g2.fillOval(this.txPoints[i] - this.dot / 2, this.tyPoints[j] - this.dot / 2, this.dot, this.dot);
                }
            }
        }
        g2.setColor(this.OBJ_BG_COLOR);
        g2.fillRect(this.xOffset + this.xPos, this.yOffset + this.yPos, this.ow, this.oh);
        g2.setColor(this.OBJ_BORDER_COLOR);
        g2.drawRect(this.xOffset + this.xPos, this.yOffset + this.yPos, this.ow, this.oh);
        if (this.fullDetail) {
            int ascent = fm1.getMaxAscent();
            int descent = fm1.getMaxDescent();
            int objTxtWidth = this.getTextWidth(fm1, objTxt);
            int clickTxtWidth = this.getTextWidth(fm1, CLICK_TXT);
            int yObjTxt = this.yOffset + this.yPos + this.txtHeight - descent + this.detailStrokeWidth;
            int yClickTxt = this.yOffset + this.yPos + this.oh - this.txtHeight + ascent - this.detailStrokeWidth;
            g2.setColor(this.OBJ_FG_COLOR);
            if (this.justify == Justification.JUSTIFY_LEFT) {
                g2.drawString(objTxt, this.xOffset + this.xPos + this.detailStrokeWidth, yObjTxt);
                g2.setColor(this.OBJ_INFO_COLOR);
                g2.drawString(CLICK_TXT, this.xOffset + this.xPos + this.detailStrokeWidth, yClickTxt);
            } else if (this.justify == Justification.JUSTIFY_RIGHT) {
                g2.drawString(objTxt, this.xOffset + this.xPos + (this.ow - objTxtWidth) - this.detailStrokeWidth, yObjTxt);
                g2.setColor(this.OBJ_INFO_COLOR);
                g2.drawString(CLICK_TXT, this.xOffset + this.xPos + (this.ow - clickTxtWidth), yClickTxt);
            } else {
                g2.drawString(objTxt, this.xOffset + this.xPos + (this.ow - objTxtWidth) / 2, yObjTxt);
                g2.setColor(this.OBJ_INFO_COLOR);
                g2.drawString(CLICK_TXT, this.xOffset + this.xPos + (this.ow - clickTxtWidth) / 2, yClickTxt);
            }
        }
        if (this.fullDetail) {
            g2.setColor(this.OBJ_FG_COLOR);
            for (int i = 0; i < this.oxPoints.length; ++i) {
                for (int j = 0; j < this.oyPoints.length; ++j) {
                    if (i == this.bestObjX && j == this.bestObjY && !this.isDragging) {
                        g2.setColor(this.POINT_HIGHLIGHT_COLOR);
                    }
                    g2.fillOval(this.xPos + this.xOffset + this.oxPoints[i] - this.dot / 2, this.yPos + this.yOffset + this.oyPoints[j] - this.dot / 2, this.dot, this.dot);
                    if (i != this.bestObjX || j != this.bestObjY) continue;
                    g2.setColor(this.OBJ_FG_COLOR);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals(OBJECT_POSITION_CHANGED)) {
            this.op = (ObjectPosition)e.getNewValue();
            this.applyPosition();
            this.repaint();
        }
    }

    private void initSize(int w, int h) {
        this.setMinimumSize(new Dimension(w, h));
        this.setPreferredSize(new Dimension(w, h));
        int xc = w / 2;
        int yc = h / 2;
        this.offsetRatio = (float)w / 500.0f;
        if (BasicVisualLexicon.EDGE_LABEL_POSITION.equals(this.vp)) {
            this.tw = (int)(0.7 * (double)w);
            this.th = (int)((double)h / 6.0);
            this.nd = w - this.tw;
        } else {
            this.tw = this.th = (int)(0.3 * (double)Math.min(w, h));
        }
        this.txPoints = new int[]{xc - this.tw / 2, xc, xc + this.tw / 2};
        this.tyPoints = new int[]{yc - this.th / 2, yc, yc + this.th / 2};
        this.ow = (int)(0.4 * (double)((w + h) / 2));
        this.oh = (int)(0.1 * (double)((w + h) / 2));
        this.oxPoints = new int[]{0, this.ow / 2, this.ow};
        this.oyPoints = new int[]{0, this.oh / 2, this.oh};
        this.xPos = this.dot = (int)(0.02 * ((double)(w + h) / 2.0));
        this.yPos = this.dot;
    }

    private Position parsePosition(int positionConstant) {
        for (Position p : Position.values()) {
            if (p.ordinal() != positionConstant) continue;
            return p;
        }
        return null;
    }

    private boolean isInsideObjectBox(int x, int y) {
        return x >= this.xPos + this.xOffset && x <= this.xPos + this.xOffset + this.ow && y >= this.yPos + this.yOffset && y <= this.yPos + this.yOffset + this.oh;
    }

    private void updateCursor(int x, int y) {
        if (this.canDrag || this.isDragging) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.isInsideObjectBox(x, y)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Font createTargetFont(Font f) {
        return f.deriveFont(1, 32.0f).deriveFont(Map.of(TextAttribute.TRACKING, 0.2));
    }

    private Font createSrcTgtNodesFont(Font f) {
        return f.deriveFont(1, 18.0f);
    }

    private int getTextWidth(FontMetrics fm, String txt) {
        int w;
        int n = w = this.txtWidths.get(txt) == null ? -1 : this.txtWidths.get(txt);
        if (w <= 0) {
            w = fm.stringWidth(txt);
            this.txtWidths.put(txt, w);
        }
        return w;
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            if (ObjectPlacerGraphic.this.isInsideObjectBox(x, y = e.getY())) {
                ObjectPlacerGraphic.this.canDrag = true;
                ObjectPlacerGraphic.this.xClickOffset = x - ObjectPlacerGraphic.this.xPos;
                ObjectPlacerGraphic.this.yClickOffset = y - ObjectPlacerGraphic.this.yPos;
                ObjectPlacerGraphic.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ObjectPlacerGraphic.this.isDragging) {
                int x = e.getX();
                int y = e.getY();
                ObjectPlacerGraphic.this.xPos = x - ObjectPlacerGraphic.this.xClickOffset + ObjectPlacerGraphic.this.xOffset;
                ObjectPlacerGraphic.this.yPos = y - ObjectPlacerGraphic.this.yClickOffset + ObjectPlacerGraphic.this.yOffset;
                double best = Double.POSITIVE_INFINITY;
                double offX = 0.0;
                double offY = 0.0;
                for (int i = 0; i < ObjectPlacerGraphic.this.txPoints.length; ++i) {
                    for (int j = 0; j < ObjectPlacerGraphic.this.tyPoints.length; ++j) {
                        Point tp = new Point(ObjectPlacerGraphic.this.txPoints[i] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.tyPoints[j] - ObjectPlacerGraphic.this.dot / 2);
                        for (int a = 0; a < ObjectPlacerGraphic.this.oxPoints.length; ++a) {
                            for (int b = 0; b < ObjectPlacerGraphic.this.oyPoints.length; ++b) {
                                Point op = new Point(ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.oxPoints[a] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.oyPoints[b] - ObjectPlacerGraphic.this.dot / 2);
                                double dist = op.distance(tp);
                                if (!(dist < best)) continue;
                                best = dist;
                                ObjectPlacerGraphic.this.bestObjX = a;
                                ObjectPlacerGraphic.this.bestObjY = b;
                                ObjectPlacerGraphic.this.bestTgtX = i;
                                ObjectPlacerGraphic.this.bestTgtY = j;
                                offX = op.getX() - tp.getX();
                                offY = op.getY() - tp.getY();
                            }
                        }
                    }
                }
                ObjectPlacerGraphic.this.xPos = ObjectPlacerGraphic.this.txPoints[ObjectPlacerGraphic.this.bestTgtX] - ObjectPlacerGraphic.this.oxPoints[ObjectPlacerGraphic.this.bestObjX];
                ObjectPlacerGraphic.this.yPos = ObjectPlacerGraphic.this.tyPoints[ObjectPlacerGraphic.this.bestTgtY] - ObjectPlacerGraphic.this.oyPoints[ObjectPlacerGraphic.this.bestObjY];
                if (Math.sqrt(offX * offX + offY * offY) > 10.0 + (double)(ObjectPlacerGraphic.this.dot / 2)) {
                    ObjectPlacerGraphic.this.xOffset = (int)offX;
                    ObjectPlacerGraphic.this.yOffset = (int)offY;
                } else {
                    ObjectPlacerGraphic.this.xOffset = 0;
                    ObjectPlacerGraphic.this.yOffset = 0;
                }
                ObjectPlacerGraphic.this.op.setOffsetX((double)ObjectPlacerGraphic.this.xOffset);
                ObjectPlacerGraphic.this.op.setOffsetY((double)ObjectPlacerGraphic.this.yOffset);
                ObjectPlacerGraphic.this.op.setAnchor(ObjectPlacerGraphic.this.parsePosition(ObjectPlacerGraphic.this.bestObjX + 3 * ObjectPlacerGraphic.this.bestObjY));
                ObjectPlacerGraphic.this.op.setTargetAnchor(ObjectPlacerGraphic.this.parsePosition(ObjectPlacerGraphic.this.bestTgtX + 3 * ObjectPlacerGraphic.this.bestTgtY));
                ObjectPlacerGraphic.this.firePropertyChange(ObjectPlacerGraphic.OBJECT_POSITION_CHANGED, null, ObjectPlacerGraphic.this.op);
                ObjectPlacerGraphic.this.repaint();
                ObjectPlacerGraphic.this.isDragging = false;
                ObjectPlacerGraphic.this.canDrag = false;
                ObjectPlacerGraphic.this.updateCursor(x, y);
            }
        }
    }

    private class MouseDragHandler
    extends MouseMotionAdapter {
        private MouseDragHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!ObjectPlacerGraphic.this.canDrag && !ObjectPlacerGraphic.this.isDragging) {
                ObjectPlacerGraphic.this.updateCursor(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ObjectPlacerGraphic.this.canDrag) {
                ObjectPlacerGraphic.this.xPos = e.getX() - ObjectPlacerGraphic.this.xClickOffset;
                ObjectPlacerGraphic.this.yPos = e.getY() - ObjectPlacerGraphic.this.yClickOffset;
                ObjectPlacerGraphic.this.isDragging = true;
                ObjectPlacerGraphic.this.repaint();
            }
        }
    }
}

