/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class ObjectPlacerControl
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final String ANCHOR_POINTS = "Anchor Points";
    private static final String NONE_LABEL = "-- select --";
    private JLabel targetAnchorLabel;
    private JLabel objAnchorLabel;
    private JLabel justifyLabel;
    private JComboBox<Position> targetAnchors;
    private JComboBox<Position> objAnchors;
    private JComboBox<Justification> justifyCombo;
    private JTextField xoffsetBox;
    private JTextField yoffsetBox;
    private boolean ignoreEvents;
    private ObjectPosition p;

    public ObjectPlacerControl(ObjectPosition p, final ObjectPositionVisualProperty vp) {
        this.p = p;
        ArrayList<Position> objPositions = new ArrayList<Position>(Arrays.asList(Position.values()));
        objPositions.remove(Position.NONE);
        objPositions.sort(new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        ArrayList<Position> tgtPositions = new ArrayList<Position>(objPositions);
        if (BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp)) {
            tgtPositions.sort(new Comparator<Position>(){

                @Override
                public int compare(Position p1, Position p2) {
                    String txt1 = ObjectPlacerControl.getTargetPositionText(vp, p1);
                    String txt2 = ObjectPlacerControl.getTargetPositionText(vp, p2);
                    return txt1.compareTo(txt2);
                }
            });
        }
        this.targetAnchorLabel = new JLabel();
        this.targetAnchors = new JComboBox<Position>(tgtPositions.toArray(new Position[tgtPositions.size()]));
        this.targetAnchors.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String name = value instanceof Position ? ObjectPlacerControl.getTargetPositionText(vp, (Position)value) : ObjectPlacerControl.NONE_LABEL;
                this.setText(name);
                return this;
            }
        });
        this.targetAnchors.addActionListener(this);
        this.objAnchorLabel = new JLabel();
        this.objAnchors = new JComboBox<Position>(objPositions.toArray(new Position[objPositions.size()]));
        this.objAnchors.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Position pos;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String name = ObjectPlacerControl.NONE_LABEL;
                if (value instanceof Position && (pos = (Position)value) != Position.NONE) {
                    name = pos.getName();
                }
                this.setText(name);
                return this;
            }
        });
        this.objAnchors.addActionListener(this);
        this.justifyLabel = new JLabel("Text Justification:");
        this.justifyCombo = new JComboBox<Justification>(Justification.values());
        this.justifyCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String name = value instanceof Justification ? ((Justification)value).getName() : ObjectPlacerControl.NONE_LABEL;
                this.setText(name);
                return this;
            }
        });
        this.justifyCombo.addActionListener(this);
        JLabel xoffsetLabel = new JLabel("X Offset Value (can be negative):");
        this.xoffsetBox = new JTextField("0", 8);
        this.xoffsetBox.setHorizontalAlignment(4);
        this.xoffsetBox.addActionListener(this);
        JLabel yoffsetLabel = new JLabel("Y Offset Value (can be negative):");
        this.yoffsetBox = new JTextField("0", 8);
        this.yoffsetBox.setHorizontalAlignment(4);
        this.yoffsetBox.addActionListener(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(this.targetAnchorLabel).addComponent(this.objAnchorLabel).addComponent(this.justifyLabel).addComponent(xoffsetLabel).addComponent(yoffsetLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.targetAnchors).addComponent(this.objAnchors).addComponent(this.justifyCombo).addComponent(this.xoffsetBox, -2, -1, -2).addComponent(this.yoffsetBox, -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.targetAnchorLabel).addComponent(this.targetAnchors)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.objAnchorLabel).addComponent(this.objAnchors)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.justifyLabel).addComponent(this.justifyCombo)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(xoffsetLabel).addComponent(this.xoffsetBox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(yoffsetLabel).addComponent(this.yoffsetBox)));
        boolean isLabel = BasicVisualLexicon.NODE_LABEL_POSITION.equals(vp) || BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp);
        this.targetAnchorLabel.setText((BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp) ? "Edge " : "Node ") + "Anchor Points:");
        this.objAnchorLabel.setText((isLabel ? "Label " : "Object ") + "Anchor Points:");
        this.justifyLabel.setVisible(isLabel);
        this.justifyCombo.setVisible(isLabel);
        this.applyPosition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        Object source = e.getSource();
        boolean changed = false;
        if (source == this.targetAnchors) {
            this.p.setTargetAnchor((Position)this.targetAnchors.getSelectedItem());
            changed = true;
        }
        if (source == this.objAnchors) {
            this.p.setAnchor((Position)this.objAnchors.getSelectedItem());
            changed = true;
        }
        if (source == this.justifyCombo) {
            this.p.setJustify((Justification)this.justifyCombo.getSelectedItem());
            changed = true;
        }
        if (this.getOffset(this.xoffsetBox) != this.p.getOffsetX() || this.getOffset(this.yoffsetBox) != this.p.getOffsetY()) {
            this.p.setOffsetX(this.getOffset(this.xoffsetBox));
            this.p.setOffsetY(this.getOffset(this.yoffsetBox));
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.firePropertyChange("OBJECT_POSITION_CHANGED", null, this.p);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("OBJECT_POSITION_CHANGED") && e.getNewValue() instanceof ObjectPosition) {
            this.p = (ObjectPosition)e.getNewValue();
            this.applyPosition();
        }
    }

    public ObjectPosition getPosition() {
        return this.p;
    }

    private void applyPosition() {
        this.ignoreEvents = true;
        Position nodeAnchor = this.p.getTargetAnchor();
        Position labelAnchor = this.p.getAnchor();
        if (nodeAnchor.equals((Object)Position.NONE)) {
            this.targetAnchors.setSelectedIndex(-1);
        } else {
            this.targetAnchors.setSelectedItem(nodeAnchor);
        }
        if (labelAnchor.equals((Object)Position.NONE)) {
            this.objAnchors.setSelectedIndex(-1);
        } else {
            this.objAnchors.setSelectedItem(labelAnchor);
        }
        this.justifyCombo.setSelectedItem(this.p.getJustify());
        this.xoffsetBox.setText(Integer.valueOf((int)this.p.getOffsetX()).toString());
        this.yoffsetBox.setText(Integer.valueOf((int)this.p.getOffsetY()).toString());
        this.ignoreEvents = false;
        this.repaint();
    }

    private double getOffset(JTextField jtf) {
        try {
            double d = Double.parseDouble(jtf.getText());
            return d;
        }
        catch (Exception ex) {
            jtf.setText("0");
            return 0.0;
        }
    }

    private static String getTargetPositionText(ObjectPositionVisualProperty vp, Position pos) {
        Object txt = NONE_LABEL;
        if (pos != null && pos != Position.NONE) {
            if (BasicVisualLexicon.EDGE_LABEL_POSITION.equals(vp)) {
                String sn = pos.getShortName().toUpperCase();
                if (pos == Position.CENTER || pos == Position.NORTH || pos == Position.SOUTH) {
                    txt = "Middle";
                } else if (sn.endsWith("W")) {
                    txt = "Source";
                } else if (sn.endsWith("E")) {
                    txt = "Target";
                }
                if (sn.startsWith("N")) {
                    txt = (String)txt + " (above)";
                } else if (sn.startsWith("S")) {
                    txt = (String)txt + " (below)";
                }
            } else {
                txt = pos.getName();
            }
        }
        return txt;
    }
}

