/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.view.presentation.property.LabelBackgroundShapeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.LabelBackgroundShape;
import org.cytoscape.view.presentation.property.values.NodeShape;

public class DNodeShape
implements NodeShape {
    private static final DNodeShape RECTANGLE = new DNodeShape((byte)0, NodeShapeVisualProperty.RECTANGLE.getDisplayName(), NodeShapeVisualProperty.RECTANGLE.getSerializableString());
    private static final DNodeShape ROUND_RECTANGLE = new DNodeShape((byte)6, NodeShapeVisualProperty.ROUND_RECTANGLE.getDisplayName(), NodeShapeVisualProperty.ROUND_RECTANGLE.getSerializableString());
    private static final DNodeShape TRIANGLE = new DNodeShape((byte)7, NodeShapeVisualProperty.TRIANGLE.getDisplayName(), NodeShapeVisualProperty.TRIANGLE.getSerializableString());
    private static final DNodeShape PARALLELOGRAM = new DNodeShape((byte)5, NodeShapeVisualProperty.PARALLELOGRAM.getDisplayName(), NodeShapeVisualProperty.PARALLELOGRAM.getSerializableString());
    private static final DNodeShape DIAMOND = new DNodeShape((byte)1, NodeShapeVisualProperty.DIAMOND.getDisplayName(), NodeShapeVisualProperty.DIAMOND.getSerializableString());
    private static final DNodeShape ELLIPSE = new DNodeShape((byte)2, NodeShapeVisualProperty.ELLIPSE.getDisplayName(), NodeShapeVisualProperty.ELLIPSE.getSerializableString());
    private static final DNodeShape HEXAGON = new DNodeShape((byte)3, NodeShapeVisualProperty.HEXAGON.getDisplayName(), NodeShapeVisualProperty.HEXAGON.getSerializableString());
    private static final DNodeShape OCTAGON = new DNodeShape((byte)4, NodeShapeVisualProperty.OCTAGON.getDisplayName(), NodeShapeVisualProperty.OCTAGON.getSerializableString());
    public static final DNodeShape VEE = new DNodeShape((byte)8, "V", "VEE");
    private static final Map<NodeShape, DNodeShape> DEF_SHAPE_MAP = new HashMap<NodeShape, DNodeShape>();
    private final Byte rendererShapeID;
    private final String displayName;
    private final String serializableString;
    private static final Map<Byte, Shape> nodeShapes;

    public static final DNodeShape getDShape(NodeShape shape) {
        if (DEF_SHAPE_MAP.get(shape) == null) {
            return RECTANGLE;
        }
        return DEF_SHAPE_MAP.get(shape);
    }

    public static final DNodeShape getDShape(LabelBackgroundShape shape) {
        if (shape == LabelBackgroundShapeVisualProperty.RECTANGLE) {
            return RECTANGLE;
        }
        if (shape == LabelBackgroundShapeVisualProperty.ROUND_RECTANGLE) {
            return ROUND_RECTANGLE;
        }
        return null;
    }

    public DNodeShape(Byte rendererShapeID, String displayName, String serializableString) {
        this.rendererShapeID = rendererShapeID;
        this.displayName = displayName;
        this.serializableString = serializableString;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public String getSerializableString() {
        return this.serializableString;
    }

    public Byte getNativeShape() {
        return this.rendererShapeID;
    }

    public Shape getShape() {
        return nodeShapes.get(this.rendererShapeID);
    }

    static {
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.RECTANGLE, RECTANGLE);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.DIAMOND, DIAMOND);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.ELLIPSE, ELLIPSE);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.HEXAGON, HEXAGON);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.OCTAGON, OCTAGON);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.PARALLELOGRAM, PARALLELOGRAM);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.ROUND_RECTANGLE, ROUND_RECTANGLE);
        DEF_SHAPE_MAP.put(NodeShapeVisualProperty.TRIANGLE, TRIANGLE);
        DEF_SHAPE_MAP.put(VEE, VEE);
        nodeShapes = GraphGraphics.getNodeShapes();
    }
}

