/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cmdline.gui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.cmdline.gui.internal.SessionLoadHandler;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.SimpleCyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.read.LoadNetworkFileTaskFactory;
import org.cytoscape.task.read.LoadNetworkURLTaskFactory;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupConfig
implements AppsFinishedStartingListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Properties globalProps;
    private final Properties localProps = new Properties();
    private final StreamUtil streamUtil;
    private boolean taskStart;
    private OpenSessionTaskFactory loadSession;
    private LoadNetworkFileTaskFactory networkFileLoader;
    private LoadNetworkURLTaskFactory networkURLLoader;
    private LoadVizmapFileTaskFactory visualStylesLoader;
    private final CyServiceRegistrar registrar;
    private final SessionLoadHandler sessionLoadHandler;
    private File sessionName;
    private List<File> networkFiles = new ArrayList<File>();
    private List<URL> networkURLs = new ArrayList<URL>();
    private List<File> vizmapFiles = new ArrayList<File>();
    private List<TaskIterator> taskIteratorList = new ArrayList<TaskIterator>();

    public StartupConfig(Properties globalProps, StreamUtil streamUtil, OpenSessionTaskFactory loadSession, LoadNetworkFileTaskFactory networkFileLoader, LoadNetworkURLTaskFactory networkURLLoader, LoadVizmapFileTaskFactory visualStylesLoader, CyServiceRegistrar registrar, SessionLoadHandler sessionLoadHandler) {
        this.globalProps = globalProps;
        this.streamUtil = streamUtil;
        this.loadSession = loadSession;
        this.networkFileLoader = networkFileLoader;
        this.networkURLLoader = networkURLLoader;
        this.visualStylesLoader = visualStylesLoader;
        this.registrar = registrar;
        this.sessionLoadHandler = sessionLoadHandler;
    }

    public void handleEvent(AppsFinishedStartingEvent evt) {
        if (!this.taskIteratorList.isEmpty()) {
            DummyTask initTask = new DummyTask();
            TaskIterator taskIterator = new TaskIterator(this.taskIteratorList.size(), new Task[]{initTask});
            for (int i = this.taskIteratorList.size() - 1; i >= 0; --i) {
                TaskIterator ti = this.taskIteratorList.get(i);
                taskIterator.insertTasksAfter((Task)initTask, ti);
            }
            this.taskIteratorList.clear();
            TaskManager taskManager = (TaskManager)this.registrar.getService(TaskManager.class);
            taskManager.execute(taskIterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String[] potentialProps) {
        Properties argProps = new Properties();
        Matcher propPattern = Pattern.compile("^((\\w+\\.*)+)\\=(.+)$").matcher("");
        for (String potential : potentialProps) {
            propPattern.reset(potential);
            if (propPattern.matches()) {
                argProps.setProperty(propPattern.group(1), propPattern.group(3));
                continue;
            }
            try (InputStream in = null;){
                in = this.streamUtil.getInputStream(potential);
                if (in != null) {
                    this.localProps.load(in);
                    continue;
                }
                logger.info("Couldn't load property: " + potential);
            }
            catch (IOException e) {
                logger.warn("Couldn't load property '" + potential + "' from file: " + e.getMessage(), (Throwable)e);
            }
        }
        this.localProps.putAll((Map<?, ?>)argProps);
        this.taskStart = true;
    }

    public void setSession(String args) {
        try {
            this.sessionName = new File(args);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        this.taskStart = true;
    }

    public void setCommandScript(String args) {
        try {
            File file = new File(args);
        }
        catch (Exception e) {
            System.err.println("Can't find script file: " + args + ": " + e.toString());
            logger.error(e.toString());
            return;
        }
        this.localProps.setProperty("scriptFile", args);
        this.taskStart = true;
    }

    public void setRestPort(String args) {
        if (args == null || args.length() == 0) {
            args = "1234";
        } else {
            try {
                Integer n = Integer.valueOf(args);
            }
            catch (Exception e) {
                System.err.println("Rest port argument not an integer: " + args);
                logger.error(e.toString());
                return;
            }
        }
        this.localProps.setProperty("rest.port", args);
        this.taskStart = true;
    }

    public void setNetworks(String[] args) {
        this.networkFiles = new ArrayList<File>();
        this.networkURLs = new ArrayList<URL>();
        for (String name : args) {
            try {
                if (name.matches("^(jar\\:)?((http|https|ftp|file)+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                    this.networkURLs.add(new URL(name));
                    continue;
                }
                this.networkFiles.add(new File(name));
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
        this.taskStart = true;
    }

    public void setVizMapProps(String[] args) {
        this.vizmapFiles = new ArrayList<File>();
        for (String name : args) {
            try {
                this.vizmapFiles.add(new File(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.taskStart = true;
    }

    protected void start() {
        SimpleCyProperty commandline = new SimpleCyProperty("commandline", (Object)this.localProps, Properties.class, CyProperty.SavePolicy.DO_NOT_SAVE);
        Properties cmdlnProps = new Properties();
        cmdlnProps.setProperty("cyPropertyName", "commandline.props");
        this.registrar.registerService((Object)commandline, CyProperty.class, cmdlnProps);
        if (this.taskStart) {
            this.globalProps.setProperty("tempHideWelcomeScreen", "true");
            if (this.sessionName != null) {
                this.taskIteratorList.add(this.loadSession.createTaskIterator(this.sessionName));
            } else {
                for (File file : this.networkFiles) {
                    this.taskIteratorList.add(this.networkFileLoader.createTaskIterator(file));
                }
                for (URL uRL : this.networkURLs) {
                    this.taskIteratorList.add(this.networkURLLoader.loadCyNetworks(uRL));
                }
                for (File file : this.vizmapFiles) {
                    this.taskIteratorList.add(this.visualStylesLoader.createTaskIterator(file));
                }
            }
        }
        this.taskIteratorList.add(new TaskIterator(new Task[]{new AbstractTask(){

            public void run(TaskMonitor tm) {
                StartupConfig.this.sessionLoadHandler.startListeningForSessionFileOpen();
            }
        }}));
    }

    private class DummyTask
    extends AbstractTask {
        private DummyTask() {
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
        }
    }
}

