/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.cytoscape.biopax.internal.BioPaxMapper;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualStyleUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VisualStyleUtil.class);
    public static final double BIO_PAX_VISUAL_STYLE_PHYSICAL_ENTITY_NODE_WIDTH = 20.0;
    public static final double BIO_PAX_VISUAL_STYLE_PHYSICAL_ENTITY_NODE_HEIGHT = 20.0;
    public static final double BIO_PAX_VISUAL_STYLE_PHYSICAL_ENTITY_NODE_SIZE_SCALE = 3.0;
    private static final String BIO_PAX_VISUAL_STYLE = "BioPAX";
    private static final String BINARY_SIF_VISUAL_STYLE = "BioPAX_SIF";
    private static final double BIO_PAX_VISUAL_STYLE_INTERACTION_NODE_SIZE_SCALE = 0.67;
    private static final double BIO_PAX_VISUAL_STYLE_COMPLEX_NODE_SIZE_SCALE = 0.67;
    private static final Color DEFAULT_NODE_COLOR = new Color(255, 255, 255);
    private static final Color DEFAULT_NODE_BORDER_COLOR = new Color(0, 102, 102);
    private static final Color COMPLEX_NODE_COLOR = DEFAULT_NODE_COLOR;
    private static final Color COMPLEX_NODE_BORDER_COLOR = DEFAULT_NODE_BORDER_COLOR;
    private static final String INTERACTION = "interaction";
    private final VisualStyleFactory styleFactory;
    private final VisualMappingManager mappingManager;
    private final VisualMappingFunctionFactory discreteFactory;
    private final VisualMappingFunctionFactory passthroughFactory;
    private VisualStyle simpleBiopaxStyle;
    private VisualStyle binarySifStyle;
    private static BufferedImage[] customPhosGraphics = null;

    public VisualStyleUtil(VisualStyleFactory styleFactory, VisualMappingManager mappingManager, VisualMappingFunctionFactory discreteMappingFactory, VisualMappingFunctionFactory passthroughFactory) {
        this.styleFactory = styleFactory;
        this.mappingManager = mappingManager;
        this.discreteFactory = discreteMappingFactory;
        this.passthroughFactory = passthroughFactory;
    }

    public synchronized void init() {
        this.initBioPaxVisualStyle();
        this.initBinarySifVisualStyle();
    }

    public VisualStyle getBioPaxVisualStyle() {
        return this.simpleBiopaxStyle;
    }

    public VisualStyle getBinarySifVisualStyle() {
        return this.binarySifStyle;
    }

    private void initBioPaxVisualStyle() {
        if (this.simpleBiopaxStyle == null) {
            this.simpleBiopaxStyle = this.findBiopaxVisualStyle(BIO_PAX_VISUAL_STYLE);
        }
        if (this.simpleBiopaxStyle != null) {
            this.mappingManager.removeVisualStyle(this.simpleBiopaxStyle);
        }
        this.simpleBiopaxStyle = this.styleFactory.createVisualStyle(BIO_PAX_VISUAL_STYLE);
        this.mappingManager.addVisualStyle(this.simpleBiopaxStyle);
        for (VisualPropertyDependency vpd : this.simpleBiopaxStyle.getAllVisualPropertyDependencies()) {
            if (vpd.getIdString().equals("nodeSizeLocked")) {
                vpd.setDependency(false);
                continue;
            }
            if (!vpd.getIdString().equals("arrowColorMatchesEdge")) continue;
            vpd.setDependency(true);
        }
        DiscreteMapping width = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_WIDTH);
        DiscreteMapping height = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_HEIGHT);
        for (Class<? extends BioPAXElement> c : BioPaxMapper.getSubclassNames(Interaction.class)) {
            String entityName = c.getSimpleName();
            width.putMapValue((Object)entityName, (Object)new Double(13.4));
            height.putMapValue((Object)entityName, (Object)new Double(13.4));
        }
        String entityName = "Complex";
        width.putMapValue((Object)entityName, (Object)new Double(13.4));
        height.putMapValue((Object)entityName, (Object)new Double(13.4));
        this.simpleBiopaxStyle.setDefaultValue(BasicVisualLexicon.NODE_WIDTH, (Object)20.0);
        this.simpleBiopaxStyle.setDefaultValue(BasicVisualLexicon.NODE_HEIGHT, (Object)20.0);
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)width);
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)height);
        this.simpleBiopaxStyle.addVisualMappingFunction(this.passthroughFactory.createVisualMappingFunction("name", String.class, BasicVisualLexicon.NODE_LABEL));
        this.simpleBiopaxStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)DEFAULT_NODE_COLOR);
        DiscreteMapping color = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_FILL_COLOR);
        color.putMapValue((Object)"Complex", (Object)COMPLEX_NODE_COLOR);
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)color);
        this.simpleBiopaxStyle.setDefaultValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)DEFAULT_NODE_BORDER_COLOR);
        DiscreteMapping paintFunction = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_BORDER_PAINT);
        paintFunction.putMapValue((Object)"Complex", (Object)COMPLEX_NODE_BORDER_COLOR);
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)paintFunction);
        DiscreteMapping tgtArrowShape = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction(INTERACTION, String.class, BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
        tgtArrowShape.putMapValue((Object)"right", (Object)ArrowShapeVisualProperty.DELTA);
        tgtArrowShape.putMapValue((Object)"controlled", (Object)ArrowShapeVisualProperty.DELTA);
        tgtArrowShape.putMapValue((Object)"cofactor", (Object)ArrowShapeVisualProperty.DELTA);
        tgtArrowShape.putMapValue((Object)"contains", (Object)ArrowShapeVisualProperty.CIRCLE);
        for (ControlType controlType : ControlType.values()) {
            if (!controlType.toString().startsWith("I")) continue;
            tgtArrowShape.putMapValue((Object)controlType.toString(), (Object)ArrowShapeVisualProperty.T);
        }
        for (ControlType controlType : ControlType.values()) {
            if (!controlType.toString().startsWith("A")) continue;
            tgtArrowShape.putMapValue((Object)controlType.toString(), (Object)ArrowShapeVisualProperty.DELTA);
        }
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)tgtArrowShape);
        this.simpleBiopaxStyle.setDefaultValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        DiscreteMapping shape = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_SHAPE);
        for (Class<? extends BioPAXElement> claz : BioPaxMapper.getSubclassNames(PhysicalEntity.class)) {
            String name = claz.getSimpleName();
            shape.putMapValue((Object)name, (Object)NodeShapeVisualProperty.ELLIPSE);
        }
        shape.putMapValue((Object)"Complex", (Object)NodeShapeVisualProperty.DIAMOND);
        shape.putMapValue((Object)"Protein-phosphorylated", (Object)NodeShapeVisualProperty.ELLIPSE);
        for (Class<? extends BioPAXElement> c : BioPaxMapper.getSubclassNames(Interaction.class)) {
            if (Control.class.isAssignableFrom(c)) {
                shape.putMapValue((Object)c.getSimpleName(), (Object)NodeShapeVisualProperty.TRIANGLE);
                continue;
            }
            shape.putMapValue((Object)c.getSimpleName(), (Object)NodeShapeVisualProperty.RECTANGLE);
        }
        this.simpleBiopaxStyle.addVisualMappingFunction((VisualMappingFunction)shape);
    }

    private VisualStyle findBiopaxVisualStyle(String biopaxVisualStyleTitle) {
        for (VisualStyle vs : this.mappingManager.getAllVisualStyles()) {
            if (!biopaxVisualStyleTitle.equals(vs.getTitle())) continue;
            return vs;
        }
        return null;
    }

    private void initBinarySifVisualStyle() {
        if (this.binarySifStyle == null) {
            this.binarySifStyle = this.findBiopaxVisualStyle(BINARY_SIF_VISUAL_STYLE);
        }
        if (this.binarySifStyle != null) {
            this.mappingManager.removeVisualStyle(this.binarySifStyle);
        }
        this.binarySifStyle = this.styleFactory.createVisualStyle(BINARY_SIF_VISUAL_STYLE);
        this.mappingManager.addVisualStyle(this.binarySifStyle);
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.NODE_TRANSPARENCY, (Object)125);
        for (VisualPropertyDependency vpd : this.binarySifStyle.getAllVisualPropertyDependencies()) {
            if (vpd.getIdString().equals("nodeSizeLocked")) {
                vpd.setDependency(false);
                continue;
            }
            if (!vpd.getIdString().equals("arrowColorMatchesEdge")) continue;
            vpd.setDependency(true);
        }
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        DiscreteMapping shapeFunction = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_SHAPE);
        shapeFunction.putMapValue((Object)"Complex", (Object)NodeShapeVisualProperty.HEXAGON);
        this.binarySifStyle.addVisualMappingFunction((VisualMappingFunction)shapeFunction);
        Color color = new Color(0xFF9999);
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)color);
        Color colorLightBlue = new Color(0x99CCFF);
        DiscreteMapping paintFunction = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction("BIOPAX_TYPE", String.class, BasicVisualLexicon.NODE_FILL_COLOR);
        paintFunction.putMapValue((Object)"Complex", (Object)colorLightBlue);
        this.binarySifStyle.addVisualMappingFunction((VisualMappingFunction)paintFunction);
        this.binarySifStyle.addVisualMappingFunction(this.passthroughFactory.createVisualMappingFunction("name", String.class, BasicVisualLexicon.NODE_LABEL));
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.EDGE_WIDTH, (Object)4.0);
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, (Object)Color.BLACK);
        paintFunction = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction(INTERACTION, String.class, BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        this.initEdgeDiscreteMappingValues((DiscreteMapping<String, Paint>)paintFunction);
        this.binarySifStyle.addVisualMappingFunction((VisualMappingFunction)paintFunction);
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.EDGE_UNSELECTED_PAINT, (Object)Color.BLACK);
        paintFunction = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction(INTERACTION, String.class, BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        this.initEdgeDiscreteMappingValues((DiscreteMapping<String, Paint>)paintFunction);
        this.binarySifStyle.addVisualMappingFunction((VisualMappingFunction)paintFunction);
        DiscreteMapping discreteMapping = (DiscreteMapping)this.discreteFactory.createVisualMappingFunction(INTERACTION, String.class, BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
        discreteMapping.putMapValue((Object)"controls-state-change-of", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"controls-transport-of", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"catalysis-precedes", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"controls-phosphorylation-of", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"controls-expression-of", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"controls-transport-of-chemical", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"controls-production-of", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"consumption-controled-by", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"chemical-affects", (Object)ArrowShapeVisualProperty.ARROW);
        discreteMapping.putMapValue((Object)"used-to-produce", (Object)ArrowShapeVisualProperty.ARROW);
        this.binarySifStyle.addVisualMappingFunction((VisualMappingFunction)discreteMapping);
        this.binarySifStyle.setDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)Color.WHITE);
    }

    private void initEdgeDiscreteMappingValues(DiscreteMapping<String, Paint> paintFunction) {
        paintFunction.putMapValue((Object)"in-complex-with", (Object)new Color(0xF000A0));
        paintFunction.putMapValue((Object)"interacts-with", (Object)new Color(21760));
        paintFunction.putMapValue((Object)"neighbor-of", (Object)new Color(43520));
        paintFunction.putMapValue((Object)"reacts-with", (Object)new Color(65280));
        paintFunction.putMapValue((Object)"catalysis-precedes", (Object)new Color(0x7000A0));
        paintFunction.putMapValue((Object)"controls-state-change-of", (Object)new Color(192));
        paintFunction.putMapValue((Object)"controls-phosphorylation-of", (Object)new Color(255));
        paintFunction.putMapValue((Object)"controls-expression-of", (Object)new Color(41120));
        paintFunction.putMapValue((Object)"controls-production-of", (Object)new Color(52464));
        paintFunction.putMapValue((Object)"controls-transport-of", (Object)new Color(0x700000));
        paintFunction.putMapValue((Object)"controls-transport-of-chemical", (Object)new Color(0xA00000));
        paintFunction.putMapValue((Object)"consumption-controled-by", (Object)new Color(0xFF3300));
        paintFunction.putMapValue((Object)"used-to-produce", (Object)new Color(16209152));
        paintFunction.putMapValue((Object)"chemical-affects", (Object)new Color(0xF09000));
    }

    private static Rectangle2D getCustomShapeRect(BufferedImage image, int modificationCount) {
        double scale = 0.1;
        double[] startX = new double[]{0.0, 30.0, 0.0, -30.0};
        double[] startY = new double[]{-30.0, 0.0, 30.0, 0.0};
        return new Rectangle2D.Double(startX[modificationCount] + (double)(-1 * (image.getWidth() / 2)) * scale, startY[modificationCount] + (double)(-1 * (image.getHeight() / 2)) * scale, (double)image.getWidth() * scale, (double)image.getHeight() * scale);
    }

    static {
        try {
            BufferedImage phosNode = ImageIO.read(BioPaxMapper.class.getResource("phos-node.jpg"));
            BufferedImage phosNodeSelectedTop = ImageIO.read(BioPaxMapper.class.getResource("phos-node-selected-top.jpg"));
            BufferedImage phosNodeSelectedRight = ImageIO.read(BioPaxMapper.class.getResource("phos-node-selected-right.jpg"));
            BufferedImage phosNodeSelectedBottom = ImageIO.read(BioPaxMapper.class.getResource("phos-node-selected-bottom.jpg"));
            BufferedImage phosNodeSelectedLeft = ImageIO.read(BioPaxMapper.class.getResource("phos-node-selected-left.jpg"));
            customPhosGraphics = new BufferedImage[]{phosNode, phosNodeSelectedTop, phosNodeSelectedRight, phosNodeSelectedBottom, phosNodeSelectedLeft};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

