/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;

public class BioPaxFilter
extends BasicCyFileFilter {
    private static final String BIOPAX_NAMESPACE_STARTS_WITH = "http://www.biopax.org/release/biopax";
    private static final int DEFAULT_LINES_TO_CHECK = 20;

    public BioPaxFilter(StreamUtil streamUtil) {
        super(new String[]{"xml", "owl", "rdf", ""}, new String[]{"text/xml", "application/rdf+xml", "application/xml", "text/plain"}, "BioPAX data", DataCategory.NETWORK, streamUtil);
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != this.category) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            for (int linesToCheck = 20; linesToCheck > 0; --linesToCheck) {
                String line = reader.readLine();
                if (line == null || !line.contains(BIOPAX_NAMESPACE_STARTS_WITH)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean accepts(URI uri, DataCategory category) {
        String ext = FilenameUtils.getExtension((String)uri.toString());
        if (category == this.category && this.extensions.contains(ext)) {
            boolean bl;
            block9: {
                InputStream is = this.streamUtil.getInputStream(uri.toURL());
                try {
                    bl = this.accepts(is, category);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }
}

