/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.cytoscape.file_transfer.internal.CloudURL;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.file_transfer.internal.URLToSandboxResult;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class URLToSandboxTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox to contain file", exampleStringValue="default_sandbox")
    public String sandboxName = "";
    @Tunable(description="fileName", longDescription="Sandbox-relative name of file to save.", exampleStringValue="GDS112_full.soft")
    public String fileName = "";
    @Tunable(description="sourceURL", longDescription="URL of the source file", exampleStringValue="https://www.dropbox.com/s/r15azh0xb53smu1/GDS112_full.soft?dl=0")
    public String sourceURL = "";
    @Tunable(description="overwrite", longDescription="True to overwrite a file if it already exists", exampleStringValue="true")
    public boolean overwrite = false;
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Transfer URL-named file to sandbox";
    }

    public URLToSandboxTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        if (SandboxUtils.showDebug()) {
            System.out.println("In URLToSandbox");
            System.out.println(" sandboxName: " + this.sandboxName);
            System.out.println(" fileName: " + this.fileName);
            System.out.println(" sourceURL: " + this.sourceURL);
            System.out.println(" overwrite: " + this.overwrite);
            System.out.println(" sandboxParentDirFile: " + this.sandboxParentDirFile);
        }
        File fileFile = SandboxUtils.getAbsFileFile(this.sandboxParentDirFile, this.sandboxName, this.fileName, false);
        if (this.sourceURL == null || this.sourceURL.trim().length() == 0) {
            throw new Exception("Source URL cannot be null");
        }
        if (fileFile.exists()) {
            if (this.overwrite) {
                try {
                    FileUtils.forceDelete((File)fileFile);
                }
                catch (Throwable throwable) {}
            } else {
                throw new Exception("'" + this.fileName + "' already exists.");
            }
        }
        taskMon.setStatusMessage("Writing file " + this.fileName);
        fileFile.getParentFile().mkdirs();
        String filePath = fileFile.getCanonicalPath();
        if (SandboxUtils.showDebug()) {
            System.out.println(" Downloading " + this.sourceURL + " to " + filePath);
        }
        long length = new CloudURL(this.sourceURL).readFile(filePath);
        if (SandboxUtils.showDebug()) {
            System.out.println(" Downloaded " + length);
        }
        this.result = new URLToSandboxResult(filePath, length);
    }

    public static String getExample() {
        return URLToSandboxTask.getJson(new URLToSandboxResult("/User/CytoscapeConfiguration/FileTransfer/default_sandbox/GDS112_full.soft", 5536880L));
    }
}

