/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.file_transfer.internal.ToSandboxResult;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class ToSandboxTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox to contain file", exampleStringValue="mySandbox")
    public String sandboxName = "";
    @Tunable(description="fileName", longDescription="Sandbox-relative name of file to save.", exampleStringValue="myFile.png")
    public String fileName = "";
    @Tunable(description="fileBase64", longDescription="The file content as Base64", exampleStringValue="iVBORw0KGgoAAAANSUhEUgAABY=")
    public String fileBase64 = "";
    @Tunable(description="fileByteCount", longDescription="The count of bytes in the raw file", exampleStringValue="10")
    public long fileByteCount = 0L;
    @Tunable(description="overwrite", longDescription="True to overwrite a file if it already exists", exampleStringValue="true")
    public boolean overwrite = false;
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Transfer file to sandbox";
    }

    public ToSandboxTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        if (SandboxUtils.showDebug()) {
            System.out.println("In ToSandbox");
            System.out.println(" sandboxName: " + this.sandboxName);
            System.out.println(" fileName: " + this.fileName);
            System.out.println(" fileBase64Len: " + this.fileBase64.length());
            System.out.println(" fileByteCount: " + this.fileByteCount);
            System.out.println(" overwrite: " + this.overwrite);
            System.out.println(" sandboxParentDirFile: " + this.sandboxParentDirFile);
        }
        File fileFile = SandboxUtils.getAbsFileFile(this.sandboxParentDirFile, this.sandboxName, this.fileName, false);
        if (this.fileBase64 == null || this.fileBase64.length() == 0) {
            throw new Exception("File content cannot be empty.");
        }
        byte[] fileRaw = Base64.decodeBase64((String)this.fileBase64);
        if ((long)fileRaw.length != this.fileByteCount) {
            throw new Exception("File '" + this.fileName + "' contains " + fileRaw.length + " bytes but should contain " + this.fileByteCount + " bytes");
        }
        if (fileFile.exists()) {
            if (this.overwrite) {
                try {
                    FileUtils.forceDelete((File)fileFile);
                }
                catch (Throwable throwable) {}
            } else {
                throw new Exception("'" + this.fileName + "' already exists.");
            }
        }
        taskMon.setStatusMessage("Writing file " + this.fileName);
        fileFile.getParentFile().mkdirs();
        String filePath = fileFile.getCanonicalPath();
        Files.write(Paths.get(filePath, new String[0]), fileRaw, new OpenOption[0]);
        this.result = new ToSandboxResult(filePath);
    }

    public static String getExample() {
        return ToSandboxTask.getJson(new ToSandboxResult("/User/CytoscapeConfiguration/FileTransfer/MySandbox/MyFile.png"));
    }
}

