/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SandboxUtils {
    public static final File getAbsSandboxFile(File sandboxParentDirFile, String sandboxName) throws Exception {
        if (sandboxName == null || sandboxName.trim().length() == 0) {
            throw new Exception("Sandbox name cannot be empty.");
        }
        Path sandboxPath = Paths.get(sandboxName, new String[0]);
        if (sandboxPath.getNameCount() != 1 || sandboxPath.isAbsolute() || !sandboxPath.getFileName().toString().matches(".*[^\\.].*") || sandboxName.matches(".*[\\\\/].*")) {
            throw new Exception("Sandbox name must be a simple directory name.");
        }
        return new File(sandboxParentDirFile, sandboxPath.toString());
    }

    public static final File getAbsFileFile(File sandboxParentDirFile, String sandboxName, String fileName, boolean allowSandboxOnly) throws Exception {
        if (fileName == null || fileName.trim().length() == 0) {
            throw new Exception("File name cannot be empty.");
        }
        if (sandboxName == null || sandboxName.trim().length() == 0) {
            return new File(fileName);
        }
        File sandboxDirFile = SandboxUtils.getAbsSandboxFile(sandboxParentDirFile, sandboxName);
        String sandboxPath = sandboxDirFile.getCanonicalPath() + File.separator;
        if (!sandboxDirFile.exists()) {
            throw new Exception("Sandbox '" + sandboxPath + "' doesn't exist");
        }
        if (allowSandboxOnly && fileName.trim().equals(".")) {
            return sandboxDirFile;
        }
        File fileFile = new File(sandboxDirFile, fileName);
        String filePath = fileFile.getCanonicalPath();
        if (filePath.startsWith(sandboxPath)) {
            return fileFile;
        }
        throw new Exception("Files outside of sandbox are not allowed. '" + filePath + "' is not in '" + sandboxPath + "'");
    }

    public static final String getModifiedTime(File fileFile) {
        if (fileFile.exists()) {
            SimpleDateFormat s = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss.SSSS");
            return s.format(new Date(fileFile.lastModified()));
        }
        return "";
    }

    public static final boolean showDebug() {
        String env_var = System.getenv().getOrDefault("CY_FILETRANSFER_DEBUG", "false");
        return env_var.toLowerCase().equals("true");
    }
}

