/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.RemoveFileResult;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class RemoveFileTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox containing file", exampleStringValue="default_sandbox")
    public String sandboxName = "";
    @Tunable(description="fileName", longDescription="Sandbox-relative name of file or directory to delete.", exampleStringValue="myFile.png")
    public String fileName = "";
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Remove a sandboxed file or directory if one exists";
    }

    public RemoveFileTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        if (SandboxUtils.showDebug()) {
            System.out.println("In RemoveFile");
            System.out.println(" sandboxName: " + this.sandboxName);
            System.out.println(" fileName: " + this.fileName);
            System.out.println(" sandboxParentDirFile: " + this.sandboxParentDirFile);
        }
        File fileFile = SandboxUtils.getAbsFileFile(this.sandboxParentDirFile, this.sandboxName, this.fileName, false);
        String filePath = fileFile.getCanonicalPath();
        if (fileFile.exists()) {
            FileUtils.forceDelete((File)fileFile);
            this.result = new RemoveFileResult(filePath, true);
        } else {
            this.result = new RemoveFileResult(filePath, false);
        }
    }

    public static String getExample() {
        return RemoveFileTask.getJson(new RemoveFileResult("/User/CytoscapeConfiguration/FileTransfer/default_sandbox/MyFile.png", true));
    }
}

