/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.codec.binary.Base64;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.FromSandboxResult;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class FromSandboxTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox containing file", exampleStringValue="default_sandbox")
    public String sandboxName = "";
    @Tunable(description="fileName", longDescription="Sandbox-relative name of file.", exampleStringValue="myFile.png")
    public String fileName = "";
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Transfer file from a sandbox";
    }

    public FromSandboxTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        File fileFile;
        if (SandboxUtils.showDebug()) {
            System.out.println("In FromSandbox");
            System.out.println(" sandboxName: " + this.sandboxName);
            System.out.println(" fileName: " + this.fileName);
            System.out.println(" sandboxParentDirFile: " + this.sandboxParentDirFile);
        }
        if ((fileFile = SandboxUtils.getAbsFileFile(this.sandboxParentDirFile, this.sandboxName, this.fileName, false)).exists() && !fileFile.isFile()) {
            throw new Exception("'" + this.fileName + "' must identify a file, not a directory, in sandbox '" + this.sandboxName + "'.");
        }
        try {
            String modifiedTime = SandboxUtils.getModifiedTime(fileFile);
            taskMon.setStatusMessage("Reading file " + this.fileName);
            String filePath = fileFile.getCanonicalPath();
            byte[] allBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            long fileByteCount = allBytes.length;
            String fileBase64 = new String(Base64.encodeBase64((byte[])allBytes), StandardCharsets.UTF_8);
            this.result = new FromSandboxResult(filePath, modifiedTime, fileByteCount, fileBase64);
        }
        catch (Throwable e) {
            throw new Exception(e.toString());
        }
    }

    public static String getExample() {
        return FromSandboxTask.getJson(new FromSandboxResult("/User/CytoscapeConfiguration/FileTransfer/default_sandbox/MyFile.png", "2020-07-29 03:00:00.0000", 10L, "iVBORw0KGgoAAAANSUhEUgAABY="));
    }
}

