/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.tasks;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.manual.internal.common.GraphConverter2;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;
import org.cytoscape.view.manual.internal.scale.ScaleLayouter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class ScaleTask
extends AbstractTask {
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="The network to be scaled", context="nogui", longDescription="The name of the network to be scaled.  CURRENT may be used to indicate the currently selected network")
    public CyNetwork network;
    @Tunable(description="The scale factor", context="nogui", longDescription="The scale factor to apply to the network.")
    public double scaleFactor;
    @Tunable(description="Axis", context="nogui", longDescription="The axis to scale")
    public ListSingleSelection<String> axis = new ListSingleSelection((Object[])new String[]{"X Axis", "Y Axis", "Both Axes"});
    @Tunable(description="Only scale selected nodes", context="nogui", longDescription="Only scale the selected nodes")
    public boolean selectedOnly = false;

    public ScaleTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.axis.setSelectedValue((Object)"Both Axes");
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Rotate Network View");
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Collection views = viewManager.getNetworkViews(this.network);
        CyNetworkView currentView = null;
        for (CyNetworkView view : views) {
            if (!view.getRendererId().contains("ding")) continue;
            currentView = view;
            break;
        }
        if (currentView == null) {
            currentView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        }
        if (currentView == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find network view");
            return;
        }
        MutablePolyEdgeGraphLayout nativeGraph = GraphConverter2.getGraphReference(128.0, true, this.selectedOnly, currentView);
        ScaleLayouter.Direction direction = ScaleLayouter.Direction.BOTH_AXES;
        String dir = (String)this.axis.getSelectedValue();
        if (dir.startsWith("X")) {
            direction = ScaleLayouter.Direction.X_AXIS_ONLY;
        } else if (dir.startsWith("Y")) {
            direction = ScaleLayouter.Direction.Y_AXIS_ONLY;
        }
        ScaleLayouter scaler = new ScaleLayouter(nativeGraph);
        scaler.scaleGraph(this.scaleFactor, direction);
    }
}

