/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.tasks;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.manual.internal.common.GraphConverter2;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;
import org.cytoscape.view.manual.internal.rotate.RotationLayouter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.BoundedDouble;

public class RotateTask
extends AbstractTask {
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="The network to be rotated", context="nogui", longDescription="The name of the network to be rotated.  CURRENT may be used to indicate the currently selected network")
    public CyNetwork network;
    @Tunable(description="The angle (in degrees) to rotate", context="nogui", longDescription="The angle (in degrees) to rotate the network.  From -180 to 180")
    public BoundedDouble angle = new BoundedDouble(Double.valueOf(-180.0), Double.valueOf(0.0), Double.valueOf(180.0), false, false);
    @Tunable(description="Only rotate selected nodes", context="nogui", longDescription="Only rotate the selected nodes")
    public boolean selectedOnly = false;

    public RotateTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Rotate Network View");
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Collection views = viewManager.getNetworkViews(this.network);
        CyNetworkView currentView = null;
        for (CyNetworkView view : views) {
            if (!view.getRendererId().contains("ding")) continue;
            currentView = view;
            break;
        }
        if (currentView == null) {
            currentView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        }
        if (currentView == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find network view");
            return;
        }
        MutablePolyEdgeGraphLayout nativeGraph = GraphConverter2.getGraphReference(128.0, true, this.selectedOnly, currentView);
        RotationLayouter rotation = new RotationLayouter(nativeGraph);
        double degrees = (Double)this.angle.getValue();
        double radians = degrees * Math.PI / 180.0;
        rotation.rotateGraph(radians);
    }
}

