/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.control.view;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.manual.internal.control.actions.dist.HDistCenter;
import org.cytoscape.view.manual.internal.control.actions.dist.HDistLeft;
import org.cytoscape.view.manual.internal.control.actions.dist.HDistRight;
import org.cytoscape.view.manual.internal.control.actions.dist.VDistBottom;
import org.cytoscape.view.manual.internal.control.actions.dist.VDistCenter;
import org.cytoscape.view.manual.internal.control.actions.dist.VDistTop;
import org.cytoscape.view.manual.internal.util.Util;
import org.cytoscape.work.undo.UndoSupport;

public class DistPanel
extends JPanel {
    private JLabel label;
    private JButton halButton;
    private JButton hacButton;
    private JButton harButton;
    private JButton vatButton;
    private JButton vacButton;
    private JButton vabButton;
    private final UndoSupport undoSupport;

    public DistPanel(CyApplicationManager app, UndoSupport undoSupport) {
        this.undoSupport = undoSupport;
        ImageIcon hali = new ImageIcon(this.getClass().getResource("/images/H_DIST_LEFT.gif"));
        ImageIcon haci = new ImageIcon(this.getClass().getResource("/images/H_DIST_CENTER.gif"));
        ImageIcon hari = new ImageIcon(this.getClass().getResource("/images/H_DIST_RIGHT.gif"));
        ImageIcon vati = new ImageIcon(this.getClass().getResource("/images/V_DIST_TOP.gif"));
        ImageIcon vaci = new ImageIcon(this.getClass().getResource("/images/V_DIST_CENTER.gif"));
        ImageIcon vabi = new ImageIcon(this.getClass().getResource("/images/V_DIST_BOTTOM.gif"));
        HDistLeft hal = new HDistLeft(hali, app, undoSupport);
        HDistCenter hac = new HDistCenter(haci, app, undoSupport);
        HDistRight har = new HDistRight(hari, app, undoSupport);
        VDistTop vat = new VDistTop(vati, app, undoSupport);
        VDistCenter vac = new VDistCenter(vaci, app, undoSupport);
        VDistBottom vab = new VDistBottom(vabi, app, undoSupport);
        this.label = new JLabel("Distribute:");
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.label});
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.label);
        this.add(Box.createHorizontalGlue());
        this.halButton = Util.createButton(hal, "Horizontal Distribute Left");
        this.add(this.halButton);
        this.hacButton = Util.createButton(hac, "Horizontal Distribute Center");
        this.add(this.hacButton);
        this.harButton = Util.createButton(har, "Horizontal Distribute Right");
        this.add(this.harButton);
        this.vatButton = Util.createButton(vat, "Vertical Distribute Top");
        this.add(this.vatButton);
        this.vacButton = Util.createButton(vac, "Vertical Distribute Center");
        this.add(this.vacButton);
        this.vabButton = Util.createButton(vab, "Vertical Distribute Bottom");
        this.add(this.vabButton);
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.halButton.setEnabled(enabled);
        this.hacButton.setEnabled(enabled);
        this.harButton.setEnabled(enabled);
        this.vatButton.setEnabled(enabled);
        this.vacButton.setEnabled(enabled);
        this.vabButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

