/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.control.actions;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.LayoutEdit;
import org.cytoscape.view.manual.internal.util.Util;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public abstract class AbstractControlAction
extends AbstractAction {
    protected double X_min;
    protected double X_max;
    protected double Y_min;
    protected double Y_max;
    private final CyApplicationManager appMgr;
    private final UndoSupport undoSupport;
    private final String action;

    public AbstractControlAction(String name, Icon icon, CyApplicationManager appMgr, UndoSupport undoSupport) {
        super(name, icon);
        this.appMgr = appMgr;
        this.undoSupport = undoSupport;
        this.action = name;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CyNetworkView view = this.appMgr.getCurrentNetworkView();
        List<View<CyNode>> selectedNodeViews = view != null ? Util.findSelectedNodes(view) : null;
        this.undoSupport.postEdit((AbstractCyEdit)new LayoutEdit(this.action, view));
        if (selectedNodeViews != null && !selectedNodeViews.isEmpty()) {
            this.computeDimensions(selectedNodeViews);
            this.control(selectedNodeViews);
            view.updateView();
        }
    }

    protected abstract void control(List<View<CyNode>> var1);

    protected double getX(View<CyNode> n) {
        return (Double)n.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
    }

    protected double getY(View<CyNode> n) {
        return (Double)n.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
    }

    private void computeDimensions(List<View<CyNode>> selectedNodeViews) {
        this.X_min = Double.POSITIVE_INFINITY;
        this.X_max = Double.NEGATIVE_INFINITY;
        this.Y_min = Double.POSITIVE_INFINITY;
        this.Y_max = Double.NEGATIVE_INFINITY;
        for (View<CyNode> node_view : selectedNodeViews) {
            double Y;
            double X = this.getX(node_view);
            if (X > this.X_max) {
                this.X_max = X;
            }
            if (X < this.X_min) {
                this.X_min = X;
            }
            if ((Y = this.getY(node_view)) > this.Y_max) {
                this.Y_max = Y;
            }
            if (!(Y < this.Y_min)) continue;
            this.Y_min = Y;
        }
    }

    public class YComparator
    implements Comparator<View<CyNode>> {
        @Override
        public int compare(View<CyNode> n1, View<CyNode> n2) {
            if (AbstractControlAction.this.getY(n1) == AbstractControlAction.this.getY(n2)) {
                return 0;
            }
            if (AbstractControlAction.this.getY(n1) < AbstractControlAction.this.getY(n2)) {
                return -1;
            }
            return 1;
        }

        public boolean equals(View<CyNode> n1, View<CyNode> n2) {
            return AbstractControlAction.this.getY(n1) == AbstractControlAction.this.getY(n2);
        }
    }

    public class XComparator
    implements Comparator<View<CyNode>> {
        @Override
        public int compare(View<CyNode> n1, View<CyNode> n2) {
            if (AbstractControlAction.this.getX(n1) == AbstractControlAction.this.getX(n2)) {
                return 0;
            }
            if (AbstractControlAction.this.getX(n1) < AbstractControlAction.this.getX(n2)) {
                return -1;
            }
            return 1;
        }

        public boolean equals(View<CyNode> n1, View<CyNode> n2) {
            return AbstractControlAction.this.getX(n1) == AbstractControlAction.this.getX(n2);
        }
    }
}

