/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.common;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.view.manual.internal.common.PolymorphicSlider;
import org.cytoscape.view.model.CyNetworkView;

public class SliderStateTracker
implements SetCurrentNetworkViewListener {
    long preFocusedViewId = 0L;
    Map<Long, Integer> layoutStateMap = new HashMap<Long, Integer>();
    PolymorphicSlider slider;

    public SliderStateTracker(PolymorphicSlider s) {
        this.slider = s;
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        CyNetworkView curr = e.getNetworkView();
        if (curr == null) {
            return;
        }
        long curFocusedViewId = curr.getSUID();
        if (this.preFocusedViewId == curFocusedViewId) {
            return;
        }
        this.layoutStateMap.put(this.preFocusedViewId, this.slider.getSliderValue());
        Integer stateValue = this.layoutStateMap.get(curFocusedViewId);
        if (stateValue == null) {
            this.slider.updateSlider(0);
        } else {
            this.slider.updateSlider(stateValue);
        }
        this.preFocusedViewId = curFocusedViewId;
    }
}

