/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal;

import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.manual.internal.control.actions.ControlPanelAction;
import org.cytoscape.view.manual.internal.control.view.LayoutToolsPanel;
import org.cytoscape.view.manual.internal.tasks.RotateTaskFactory;
import org.cytoscape.view.manual.internal.tasks.ScaleTaskFactory;
import org.cytoscape.view.manual.internal.util.Util;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private LayoutToolsPanel layoutToolsPanel;
    private ControlPanelAction controlPanelAction;
    private static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CySwingApplication swingApplication = (CySwingApplication)this.getService(bc, CySwingApplication.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        Properties props = new Properties();
        props.setProperty("command", "scale");
        props.setProperty("commandNamespace", "layout");
        props.setProperty("commandDescription", "Scale the layout.");
        props.setProperty("commandLongDescription", "Scale the layout in either the X, Y, or both directions");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new ScaleTaskFactory(serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "rotate");
        props.setProperty("commandNamespace", "layout");
        props.setProperty("commandDescription", "Rotate the layout.");
        props.setProperty("commandLongDescription", "Rotate the layout");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{ }");
        this.registerService(bc, (Object)new RotateTaskFactory(serviceRegistrar), TaskFactory.class, props);
        Util.invokeOnEDTAndWait(() -> {
            this.layoutToolsPanel = new LayoutToolsPanel(serviceRegistrar);
            this.controlPanelAction = new ControlPanelAction((CytoPanelComponent)this.layoutToolsPanel, swingApplication, applicationManager, netViewManager);
        }, logger);
        this.registerAllServices(bc, (Object)this.controlPanelAction);
        this.registerAllServices(bc, this.layoutToolsPanel);
    }
}

