/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.math.xform;

import org.cytoscape.math.xform.AffineTransform3D;
import org.cytoscape.math.xform.Matrix4x4;

public class AxisRotation3D
extends AffineTransform3D {
    public static final byte X_AXIS = 1;
    public static final byte Y_AXIS = 2;
    public static final byte Z_AXIS = 4;

    public AxisRotation3D(byte axisOfRotation, double theta) {
        this(AxisRotation3D.getAxisRotationMatrix(axisOfRotation, theta));
    }

    private AxisRotation3D(Matrix4x4 matrix) {
        super(matrix);
    }

    public AxisRotation3D getInverse() {
        double[][] d = this.m_matrix.m_entries;
        return new AxisRotation3D(new Matrix4x4(new double[][]{{d[0][0], -d[0][1], d[0][2], d[0][3]}, {-d[1][0], d[1][1], -d[1][2], d[1][3]}, {d[2][0], -d[2][1], d[2][2], d[2][3]}, {d[3][0], d[3][1], d[3][2], d[3][3]}}));
    }

    private static Matrix4x4 getAxisRotationMatrix(byte axisOfRotation, double theta) {
        return new Matrix4x4(switch (axisOfRotation) {
            case 1 -> new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, Math.cos(theta), -Math.sin(theta), 0.0}, {0.0, Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 0.0, 1.0}};
            case 2 -> new double[][]{{Math.cos(theta), 0.0, Math.sin(theta), 0.0}, {0.0, 1.0, 0.0, 0.0}, {-Math.sin(theta), 0.0, Math.cos(theta), 0.0}, {0.0, 0.0, 0.0, 1.0}};
            case 4 -> new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0, 0.0}, {Math.sin(theta), Math.cos(theta), 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
            default -> throw new IllegalArgumentException("invalid axisOfRotation");
        });
    }
}

