/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.xgmml;

import java.io.IOException;
import java.io.OutputStream;
import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.io.internal.write.xgmml.GenericXGMMLWriter;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class SessionXGMMLNetworkWriter
extends GenericXGMMLWriter {
    public SessionXGMMLNetworkWriter(OutputStream outputStream, CyNetwork network, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, CyServiceRegistrar serviceRegistrar) {
        super(outputStream, network, unrecognizedVisualPropertyMgr, null, serviceRegistrar);
        if (this.rootNetwork.getSavePolicy() != SavePolicy.SESSION_FILE) {
            throw new IllegalArgumentException("Network cannot be saved because the root network's save policy is not \"SESSION_FILE\": " + network);
        }
    }

    @Override
    protected void writeRootElementAtributes() throws IOException {
        this.writeAttributePair("id", this.network.getSUID());
        this.writeAttributePair("label", this.getLabel(this.network, (CyIdentifiable)this.network));
        this.writeAttributePair("cy:view", ObjectTypeMap.toXGMMLBoolean(false));
        this.writeAttributePair("cy:registered", ObjectTypeMap.toXGMMLBoolean(this.isRegistered(this.network)));
    }

    @Override
    protected void writeMetadata() throws IOException {
    }

    @Override
    protected void writeRootGraphAttributes() throws IOException {
        for (CySubNetwork subNet : this.subNetworks) {
            if (this.writtenNetMap.containsKey(subNet) || !this.isSerializable((CyNetwork)subNet)) continue;
            this.writeSubGraph((CyNetwork)subNet);
        }
    }

    @Override
    protected void writeNodes() throws IOException {
        for (CyNode node : this.network.getNodeList()) {
            if (this.writtenNodeMap.containsKey(node)) continue;
            this.writeNode(this.network, node);
        }
    }

    @Override
    protected void writeNode(CyNetwork net, CyNode node) throws IOException {
        boolean written = this.writtenNodeMap.containsKey(node);
        this.writeElement("<node");
        if (written) {
            this.writeAttributePair("xlink:href", "#" + node.getSUID());
            this.write("/>\n");
        } else {
            this.writtenNodeMap.put(node, node);
            this.writeAttributePair("id", node.getSUID());
            this.writeAttributePair("label", this.getLabel(net, (CyIdentifiable)node));
            CyNetwork netPointer = node.getNetworkPointer();
            if (netPointer == null || !this.isSerializable(netPointer)) {
                this.write("/>\n");
            } else {
                this.write(">\n");
                ++this.depth;
                if (this.isRegistered(netPointer)) {
                    this.writeSubGraphReference(netPointer);
                } else {
                    this.writeSubGraph(netPointer);
                }
                --this.depth;
                this.writeElement("</node>\n");
            }
        }
    }

    @Override
    protected void writeEdges() throws IOException {
        for (CyEdge edge : this.network.getEdgeList()) {
            if (this.writtenEdgeMap.containsKey(edge)) continue;
            this.writeEdge(this.network, edge);
        }
    }

    @Override
    protected void writeEdge(CyNetwork net, CyEdge edge) throws IOException {
        this.writeElement("<edge");
        boolean written = this.writtenEdgeMap.containsKey(edge);
        if (written) {
            this.writeAttributePair("xlink:href", "#" + edge.getSUID());
            this.write("/>\n");
        } else {
            this.writtenEdgeMap.put(edge, edge);
            this.writeAttributePair("id", edge.getSUID());
            this.writeAttributePair("label", this.getLabel(net, (CyIdentifiable)edge));
            this.writeAttributePair("source", edge.getSource().getSUID());
            this.writeAttributePair("target", edge.getTarget().getSUID());
            this.writeAttributePair("cy:directed", ObjectTypeMap.toXGMMLBoolean(edge.isDirected()));
            this.write("/>\n");
        }
    }

    @Override
    protected void writeSubGraph(CyNetwork net) throws IOException {
        if (net == null) {
            return;
        }
        CyRootNetwork otherRoot = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(net);
        boolean sameRoot = this.rootNetwork.equals(otherRoot);
        if (!sameRoot) {
            this.writeSubGraphReference(net);
        } else {
            super.writeSubGraph(net);
        }
    }

    @Override
    protected void writeAttributes(CyRow row) throws IOException {
    }

    @Override
    protected boolean ignoreGraphicsAttribute(CyIdentifiable element, String attName) {
        return true;
    }

    @Override
    protected boolean isSerializable(CyNetwork net) {
        return net.getSavePolicy() == SavePolicy.SESSION_FILE && !this.isDisposed(net);
    }

    private boolean isDisposed(CyNetwork net) {
        return net.getDefaultNetworkTable() == null || net.getDefaultNodeTable() == null || net.getDefaultEdgeTable() == null;
    }
}

