/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.xgmml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.io.internal.util.session.SessionUtil;
import org.cytoscape.io.internal.util.xgmml.ObjectType;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.DoubleVisualProperty;
import org.cytoscape.view.presentation.property.IntegerVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericXGMMLWriter
extends AbstractTask
implements CyWriter {
    public static final String ENCODING = "UTF-8";
    public static final float VERSION = 3.0f;
    private static final String XML_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final String[] NAMESPACES = new String[]{"xmlns:dc=\"http://purl.org/dc/elements/1.1/\"", "xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "xmlns:cy=\"http://www.cytoscape.org\"", "xmlns=\"http://www.cs.rpi.edu/XGMML\""};
    private static final String DOCUMENT_VERSION_NAME = "cy:documentVersion";
    protected static final String NORMAL = "normal";
    protected static final String METANODE = "group";
    protected static final String REFERENCE = "reference";
    public static final String ENCODE_PROPERTY = "cytoscape.encode.xgmml.attributes";
    protected final OutputStream outputStream;
    protected final CyNetwork network;
    protected final CyRootNetwork rootNetwork;
    protected Set<CySubNetwork> subNetworks;
    protected CyNetworkView networkView;
    protected VisualStyle visualStyle;
    protected final UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr;
    private final GroupUtil groupUtil;
    private VisualLexicon visualLexicon;
    protected CyServiceRegistrar serviceRegistrar;
    protected final Map<CyNode, CyNode> writtenNodeMap = new WeakHashMap<CyNode, CyNode>();
    protected final Map<CyEdge, CyEdge> writtenEdgeMap = new WeakHashMap<CyEdge, CyEdge>();
    protected final Map<CyNetwork, CyNetwork> writtenNetMap = new WeakHashMap<CyNetwork, CyNetwork>();
    protected int depth = 0;
    private String indentString = "";
    private Writer writer;
    private boolean doFullEncoding;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GenericXGMMLWriter(OutputStream outputStream, CyNetworkView networkView, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, GroupUtil groupUtil, CyServiceRegistrar serviceRegistrar) {
        this(outputStream, (CyNetwork)networkView.getModel(), unrecognizedVisualPropertyMgr, groupUtil, serviceRegistrar);
        this.networkView = networkView;
        this.setVisualStyle(((VisualMappingManager)serviceRegistrar.getService(VisualMappingManager.class)).getVisualStyle(networkView));
    }

    public GenericXGMMLWriter(OutputStream outputStream, CyNetwork network, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, GroupUtil groupUtil, CyServiceRegistrar serviceRegistrar) {
        this.outputStream = outputStream;
        this.unrecognizedVisualPropertyMgr = unrecognizedVisualPropertyMgr;
        this.groupUtil = groupUtil;
        this.serviceRegistrar = serviceRegistrar;
        if (network instanceof CyRootNetwork) {
            this.rootNetwork = (CyRootNetwork)network;
            this.network = this.rootNetwork;
            this.subNetworks = this.getSerializableSubNetworks(this.rootNetwork);
        } else {
            this.network = network;
            this.rootNetwork = ((CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(network);
            this.subNetworks = new HashSet<CySubNetwork>();
        }
        for (int i = 0; i < 20; ++i) {
            this.indentString = this.indentString + "                        ";
        }
        this.doFullEncoding = Boolean.valueOf(System.getProperty(ENCODE_PROPERTY, "true"));
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        this.init(taskMonitor);
        this.writeRootElement();
        taskMonitor.setProgress(0.2);
        ++this.depth;
        this.writeMetadata();
        taskMonitor.setProgress(0.3);
        this.writeRootGraphAttributes();
        taskMonitor.setProgress(0.4);
        this.writeNodes();
        taskMonitor.setProgress(0.6);
        this.writeEdges();
        taskMonitor.setProgress(0.8);
        --this.depth;
        this.writeElement("</graph>\n");
        this.writer.flush();
        taskMonitor.setProgress(1.0);
        if (this.groupUtil != null) {
            this.groupUtil.groupsSerialized(Collections.singletonList(this.network), null);
        }
    }

    protected void init(TaskMonitor tm) {
        this.writer = new OutputStreamWriter(this.outputStream);
        this.prepareGroupsForSerialization();
    }

    protected void prepareGroupsForSerialization() {
        if (this.groupUtil != null) {
            this.groupUtil.prepareGroupsForSerialization(Collections.singletonList(this.network));
        }
    }

    protected void writeRootElement() throws IOException {
        this.writeElement("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        this.writeElement("<graph");
        this.writeRootElementAtributes();
        this.writeAttributePair(DOCUMENT_VERSION_NAME, Float.valueOf(3.0f));
        for (int ns = 0; ns < NAMESPACES.length; ++ns) {
            this.write(" " + NAMESPACES[ns]);
        }
        this.write(">\n");
        this.writtenNetMap.put(this.network, this.network);
    }

    protected void writeRootElementAtributes() throws IOException {
        this.writeAttributePair("id", this.network.getSUID());
        String label = this.networkView != null ? this.getLabel(this.networkView) : this.getLabel(this.network, (CyIdentifiable)this.network);
        this.writeAttributePair("label", label);
        this.writeAttributePair("directed", this.getDirectionality());
    }

    protected void writeMetadata() throws IOException {
        this.writeElement("<att name=\"networkMetadata\">\n");
        ++this.depth;
        String title = this.networkView != null ? this.getLabel(this.networkView) : this.getLabel(this.network, (CyIdentifiable)this.network);
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.writeElement("<rdf:RDF>\n");
        ++this.depth;
        this.writeElement("<rdf:Description rdf:about=\"http://www.cytoscape.org/\">\n");
        ++this.depth;
        this.writeElement("<dc:type>Protein-Protein Interaction</dc:type>\n");
        this.writeElement("<dc:description>N/A</dc:description>\n");
        this.writeElement("<dc:identifier>N/A</dc:identifier>\n");
        this.writeElement("<dc:date>" + df.format(now) + "</dc:date>\n");
        this.writeElement("<dc:title>" + title + "</dc:title>\n");
        this.writeElement("<dc:source>http://www.cytoscape.org/</dc:source>\n");
        this.writeElement("<dc:format>Cytoscape-XGMML</dc:format>\n");
        --this.depth;
        this.writeElement("</rdf:Description>\n");
        --this.depth;
        this.writeElement("</rdf:RDF>\n");
        --this.depth;
        this.writeElement("</att>\n");
    }

    protected void writeRootGraphAttributes() throws IOException {
        this.writeAttributes(this.network.getRow((CyIdentifiable)this.network));
        this.writeAttributes(this.network.getRow((CyIdentifiable)this.network, "HIDDEN"));
        this.writeGraphics((View<? extends CyIdentifiable>)this.networkView, false);
    }

    protected void writeSubGraph(CyNetwork net) throws IOException {
        if (net == null) {
            return;
        }
        if (this.writtenNetMap.containsKey(net)) {
            this.writeSubGraphReference(net);
        } else {
            CyRootNetwork otherRoot = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(net);
            boolean sameRoot = this.rootNetwork.equals(otherRoot);
            if (sameRoot) {
                this.writtenNetMap.put(net, net);
                this.writeElement("<att>\n");
                ++this.depth;
                this.writeElement("<graph");
                this.writeAttributePair("id", net.getSUID());
                this.writeAttributePair("label", this.getLabel(net, (CyIdentifiable)net));
                this.writeAttributePair("cy:registered", ObjectTypeMap.toXGMMLBoolean(this.isRegistered(net)));
                this.write(">\n");
                ++this.depth;
                this.writeAttributes(net.getRow((CyIdentifiable)net));
                this.writeAttributes(net.getRow((CyIdentifiable)net, "HIDDEN"));
                for (CyNode childNode : net.getNodeList()) {
                    this.writeNode(net, childNode);
                }
                for (CyEdge childEdge : net.getEdgeList()) {
                    this.writeEdge(net, childEdge);
                }
                --this.depth;
                this.writeElement("</graph>\n");
                --this.depth;
                this.writeElement("</att>\n");
            }
        }
    }

    protected void writeSubGraphReference(CyNetwork net) throws IOException {
        if (net == null) {
            return;
        }
        String href = "#" + net.getSUID();
        CyRootNetwork otherRoot = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(net);
        boolean sameRoot = this.rootNetwork.equals(otherRoot);
        if (!sameRoot) {
            String fileName = SessionUtil.getXGMMLFilename((CyNetwork)otherRoot);
            href = fileName + href;
        }
        this.writeElement("<att>\n");
        ++this.depth;
        this.writeElement("<graph");
        this.writeAttributePair("xlink:href", href);
        this.write("/>\n");
        --this.depth;
        this.writeElement("</att>\n");
    }

    protected void writeNodes() throws IOException {
        ArrayList<CyNode> pointerNodes = new ArrayList<CyNode>();
        for (CyNode node : this.network.getNodeList()) {
            if (node.getNetworkPointer() != null) {
                pointerNodes.add(node);
                continue;
            }
            if (this.writtenNodeMap.containsKey(node)) continue;
            this.writeNode(this.network, node);
        }
        for (CyNode node : pointerNodes) {
            if (this.writtenNodeMap.containsKey(node)) continue;
            this.writeNode(this.network, node);
        }
        if (this.groupUtil != null) {
            for (CyNode node : this.groupUtil.getExpandedGroups(this.network)) {
                if (this.writtenNodeMap.containsKey(node)) continue;
                this.writeNode(this.network, node);
            }
        }
    }

    protected void writeEdges() throws IOException {
        for (CyEdge edge : this.network.getEdgeList()) {
            if (this.writtenEdgeMap.containsKey(edge)) continue;
            this.writeEdge(this.network, edge);
        }
        if (this.groupUtil != null) {
            for (CyEdge edge : this.groupUtil.getGroupNodeEdges(this.network)) {
                if (this.writtenEdgeMap.containsKey(edge)) continue;
                this.writeEdge(this.network, edge);
            }
            for (CyEdge edge : this.groupUtil.getExternalEdges(this.network)) {
                if (this.writtenEdgeMap.containsKey(edge)) continue;
                this.writeEdge(this.network, edge);
            }
        }
    }

    protected void writeNode(CyNetwork net, CyNode node) throws IOException {
        boolean written = this.writtenNodeMap.containsKey(node);
        this.writeElement("<node");
        if (written) {
            this.writeAttributePair("xlink:href", "#" + node.getSUID());
            this.write("/>\n");
        } else {
            this.writtenNodeMap.put(node, node);
            this.writeAttributePair("id", node.getSUID());
            this.writeAttributePair("label", this.getLabel(net, (CyIdentifiable)node));
            this.write(">\n");
            ++this.depth;
            this.writeAttributes(net.getRow((CyIdentifiable)node));
            this.writeAttributes(net.getRow((CyIdentifiable)node, "HIDDEN"));
            CyNetwork netPointer = node.getNetworkPointer();
            if (netPointer != null && this.isSerializable(netPointer)) {
                this.writeSubGraph(netPointer);
            }
            if (this.networkView != null && this.network.containsNode(node)) {
                this.writeGraphics((View<? extends CyIdentifiable>)this.networkView.getNodeView(node), false);
            }
            --this.depth;
            this.writeElement("</node>\n");
        }
    }

    protected void writeEdge(CyNetwork net, CyEdge edge) throws IOException {
        this.writeElement("<edge");
        boolean written = this.writtenEdgeMap.containsKey(edge);
        if (written) {
            this.writeAttributePair("xlink:href", "#" + edge.getSUID());
            this.write("/>\n");
        } else {
            this.writtenEdgeMap.put(edge, edge);
            this.writeAttributePair("id", edge.getSUID());
            this.writeAttributePair("label", this.getLabel(net, (CyIdentifiable)edge));
            this.writeAttributePair("source", edge.getSource().getSUID());
            this.writeAttributePair("target", edge.getTarget().getSUID());
            this.writeAttributePair("cy:directed", ObjectTypeMap.toXGMMLBoolean(edge.isDirected()));
            this.write(">\n");
            ++this.depth;
            this.writeAttributes(this.getRowFromNetOrRoot(net, (CyIdentifiable)edge, null));
            this.writeAttributes(this.getRowFromNetOrRoot(net, (CyIdentifiable)edge, "HIDDEN"));
            if (this.networkView != null) {
                this.writeGraphics((View<? extends CyIdentifiable>)this.networkView.getEdgeView(edge), false);
            }
            --this.depth;
            this.writeElement("</edge>\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeGraphics(View<? extends CyIdentifiable> view, boolean groupLockedProperties) throws IOException {
        if (view == null) {
            return;
        }
        this.writeElement("<graphics");
        CyIdentifiable element = (CyIdentifiable)view.getModel();
        VisualProperty root = element instanceof CyNode ? BasicVisualLexicon.NODE : (element instanceof CyEdge ? BasicVisualLexicon.EDGE : BasicVisualLexicon.NETWORK);
        VisualLexicon visualLexicon = this.getVisualLexicon();
        Collection visualProperties = visualLexicon.getAllDescendants(root);
        ArrayList<VisualProperty> attProperties = new ArrayList<VisualProperty>();
        ArrayList<VisualProperty> lockedProperties = new ArrayList<VisualProperty>();
        HashSet<String> writtenKeys = new HashSet<String>();
        for (VisualProperty vp : visualProperties) {
            Object object;
            if (root == BasicVisualLexicon.NETWORK && vp.getTargetDataType() != CyNetwork.class || (object = view.getVisualProperty(vp)) == null) continue;
            if (groupLockedProperties && view.isDirectlyLocked(vp)) {
                lockedProperties.add(vp);
                continue;
            }
            VisualLexiconNode node = visualLexicon.getVisualLexiconNode(vp);
            if (!node.getChildren().isEmpty()) continue;
            String[] keys = this.getGraphicsKey(vp);
            if (keys != null && keys.length > 0) {
                void var12_16;
                try {
                    String string = vp.toSerializableString(object);
                }
                catch (ClassCastException ex) {
                    System.err.println(vp.getDisplayName() + " causes ClassCastEx: " + object.getClass() + ", expected: " + vp.getDefault().getClass().getSimpleName());
                    Object var12_15 = null;
                }
                if (var12_16 == null) continue;
                for (int i = 0; i < keys.length; ++i) {
                    String k = keys[i];
                    if (writtenKeys.contains(k) || this.ignoreGraphicsAttribute(element, k)) continue;
                    this.writeAttributePair(k, var12_16);
                    writtenKeys.add(k);
                }
                continue;
            }
            if (this.ignoreGraphicsAttribute(element, vp.getIdString())) continue;
            attProperties.add(vp);
        }
        Map<String, String> unrecognizedMap = this.unrecognizedVisualPropertyMgr.getUnrecognizedVisualProperties(this.networkView, view);
        if (attProperties.isEmpty() && lockedProperties.isEmpty() && unrecognizedMap.isEmpty()) {
            this.write("/>\n");
        } else {
            this.write(">\n");
            ++this.depth;
            for (VisualProperty visualProperty : attProperties) {
                this.writeVisualPropertyAtt(view, visualProperty);
            }
            for (Map.Entry entry : unrecognizedMap.entrySet()) {
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                if (v == null) continue;
                this.writeAttributeXML(k, ObjectType.STRING, v, false, true);
            }
            if (!lockedProperties.isEmpty()) {
                this.writeAttributeXML("lockedVisualProperties", ObjectType.LIST, null, false, false);
                ++this.depth;
                for (VisualProperty visualProperty : lockedProperties) {
                    this.writeVisualPropertyAtt(view, visualProperty);
                }
                --this.depth;
                this.writeElement("</att>\n");
            }
            --this.depth;
            this.writeElement("</graphics>\n");
        }
    }

    private void writeVisualPropertyAtt(View<? extends CyIdentifiable> view, VisualProperty vp) throws IOException {
        Object value = view.getVisualProperty(vp);
        try {
            if (value instanceof Double && vp instanceof IntegerVisualProperty) {
                int val = (int)Math.round((Double)value);
                value = new Integer(val);
            } else if (value instanceof Integer && vp instanceof DoubleVisualProperty) {
                value = new Double((Double)value);
            }
            value = vp.toSerializableString(value);
        }
        catch (ClassCastException e) {
            logger.error("Error getting serializable string of Visual Property \"" + vp.getIdString() + "\" (value: " + value + ")", (Throwable)e);
            System.err.println("Error getting serializable string of Visual Property \"" + vp.getIdString() + "\" (value: " + value + ")");
            return;
        }
        if (value != null) {
            this.writeAttributeXML(vp.getIdString(), ObjectType.STRING, value, false, true);
        }
    }

    private String getDirectionality() {
        boolean directed = false;
        for (CyEdge edge : this.network.getEdgeList()) {
            if (!edge.isDirected()) continue;
            directed = true;
            break;
        }
        return ObjectTypeMap.toXGMMLBoolean(directed);
    }

    protected boolean ignoreGraphicsAttribute(CyIdentifiable element, String attName) {
        return false;
    }

    private String[] getGraphicsKey(VisualProperty<?> vp) {
        if (vp.equals((Object)BasicVisualLexicon.NODE_X_LOCATION)) {
            return new String[]{"x"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_Y_LOCATION)) {
            return new String[]{"y"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_Z_LOCATION)) {
            return new String[]{"z"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_SIZE)) {
            return new String[]{"w", "h"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_WIDTH)) {
            return new String[]{"w"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_HEIGHT)) {
            return new String[]{"h"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_FILL_COLOR)) {
            return new String[]{"fill"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_SHAPE)) {
            return new String[]{"type"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_BORDER_WIDTH)) {
            return new String[]{"width"};
        }
        if (vp.equals((Object)BasicVisualLexicon.NODE_BORDER_PAINT)) {
            return new String[]{"outline"};
        }
        if (vp.equals((Object)BasicVisualLexicon.EDGE_WIDTH)) {
            return new String[]{"width"};
        }
        if (vp.equals((Object)BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT)) {
            return new String[]{"fill"};
        }
        return new String[0];
    }

    protected void writeAttributes(CyRow row) throws IOException {
        if (row != null) {
            CyTable table = row.getTable();
            for (CyColumn column : table.getColumns()) {
                if ("SUID".equals(column.getName())) continue;
                this.writeAttribute(row, column.getName());
            }
        }
    }

    protected void writeAttribute(CyRow row, String attName) throws IOException {
        CyTable table = row.getTable();
        CyColumn column = table.getColumn(attName);
        if (column == null) {
            return;
        }
        boolean hidden = !table.isPublic();
        Class attType = column.getType();
        if (attType == Double.class) {
            Double dAttr = (Double)row.get(attName, Double.class);
            this.writeAttributeXML(attName, ObjectType.REAL, dAttr, hidden, true);
        } else if (attType == Integer.class) {
            Integer iAttr = (Integer)row.get(attName, Integer.class);
            this.writeAttributeXML(attName, ObjectType.INTEGER, iAttr, hidden, true);
        } else if (attType == Long.class) {
            Long lAttr = (Long)row.get(attName, Long.class);
            this.writeAttributeXML(attName, ObjectType.LONG, lAttr, hidden, true);
        } else if (attType == String.class) {
            String sAttr = (String)row.get(attName, String.class);
            if (sAttr != null) {
                sAttr = sAttr.replace("\n", "\\n");
                sAttr = sAttr.replace("\t", "\\t");
            }
            this.writeAttributeXML(attName, ObjectType.STRING, sAttr, hidden, true);
        } else if (attType == Boolean.class) {
            Boolean bAttr = (Boolean)row.get(attName, Boolean.class);
            this.writeAttributeXML(attName, ObjectType.BOOLEAN, ObjectTypeMap.toXGMMLBoolean(bAttr), hidden, true);
        } else if (attType == List.class) {
            List listAttr = row.getList(attName, column.getListElementType());
            ObjectType elementType = this.getObjectType(column.getListElementType());
            this.writeAttributeXML(attName, ObjectType.LIST, elementType, null, hidden, false);
            if (listAttr != null) {
                ++this.depth;
                for (Object obj : listAttr) {
                    String sAttr = null;
                    if (obj instanceof Boolean) {
                        sAttr = ObjectTypeMap.toXGMMLBoolean((Boolean)obj);
                    } else {
                        sAttr = obj.toString();
                        if (sAttr != null) {
                            sAttr = sAttr.replace("\n", "\\n");
                            sAttr = sAttr.replace("\t", "\\t");
                        }
                    }
                    this.writeAttributeXML(attName, this.getObjectType(obj), sAttr, hidden, true);
                }
                --this.depth;
            }
            this.writeAttributeXML(null, null, null, hidden, true);
        }
    }

    protected void writeAttributeXML(String name, ObjectType type, Object value, boolean hidden, boolean end) throws IOException {
        this.writeAttributeXML(name, type, null, value, hidden, end);
    }

    protected void writeAttributeXML(String name, ObjectType type, ObjectType listType, Object value, boolean hidden, boolean end) throws IOException {
        if (name == null && type == null) {
            this.writeElement("</att>\n");
        } else {
            this.writeElement("<att");
            if (name != null) {
                this.writeAttributePair("name", name);
            }
            if (value != null) {
                this.writeAttributePair("value", value);
            }
            this.writeAttributePair("type", type.getXgmmlValue());
            this.writeAttributePair("cy:type", type.getCyValue());
            if (type == ObjectType.LIST && listType != null) {
                this.writeAttributePair("cy:elementType", listType.getCyValue());
            }
            if (hidden) {
                this.writeAttributePair("cy:hidden", ObjectTypeMap.toXGMMLBoolean(hidden));
            }
            if (end) {
                this.write("/>\n");
            } else {
                this.write(">\n");
            }
        }
    }

    protected void write(String str) throws IOException {
        this.writer.write(str);
    }

    protected void writeAttributePair(String name, Object value) throws IOException {
        this.write(" " + name + "=" + this.quote(value.toString()));
    }

    protected void writeElement(String line) throws IOException {
        while (this.depth * 2 > this.indentString.length() - 1) {
            this.indentString = this.indentString + "                        ";
        }
        this.writer.write(this.indentString, 0, this.depth * 2);
        this.writer.write(line);
    }

    protected VisualLexicon getVisualLexicon() {
        if (this.visualLexicon == null) {
            this.visualLexicon = ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getDefaultVisualLexicon();
        }
        return this.visualLexicon;
    }

    private ObjectType getObjectType(Object obj) {
        return this.getObjectType(obj.getClass());
    }

    private ObjectType getObjectType(Class<?> type) {
        if (type == String.class) {
            return ObjectType.STRING;
        }
        if (type == Integer.class) {
            return ObjectType.INTEGER;
        }
        if (type == Long.class) {
            return ObjectType.LONG;
        }
        if (type == Double.class || type == Float.class) {
            return ObjectType.REAL;
        }
        if (type == Boolean.class) {
            return ObjectType.BOOLEAN;
        }
        if (type == List.class) {
            return ObjectType.LIST;
        }
        return null;
    }

    protected String getLabel(CyNetwork network, CyIdentifiable entry) {
        String label = this.encode((String)this.getRowFromNetOrRoot(network, entry, null).get("name", String.class));
        if (label == null || label.isEmpty()) {
            label = Long.toString(entry.getSUID());
        }
        return label;
    }

    protected String getLabel(CyNetworkView view) {
        String label = (String)view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        if (label == null || label.isEmpty()) {
            label = Long.toString(view.getSUID());
        }
        return label;
    }

    protected CyRow getRowFromNetOrRoot(CyNetwork network, CyIdentifiable entry, String namespace) {
        CyRow row = null;
        try {
            row = namespace == null ? network.getRow(entry) : network.getRow(entry, namespace);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (RuntimeException e) {
            logger.error("Cannot get \"" + namespace + "\" row for entry \"" + entry + "\" in network \"" + network + "\".", (Throwable)e);
        }
        if (row == null && network instanceof CySubNetwork) {
            CyRootNetwork root = ((CySubNetwork)network).getRootNetwork();
            row = namespace == null ? root.getRow(entry) : root.getRow(entry, namespace);
        }
        return row;
    }

    private String encode(String str) {
        String s = null;
        if (str != null) {
            StringBuilder sb = new StringBuilder(str.length());
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c < ' ' || c > '~') {
                    if (this.doFullEncoding) {
                        sb.append("&#x");
                        sb.append(Integer.toHexString(c));
                        sb.append(";");
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                if (c == '\'') {
                    sb.append("&apos;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    sb.append("&gt;");
                    continue;
                }
                sb.append(c);
            }
            s = sb.toString();
        }
        return s;
    }

    private String quote(String str) {
        return "\"" + this.encode(str) + "\"";
    }

    private void setVisualStyle(VisualStyle visualStyle) {
        this.visualStyle = visualStyle;
    }

    protected Set<CySubNetwork> getSerializableSubNetworks(CyRootNetwork rootNet) {
        LinkedHashSet<CySubNetwork> serializableSet = new LinkedHashSet<CySubNetwork>();
        List subNetList = rootNet.getSubNetworkList();
        CySubNetwork baseNetwork = rootNet.getBaseNetwork();
        if (this.isSerializable((CyNetwork)baseNetwork)) {
            serializableSet.add(baseNetwork);
        }
        for (CySubNetwork sn : subNetList) {
            if (!this.isSerializable((CyNetwork)sn)) continue;
            serializableSet.add(sn);
        }
        return serializableSet;
    }

    protected boolean isSerializable(CyNetwork net) {
        return net.getSavePolicy() != SavePolicy.DO_NOT_SAVE;
    }

    protected boolean isRegistered(CyNetwork net) {
        return ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).networkExists(net.getSUID().longValue());
    }
}

