/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics.command;

import java.io.File;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.work.Tunable;

public class ExportNetworkTunables {
    static final String _CY_NETWORK_VIEW_DESC = "Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.";
    private final CyServiceRegistrar serviceRegistrar;
    private RenderingEngine<?> re;
    @Tunable(longDescription="The path name of the file where the view must be saved to.", exampleStringValue="/Users/johndoe/Downloads/View1.png")
    public File outputFile;
    public CyNetworkView view = null;

    public ExportNetworkTunables(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    @Tunable(description="Network View to export", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="CURRENT")
    public CyNetworkView getView() {
        return this.view;
    }

    public void setView(CyNetworkView view) {
        this.view = view;
        if (view != null) {
            RenderingEngine engine = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentRenderingEngine();
            String engineId = view.getRendererId();
            RenderingEngineManager engineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
            for (RenderingEngine e : engineManager.getRenderingEngines((View)view)) {
                if (!engineId.equals(e.getRendererId())) continue;
                engine = e;
                break;
            }
            this.re = engine;
        }
    }

    public RenderingEngine<?> getRenderingEngine() {
        return this.re;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getOutPath() {
        return this.outputFile == null ? null : this.outputFile.getAbsolutePath();
    }
}

