/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics.command;

import org.cytoscape.io.internal.write.graphics.command.ExportNetworkJPGTask;
import org.cytoscape.io.internal.write.graphics.command.ExportNetworkPDFTask;
import org.cytoscape.io.internal.write.graphics.command.ExportNetworkPNGTask;
import org.cytoscape.io.internal.write.graphics.command.ExportNetworkPSTask;
import org.cytoscape.io.internal.write.graphics.command.ExportNetworkSVGTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ExportNetworkTaskFactory
extends AbstractTaskFactory {
    private final CyServiceRegistrar registrar;
    private final Format format;

    public ExportNetworkTaskFactory(CyServiceRegistrar registrar, Format format) {
        this.registrar = registrar;
        this.format = format;
    }

    public TaskIterator createTaskIterator() {
        Task[] taskArray = new Task[1];
        taskArray[0] = switch (this.format) {
            default -> throw new IncompatibleClassChangeError();
            case Format.PNG -> new ExportNetworkPNGTask(this.registrar);
            case Format.JPG -> new ExportNetworkJPGTask(this.registrar);
            case Format.PDF -> new ExportNetworkPDFTask(this.registrar);
            case Format.SVG -> new ExportNetworkSVGTask(this.registrar);
            case Format.PS -> new ExportNetworkPSTask(this.registrar);
        };
        return new TaskIterator(taskArray);
    }

    public static enum Format {
        PNG,
        JPG,
        PDF,
        SVG,
        PS;


        public boolean isPDF() {
            return this == PDF;
        }

        public boolean hasAllGraphicsDetails() {
            return this == PNG || this == JPG;
        }

        public String nameLower() {
            return this.name().toLowerCase();
        }
    }
}

