/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics.command;

import java.io.OutputStream;
import org.cytoscape.io.internal.write.graphics.PDFWriter;
import org.cytoscape.io.internal.write.graphics.command.AbstractExportNetworkImageTask;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class ExportNetworkPDFTask
extends AbstractExportNetworkImageTask {
    @Tunable(longDescription="If true (the default value), texts will be exported as fonts.", exampleStringValue="true")
    public boolean exportTextAsFont = true;
    @Tunable(longDescription="If true then node and edge labels will not be visible in the image.", exampleStringValue="false")
    public boolean hideLabels;
    public ListSingleSelection<String> pageSize;
    public ListSingleSelection<String> orientation = new ListSingleSelection((Object[])new String[]{"Portrait", "Landscape"});

    @Tunable(description="Page Size:", longDescription="Predefined standard page size, or choose custom. Default is 'Letter'.", exampleStringValue="Letter")
    public ListSingleSelection<String> getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(ListSingleSelection<String> pageSize) {
        this.pageSize = pageSize;
    }

    @Tunable(longDescription="Page orientation, portrait or landscape.", exampleStringValue="Portrait")
    public ListSingleSelection<String> getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ListSingleSelection<String> orientation) {
        this.orientation = orientation;
    }

    public ExportNetworkPDFTask(CyServiceRegistrar registrar) {
        super(registrar);
        this.pageSize = new ListSingleSelection((Object[])new String[]{PDFWriter.PreDefinedPageSize.AUTO.label, PDFWriter.PreDefinedPageSize.LETTER.label, PDFWriter.PreDefinedPageSize.LEGAL.label, PDFWriter.PreDefinedPageSize.TABLOID.label, PDFWriter.PreDefinedPageSize.A0.label, PDFWriter.PreDefinedPageSize.A1.label, PDFWriter.PreDefinedPageSize.A2.label, PDFWriter.PreDefinedPageSize.A3.label, PDFWriter.PreDefinedPageSize.A4.label, PDFWriter.PreDefinedPageSize.A5.label});
        this.pageSize.setSelectedValue((Object)PDFWriter.PreDefinedPageSize.LETTER.label);
    }

    @Override
    CyWriter createWriter(RenderingEngine<?> re, OutputStream outStream) {
        PDFWriter writer = new PDFWriter(re, outStream);
        writer.exportTextAsFont = this.exportTextAsFont;
        writer.hideLabels = this.hideLabels;
        writer.pageSize.setSelectedValue((Object)((String)this.pageSize.getSelectedValue()));
        writer.orientation.setSelectedValue((Object)((String)this.orientation.getSelectedValue()));
        return writer;
    }
}

