/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics.command;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.cytoscape.io.internal.write.graphics.command.ExportNetworkTunables;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public abstract class AbstractExportNetworkImageTask
extends AbstractTask
implements ObservableTask {
    @ContainsTunables
    public ExportNetworkTunables tunables;

    public AbstractExportNetworkImageTask(CyServiceRegistrar registrar) {
        this.tunables = new ExportNetworkTunables(registrar);
    }

    abstract CyWriter createWriter(RenderingEngine<?> var1, OutputStream var2);

    public void run(TaskMonitor tm) throws Exception {
        final FileOutputStream outputStream = new FileOutputStream(this.tunables.getOutputFile());
        RenderingEngine<?> renderingEngine = this.tunables.getRenderingEngine();
        CyWriter writeTask = this.createWriter(renderingEngine, outputStream);
        AbstractTask closeTask = new AbstractTask(){

            public void run(TaskMonitor tm) throws IOException {
                outputStream.close();
            }
        };
        this.insertTasksAfterCurrentTask(new Task[]{writeTask, closeTask});
    }

    public List<Class<?>> getResultClasses() {
        return List.of(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        String outPath = this.tunables.getOutPath();
        if (type == String.class) {
            String res = outPath == null ? null : "Output File: " + outPath;
            return type.cast(res);
        }
        if (type == JSONResult.class) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("file", outPath);
            String json = new Gson().toJson((JsonElement)jsonObj);
            JSONResult res = () -> json;
            return type.cast(res);
        }
        return null;
    }
}

