/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFWriter
extends AbstractTask
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final int UNITS_PER_INCH = 72;
    public static final String PORTRAIT = "Portrait";
    public static final String LANDSCAPE = "Landscape";
    @Tunable(description="Export text as font:", longDescription="If true (the default value), texts will be exported as fonts.", groups={"_Others"}, gravity=2.1)
    public boolean exportTextAsFont = true;
    @Tunable(description="Hide Labels:", longDescription="If true then node and edge labels will not be visible in the image.", exampleStringValue="true", groups={"_Others"}, gravity=2.2)
    public boolean hideLabels;
    public ListSingleSelection<String> pageSize;
    public ListSingleSelection<String> orientation = new ListSingleSelection((Object[])new String[]{"Portrait", "Landscape"});
    public float customWidthInches = PageSize.LETTER.getWidth() / 72.0f;
    public float customHeightInches = PageSize.LETTER.getHeight() / 72.0f;
    private final Double networkWidth;
    private final Double networkHeight;
    private final RenderingEngine<?> engine;
    private final OutputStream stream;

    @Tunable(description="Page Size:", longDescription="Predefined standard page size, or choose custom.", exampleStringValue="Letter", groups={"Page Size"}, gravity=1.1)
    public ListSingleSelection<String> getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(ListSingleSelection<String> pageSize) {
        this.pageSize = pageSize;
    }

    @Tunable(description="Orientation:", longDescription="Page orientation, portrait or landscape.", exampleStringValue="Portrait", groups={"Page Size"}, dependsOn="PageSize!=Custom", gravity=1.2)
    public ListSingleSelection<String> getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ListSingleSelection<String> orientation) {
        this.orientation = orientation;
    }

    @Tunable(description="Width (inches):", longDescription="The width (in inches) of the exported image when pageSize=Custom.", exampleStringValue="10.0", groups={"Page Size"}, params="alignments=vertical", listenForChange={"PageSize", "Orientation"}, dependsOn="PageSize=Custom", gravity=1.3)
    public float getCustomWidthInches() {
        return this.getPageSizeInches(true);
    }

    public void setCustomWidthInches(float width) {
        this.customWidthInches = width;
    }

    @Tunable(description="Height (inches):", longDescription="The height (in inches) of the exported image when pageSize=Custom.", exampleStringValue="10.0", groups={"Page Size"}, params="alignments=vertical", listenForChange={"PageSize", "Orientation"}, dependsOn="PageSize=Custom", gravity=1.4)
    public float getCustomHeightInches() {
        return this.getPageSizeInches(false);
    }

    public void setCustomHeightInches(float height) {
        this.customHeightInches = height;
    }

    private float getPageSizeInches(boolean width) {
        PreDefinedPageSize pageSize = PreDefinedPageSize.fromLabel((String)this.pageSize.getSelectedValue());
        if (pageSize == PreDefinedPageSize.AUTO) {
            float inches = (width ? this.networkWidth.floatValue() : this.networkHeight.floatValue()) / 72.0f;
            return new BigDecimal(inches).setScale(1, RoundingMode.HALF_UP).floatValue();
        }
        if (pageSize == PreDefinedPageSize.CUSTOM) {
            return width ? this.customWidthInches : this.customHeightInches;
        }
        if (LANDSCAPE.equals(this.orientation.getSelectedValue())) {
            width = !width;
        }
        float inches = (width ? pageSize.size.getWidth() : pageSize.size.getHeight()) / 72.0f;
        return new BigDecimal(inches).setScale(1, RoundingMode.HALF_UP).floatValue();
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Network";
    }

    public PDFWriter(RenderingEngine<?> engine, OutputStream stream) {
        if (engine == null) {
            throw new NullPointerException("Rendering Engine is null.");
        }
        if (stream == null) {
            throw new NullPointerException("Stream is null.");
        }
        this.engine = engine;
        this.stream = stream;
        this.pageSize = new ListSingleSelection((Object[])new String[]{PreDefinedPageSize.AUTO.label, PreDefinedPageSize.CUSTOM.label, PreDefinedPageSize.LETTER.label, PreDefinedPageSize.LEGAL.label, PreDefinedPageSize.TABLOID.label, PreDefinedPageSize.A0.label, PreDefinedPageSize.A1.label, PreDefinedPageSize.A2.label, PreDefinedPageSize.A3.label, PreDefinedPageSize.A4.label, PreDefinedPageSize.A5.label});
        this.pageSize.setSelectedValue((Object)PreDefinedPageSize.LETTER.label);
        this.networkWidth = (Double)engine.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
        this.networkHeight = (Double)engine.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
        logger.debug("PDFWriter created.");
    }

    private Rectangle computePageDimensions() {
        PreDefinedPageSize pageSize = PreDefinedPageSize.fromLabel((String)this.pageSize.getSelectedValue());
        String orientation = (String)this.orientation.getSelectedValue();
        if (pageSize == PreDefinedPageSize.AUTO) {
            return new Rectangle(this.networkWidth.floatValue(), this.networkHeight.floatValue());
        }
        if (pageSize == PreDefinedPageSize.CUSTOM) {
            return new Rectangle(this.customWidthInches * 72.0f, this.customHeightInches * 72.0f);
        }
        if (LANDSCAPE.equals(orientation)) {
            return new Rectangle(pageSize.size.getHeight(), pageSize.size.getWidth());
        }
        return pageSize.size;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("PDF Writer");
        tm.setStatusMessage("Creating PDF image...");
        tm.setProgress(0.0);
        logger.debug("PDF Rendering start");
        Rectangle dimensions = this.computePageDimensions();
        Document document = new Document(dimensions);
        logger.debug("Document created: " + document);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.stream);
        document.open();
        tm.setProgress(0.1);
        PdfContentByte canvas = writer.getDirectContent();
        logger.debug("CB0 created: " + canvas.getClass());
        float pageWidth = dimensions.getWidth();
        float pageHeight = dimensions.getHeight();
        logger.debug("Page W: " + pageWidth + " Page H: " + pageHeight);
        DefaultFontMapper fontMapper = new DefaultFontMapper();
        logger.debug("FontMapper created = " + fontMapper);
        Graphics2D g = null;
        logger.debug("!!!!! Enter block 2");
        tm.setProgress(0.2);
        g = this.exportTextAsFont ? canvas.createGraphics(pageWidth, pageHeight, (FontMapper)new DefaultFontMapper()) : canvas.createGraphicsShapes(pageWidth, pageHeight);
        tm.setProgress(0.4);
        logger.debug("##### G2D created: " + g);
        double imageScale = Math.min((double)dimensions.getWidth() / this.networkWidth, (double)dimensions.getHeight() / this.networkHeight);
        g.scale(imageScale, imageScale);
        logger.debug("##### Start Rendering Phase 2: " + this.engine.toString());
        Map<String, String> props = Map.of("exportTextAsShape", String.valueOf(!this.exportTextAsFont), "exportHideLabels", String.valueOf(this.hideLabels), "pdf", "true");
        this.engine.printCanvas((Graphics)g, props);
        logger.debug("##### Canvas Rendering Done: ");
        tm.setProgress(0.8);
        g.dispose();
        document.close();
        writer.close();
        this.stream.close();
        logger.debug("PDF rendering finished.");
        tm.setProgress(1.0);
    }

    public static enum PreDefinedPageSize {
        AUTO("Auto"),
        CUSTOM("Custom"),
        LETTER("Letter", PageSize.LETTER),
        LEGAL("Legal", PageSize.LEGAL),
        TABLOID("Tabloid", PageSize.TABLOID),
        A0("A0", PageSize.A0),
        A1("A1", PageSize.A1),
        A2("A2", PageSize.A2),
        A3("A3", PageSize.A3),
        A4("A4", PageSize.A4),
        A5("A5", PageSize.A5);

        public final Rectangle size;
        public final String label;

        private PreDefinedPageSize(String label, Rectangle size) {
            this.size = size;
            this.label = label;
        }

        private PreDefinedPageSize(String label) {
            this(label, null);
        }

        static PreDefinedPageSize fromLabel(String label) {
            for (PreDefinedPageSize ps : PreDefinedPageSize.values()) {
                if (!ps.label.equals(label)) continue;
                return ps;
            }
            return null;
        }
    }
}

