/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics;

import java.io.OutputStream;
import java.util.Set;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.internal.write.AbstractCyWriterFactory;
import org.cytoscape.io.internal.write.graphics.BitmapWriter;
import org.cytoscape.io.internal.write.graphics.PNGWriter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.PresentationWriterFactory;
import org.cytoscape.view.presentation.RenderingEngine;

public class BitmapWriterFactory
extends AbstractCyWriterFactory
implements PresentationWriterFactory {
    public BitmapWriterFactory(CyFileFilter bitmapFilter) {
        super(bitmapFilter);
    }

    public CyWriter createWriter(OutputStream outputStream, RenderingEngine<?> re) {
        if (re == null) {
            throw new NullPointerException("RenderingEngine is null");
        }
        Set contentTypes = this.getFileFilter().getContentTypes();
        if (contentTypes.size() == 1 && "image/png".equalsIgnoreCase((String)contentTypes.iterator().next())) {
            return new PNGWriter(re, outputStream, this.getFileFilter().getExtensions());
        }
        return new BitmapWriter(re, outputStream, this.getFileFilter().getExtensions());
    }
}

