/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapWriter
extends AbstractTask
implements CyWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final double MAX_ZOOM = 500.0;
    private static final int DEFAULT_RESOLUTION = 72;
    private static final List<Integer> RESOLUTION_VALUES = Arrays.asList(72, 100, 150, 300, 600);
    private static final String PIXELS = "pixels";
    private static final String INCHES = "inches";
    protected Map<String, String> renderProps = new HashMap<String, String>();
    @Tunable(description="Show All Graphics Details:", longDescription="If true the exported image detail will be high. If false then the image detail may be decreased so that the image export is faster.", exampleStringValue="true", groups={"_Others"}, gravity=2.0)
    public boolean allGraphicsDetails = true;
    @Tunable(description="Hide Labels:", longDescription="If true then node and edge labels will not be visible in the image.", exampleStringValue="true", groups={"_Others"}, gravity=2.2)
    public boolean hideLabels;
    public BoundedDouble zoom;
    public ListSingleSelection<String> units = new ListSingleSelection((Object[])new String[]{"pixels", "inches"});
    public int widthInPixels;
    public double widthInInches;
    public int heightInPixels;
    public double heightInInches;
    public ListSingleSelection<Integer> resolution;
    private final OutputStream outStream;
    protected final RenderingEngine<?> re;
    private String extension;
    private int initialWPixel;
    private int initialHPixel;

    @ProvidesTitle
    public String getTitle() {
        return "Image Parameters";
    }

    @Tunable(description="Zoom (%):", longDescription="The zoom value to proportionally scale the image. The default value is ```100.0```. Valid only for bitmap formats, such as PNG and JPEG.", exampleStringValue="200.0", groups={"Image Size"}, params="alignments=vertical;slider=true", listenForChange={"WidthInPixels", "HeightInPixels", "WidthInInches", "HeightInInches"}, format="###.##'%'", gravity=1.0)
    public BoundedDouble getZoom() {
        return this.zoom;
    }

    public void setZoom(BoundedDouble zf) {
        this.zoom = zf;
        this.heightInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialHPixel);
        this.widthInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialWPixel);
        double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
        this.widthInInches = (double)this.widthInPixels / dpi;
        this.heightInInches = (double)this.heightInPixels / dpi;
    }

    @Tunable(description="Units:", longDescription="The units for the 'width' and 'height' values. Valid only for bitmap formats, such as PNG and JPEG. The possible values are: ```pixels``` (default), ```inches```.", exampleStringValue="inches", groups={"Image Size"}, gravity=1.05)
    public ListSingleSelection<String> getUnits() {
        return this.units;
    }

    public void setUnits(ListSingleSelection<String> units) {
        this.units = units;
    }

    @Tunable(description="Width:", longDescription="The width of the exported image. Valid only for bitmap formats, such as PNG and JPEG.", exampleStringValue="800.0", groups={"Image Size"}, params="alignments=vertical", listenForChange={"Zoom", "Units", "Height", "Resolution"}, gravity=1.1)
    public Double getWidth() {
        if (PIXELS.equals(this.units.getSelectedValue())) {
            return this.widthInPixels;
        }
        return this.widthInInches;
    }

    public void setWidth(Double width) {
        if (PIXELS.equals(this.units.getSelectedValue())) {
            this.zoom.setValue((Comparable)Double.valueOf((double)width.intValue() / (double)this.initialWPixel * 100.0));
            this.widthInPixels = width.intValue();
            this.heightInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialHPixel);
            double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
            this.widthInInches = (double)this.widthInPixels / dpi;
            this.heightInInches = (double)this.heightInPixels / dpi;
        } else {
            double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
            this.zoom.setValue((Comparable)Double.valueOf(width * dpi / (double)this.initialWPixel * 100.0));
            this.widthInInches = width;
            this.widthInPixels = (int)(this.widthInInches * dpi);
            this.heightInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialHPixel);
            this.heightInInches = (double)this.heightInPixels / dpi;
        }
    }

    @Tunable(description="Height:", longDescription="The height of the exported image. Valid only for bitmap formats, such as PNG and JPEG.", exampleStringValue="600.0", groups={"Image Size"}, params="alignments=vertical", listenForChange={"Zoom", "Units", "Width", "Resolution"}, gravity=1.2)
    public Double getHeight() {
        if (PIXELS.equals(this.units.getSelectedValue())) {
            return this.heightInPixels;
        }
        return this.heightInInches;
    }

    public void setHeight(Double height) {
        if (PIXELS.equals(this.units.getSelectedValue())) {
            this.zoom.setValue((Comparable)Double.valueOf((double)height.intValue() / (double)this.initialHPixel * 100.0));
            this.widthInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialWPixel);
            this.heightInPixels = height.intValue();
            double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
            this.widthInInches = (double)this.widthInPixels / dpi;
            this.heightInInches = (double)this.heightInPixels / dpi;
        } else {
            double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
            this.zoom.setValue((Comparable)Double.valueOf(height * dpi / (double)this.initialHPixel * 100.0));
            this.heightInPixels = (int)(height * dpi);
            this.heightInInches = height;
            this.widthInPixels = (int)((Double)this.zoom.getValue() / 100.0 * (double)this.initialWPixel);
            this.widthInInches = (double)this.widthInPixels / dpi;
        }
    }

    @Tunable(description="Resolution (DPI):", longDescription="The resolution of the exported image, in DPI. Valid only for bitmap formats, when the selected width and height 'units' is ```inches```. The possible values are: ```72``` (default), ```100```, ```150```, ```300```, ```600```.", exampleStringValue="72", groups={"Image Size"}, params="alignments=vertical", dependsOn="Units=inches", gravity=1.5)
    public ListSingleSelection<Integer> getResolution() {
        return this.resolution;
    }

    public void setResolution(ListSingleSelection<Integer> rescb) {
        double dpi = ((Integer)this.resolution.getSelectedValue()).doubleValue();
        this.widthInInches = (double)this.widthInPixels / dpi;
        this.heightInInches = (double)this.heightInPixels / dpi;
    }

    public BitmapWriter(RenderingEngine<?> re, OutputStream outStream, Set<String> extensions) {
        this.re = re;
        this.outStream = outStream;
        this.setExtension(extensions);
        this.zoom = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(100.0), Double.valueOf(500.0), false, false);
        this.initialWPixel = ((Double)re.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH)).intValue();
        this.initialHPixel = ((Double)re.getViewModel().getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT)).intValue();
        this.widthInPixels = this.initialWPixel;
        this.heightInPixels = this.initialHPixel;
        this.resolution = new ListSingleSelection(RESOLUTION_VALUES);
        this.resolution.setSelectedValue((Object)72);
        double dpi = 72.0;
        this.widthInInches = (double)this.initialWPixel / dpi;
        this.heightInInches = (double)this.initialHPixel / dpi;
    }

    private void setExtension(Set<String> extensions) {
        for (String format : ImageIO.getWriterFormatNames()) {
            for (String ext : extensions) {
                if (!format.equals(ext)) continue;
                this.extension = format;
                return;
            }
        }
        throw new IllegalArgumentException("Image format (" + extensions.toString() + ") NOT supported by ImageIO");
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Bitmap Image Writer");
        tm.setStatusMessage("Creating image...");
        tm.setProgress(0.0);
        logger.debug("Bitmap image rendering start.");
        this.renderProps.put("exportHideLabels", String.valueOf(this.hideLabels));
        this.renderProps.put("highDetail", String.valueOf(this.allGraphicsDetails));
        this.writeImage(tm);
        logger.debug("Bitmap image rendering finished.");
        tm.setProgress(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(TaskMonitor tm) throws Exception {
        BufferedImage image = new BufferedImage(this.widthInPixels, this.heightInPixels, this.getImageType());
        Graphics2D g = (Graphics2D)image.getGraphics();
        double scale = (Double)this.zoom.getValue() / 100.0;
        g.scale(scale, scale);
        tm.setProgress(0.2);
        this.re.printCanvas((Graphics)g, this.renderProps);
        tm.setProgress(0.4);
        g.dispose();
        try {
            tm.setStatusMessage("Writing " + this.extension + "...");
            ImageIO.write((RenderedImage)image, this.extension, this.outStream);
        }
        finally {
            this.outStream.close();
        }
    }

    protected int getImageType() {
        return 1;
    }
}

