/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.write.AbstractWriterManager;
import org.cytoscape.io.internal.write.graphics.BitmapWriter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.PresentationWriterFactory;
import org.cytoscape.io.write.PresentationWriterManager;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.properties.TunablePropertySerializer;
import org.cytoscape.work.properties.TunablePropertySerializerFactory;

public class PresentationWriterManagerImpl
extends AbstractWriterManager<PresentationWriterFactory>
implements PresentationWriterManager {
    private final CyServiceRegistrar registrar;
    private final Map<String, CyProperty<Properties>> registeredPropertyServices = new HashMap<String, CyProperty<Properties>>();

    public PresentationWriterManagerImpl(CyServiceRegistrar registrar) {
        super(DataCategory.IMAGE);
        this.registrar = registrar;
    }

    public CyWriter getWriter(View<?> view, RenderingEngine<?> re, CyFileFilter filter, File outFile) throws Exception {
        return this.getWriter(view, re, filter, new FileOutputStream(outFile));
    }

    public CyWriter getWriter(View<?> view, RenderingEngine<?> re, CyFileFilter filter, OutputStream os) throws Exception {
        PresentationWriterFactory tf = (PresentationWriterFactory)this.getMatchingFactory(filter);
        if (tf == null) {
            throw new NullPointerException("Couldn't find matching factory for filter: " + filter);
        }
        CyWriter writer = tf.createWriter(os, re);
        this.loadTunablePropertyValues(writer);
        return new WrappedCyWriter(writer);
    }

    public void saveTunablePropertyValues(CyWriter writer) {
        TunablePropertySerializerFactory serializerFactory = (TunablePropertySerializerFactory)this.registrar.getService(TunablePropertySerializerFactory.class);
        TunablePropertySerializer serializer = serializerFactory.createSerializer();
        Properties props = serializer.toProperties((Object)writer);
        if (writer instanceof BitmapWriter) {
            props.remove("Height");
            props.remove("Width");
            props.remove("height");
            props.remove("width");
        }
        CyProperty<Properties> cyProperty = this.getPropertyService(writer);
        ((Properties)cyProperty.getProperties()).clear();
        ((Properties)cyProperty.getProperties()).putAll((Map<?, ?>)props);
    }

    public void loadTunablePropertyValues(CyWriter writer) {
        CyProperty<Properties> cyProperty = this.getPropertyService(writer);
        Properties props = (Properties)cyProperty.getProperties();
        if (!props.isEmpty()) {
            TunablePropertySerializerFactory serializerFactory = (TunablePropertySerializerFactory)this.registrar.getService(TunablePropertySerializerFactory.class);
            TunablePropertySerializer serializer = serializerFactory.createSerializer();
            serializer.setTunables((Object)writer, props);
        }
    }

    private synchronized CyProperty<Properties> getPropertyService(CyWriter writer) {
        String key = writer.getClass().getCanonicalName();
        Object service = this.registeredPropertyServices.get(key);
        if (service == null) {
            service = PropsReader.forCyWriter(writer);
            Properties serviceProps = new Properties();
            serviceProps.setProperty("cyPropertyName", service.getName());
            this.registrar.registerAllServices(service, serviceProps);
            this.registeredPropertyServices.put(key, (CyProperty<Properties>)service);
        }
        return service;
    }

    public class WrappedCyWriter
    implements CyWriter {
        @ContainsTunables
        public CyWriter cywriter;

        public WrappedCyWriter(CyWriter writer) {
            this.cywriter = writer;
        }

        public void run(TaskMonitor tm) throws Exception {
            this.cywriter.run(tm);
            PresentationWriterManagerImpl.this.saveTunablePropertyValues(this.cywriter);
        }

        public void cancel() {
            this.cywriter.cancel();
        }
    }

    private static class PropsReader
    extends AbstractConfigDirPropsReader {
        public PropsReader(String name, String fileName) {
            super(name, fileName, CyProperty.SavePolicy.CONFIG_DIR);
        }

        public static PropsReader forCyWriter(CyWriter writer) {
            Object name = writer.getClass().getCanonicalName();
            if (name == null) {
                return null;
            }
            name = "writer." + (String)name;
            return new PropsReader((String)name, (String)name + ".props");
        }
    }
}

