/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util.session;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    public static final String CYS_VERSION = "3.0.0";
    public static final String CYSESSION_VERSION = "3.0";
    public static final String NETWORKS_FOLDER = "networks/";
    public static final String NETWORK_VIEWS_FOLDER = "views/";
    public static final String PROPERTIES_FOLDER = "properties/";
    public static final String TABLES_FOLDER = "tables/";
    public static final String IMAGES_FOLDER = "images/";
    public static final String APPS_FOLDER = "apps/";
    public static final String BOOKMARKS_FILE = "session_bookmarks.xml";
    public static final String CYSESSION_FILE = "cysession.xml";
    public static final String VIZMAP_PROPS_FILE = "vizmap.props";
    public static final String VIZMAP_XML_FILE = "vizmap.xml";
    public static final String CYTABLE_STATE_FILE = "cytables.xml";
    public static final String PROPERTIES_EXT = ".props";
    public static final String TABLE_EXT = ".cytable";
    public static final String VERSION_EXT = ".version";
    public static final String XGMML_EXT = ".xgmml";
    public static final String NETWORK_ROOT = "Network Root";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8").replace("-", "%2D");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unescape(String escapedText) {
        try {
            return URLDecoder.decode(escapedText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getNetworkTableFilename(CyNetwork network, CyTableMetadata metadata) throws UnsupportedEncodingException {
        CyTable table = metadata.getTable();
        Long networkId = network.getSUID();
        String networkFileName = SessionUtil.getNetworkFileName(network);
        String namespace = SessionUtil.escape(metadata.getNamespace());
        String type = SessionUtil.escape(metadata.getType().getCanonicalName());
        String tableTitle = SessionUtil.escape(table.getTitle());
        return String.format("%s-%s/%s-%s-%s%s", networkId, networkFileName, namespace, type, tableTitle, TABLE_EXT);
    }

    public static String getXGMMLFilename(CyNetwork network) throws UnsupportedEncodingException {
        String name = SessionUtil.getNetworkFileName(network);
        String id = SessionUtil.escape(Long.toString(network.getSUID()));
        return String.format("%s-%s%s", id, name, XGMML_EXT);
    }

    public static String getXGMMLFilename(CyNetworkView view) throws UnsupportedEncodingException {
        String title = SessionUtil.getNetworkViewFileName(view);
        String viewId = SessionUtil.escape(Long.toString(view.getSUID()));
        String netId = SessionUtil.escape(Long.toString(((CyNetwork)view.getModel()).getSUID()));
        return String.format("%s-%s-%s%s", netId, viewId, title, XGMML_EXT);
    }

    public static String getNetworkFileName(CyNetwork network) throws UnsupportedEncodingException {
        String name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        if (name == null || name.isEmpty()) {
            name = network.getSUID().toString();
        }
        name = SessionUtil.escape(name);
        return name;
    }

    public static String getNetworkViewFileName(CyNetworkView view) throws UnsupportedEncodingException {
        String name = SessionUtil.escape((String)view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE));
        if (name == null || name.isEmpty()) {
            name = SessionUtil.getNetworkFileName((CyNetwork)view.getModel());
        }
        return name;
    }

    public static int getMajorVersion(String version) {
        String[] numbers;
        if (version != null && (numbers = version.split(".")).length > 0) {
            try {
                return Integer.parseInt(numbers[0]);
            }
            catch (Exception ex) {
                logger.error("Invalid version string: " + version);
            }
        }
        return 0;
    }
}

