/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;

public class StreamUtilImpl
implements StreamUtil {
    private static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    private static final int msConnectionTimeout = 2000;
    private String userName;
    private String password;
    private final CyServiceRegistrar serviceRegistrar;

    public StreamUtilImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (StreamUtilImpl.this.userName == null || StreamUtilImpl.this.password == null) {
                    return null;
                }
                return new PasswordAuthentication(StreamUtilImpl.this.userName, StreamUtilImpl.this.password.toCharArray());
            }
        });
    }

    public InputStream getInputStream(String name) throws IOException {
        try {
            if (name.matches("^(jar\\:)?((http|https|ftp|file)+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                return this.getInputStream(new URL(name));
            }
            return new FileInputStream(name);
        }
        catch (FileNotFoundException fnf) {
            logger.error((Object)("The file " + name + " doesn't exist or can't be opened: " + fnf.getMessage()));
            return null;
        }
    }

    public InputStream getInputStream(URL source) throws IOException {
        if (source == null) {
            throw new NullPointerException("Source URL is null");
        }
        return this.getURLConnection(source).getInputStream();
    }

    private Proxy getProxy() {
        CyProperty cyProperty = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties properties = (Properties)cyProperty.getProperties();
        String proxyType = properties.getProperty("proxy.server.type");
        if ("direct".equals(proxyType)) {
            return Proxy.NO_PROXY;
        }
        String hostName = properties.getProperty("proxy.server");
        String portString = properties.getProperty("proxy.server.port");
        this.userName = properties.getProperty("proxy.server.userName");
        String encodedPassword = properties.getProperty("proxy.server.password");
        if (this.userName != null && this.userName.isEmpty()) {
            this.userName = null;
        }
        if (encodedPassword != null) {
            try {
                this.password = this.decode(encodedPassword);
            }
            catch (IOException e) {
                this.password = null;
            }
        }
        try {
            int port = Integer.parseInt(portString);
            Proxy.Type type = null;
            if ("http".equals(proxyType)) {
                type = Proxy.Type.HTTP;
            }
            if ("socks".equals(proxyType)) {
                type = Proxy.Type.SOCKS;
            }
            if (type == null) {
                return Proxy.NO_PROXY;
            }
            return new Proxy(type, new InetSocketAddress(hostName, port));
        }
        catch (NumberFormatException numberFormatException) {
            return Proxy.NO_PROXY;
        }
    }

    private String decode(String text) throws IOException {
        if (text == null) {
            return null;
        }
        return new String(DatatypeConverter.parseBase64Binary((String)text), "UTF-8");
    }

    public URLConnection getURLConnection(URL source) throws IOException {
        if (source == null) {
            throw new NullPointerException("getURLConnection was given a null 'source' argument.");
        }
        URLConnection uc = null;
        Proxy cytoProxy = this.getProxy();
        if (cytoProxy == null) {
            uc = source.openConnection();
        } else {
            try {
                uc = source.openConnection(cytoProxy);
            }
            catch (UnsupportedOperationException e) {
                uc = source.openConnection();
            }
        }
        uc.setUseCaches(false);
        uc.setConnectTimeout(2000);
        return uc;
    }
}

