/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class SUIDUpdater {
    public static final String SUID_COLUMN_SUFFIX = ".SUID";
    private Map<Long, Long> suidMap;
    private Set<CyTable> tables;
    private Map<CyTable, Set<String>> ignoredColumns;

    public SUIDUpdater() {
        this.init();
    }

    public void init() {
        this.suidMap = new HashMap<Long, Long>();
        this.tables = new HashSet<CyTable>();
        this.ignoredColumns = new HashMap<CyTable, Set<String>>();
    }

    public void addSUIDMapping(Long oldSUID, Long newSUID) {
        if (oldSUID != null && newSUID != null) {
            this.suidMap.put(oldSUID, newSUID);
        }
    }

    public Long getNewSUID(Long oldSUID) {
        return this.suidMap.get(oldSUID);
    }

    public void addTable(CyTable table) {
        this.tables.add(table);
    }

    public void addTables(Set<CyTable> networkTables) {
        if (networkTables != null) {
            this.tables.addAll(networkTables);
        }
    }

    public void ignoreColumn(CyTable table, String columnName) {
        if (table != null && columnName != null) {
            Set<String> names = this.ignoredColumns.get(table);
            if (names == null) {
                names = new HashSet<String>();
                this.ignoredColumns.put(table, names);
            }
            names.add(columnName);
        }
    }

    public void updateSUIDColumns() {
        for (CyTable tbl : this.tables) {
            Collection columns = tbl.getColumns();
            for (CyColumn c : columns) {
                Set<String> ignoredNames;
                if (!SUIDUpdater.isUpdatable(c) || (ignoredNames = this.ignoredColumns.get(tbl)) != null && ignoredNames.contains(c.getName())) continue;
                this.updateRows(tbl, c);
            }
        }
    }

    public static boolean isUpdatable(CyColumn column) {
        if (column != null && !column.isPrimaryKey() && !column.getVirtualColumnInfo().isVirtual() && (column.getType() == Long.class || Collection.class.isAssignableFrom(column.getType()) && column.getListElementType() == Long.class)) {
            return SUIDUpdater.isUpdatable(column.getName());
        }
        return false;
    }

    public static boolean isUpdatable(String columnName) {
        return columnName != null && columnName.endsWith(SUID_COLUMN_SUFFIX);
    }

    public void dispose() {
        this.init();
    }

    public String toString() {
        return "SUIDUpdater{ suidMap=" + this.suidMap + ", tables=" + this.tables + " }";
    }

    private void updateRows(CyTable tbl, CyColumn column) {
        String columnName = column.getName();
        Class type = column.getType();
        Class listType = column.getListElementType();
        if (type != Long.class && listType != Long.class) {
            return;
        }
        for (CyRow row : tbl.getAllRows()) {
            List oldList;
            if (type == Long.class) {
                Long oldSUID = (Long)row.get(columnName, Long.class);
                Long newSUID = this.getNewSUID(oldSUID);
                row.set(columnName, (Object)newSUID);
                continue;
            }
            if (type != List.class || (oldList = row.getList(columnName, Long.class)) == null || oldList.isEmpty()) continue;
            ArrayList<Long> newList = new ArrayList<Long>(oldList.size());
            for (Long oldSUID : oldList) {
                Long newSUID = this.getNewSUID(oldSUID);
                if (newSUID == null) continue;
                newList.add(newSUID);
            }
            row.set(columnName, newList);
        }
    }
}

