/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.TaskMonitor;

public class ReadUtils {
    private static final String urlPattern = "^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$";
    private final StreamUtil streamUtil;

    public ReadUtils(StreamUtil streamUtil) {
        this.streamUtil = streamUtil;
    }

    public InputStream getInputStream(String name, TaskMonitor monitor) {
        InputStream in = null;
        try {
            if (name.matches(urlPattern)) {
                URL u = new URL(name);
                in = this.streamUtil.getInputStream(u);
            } else {
                in = new FileInputStream(name);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return in;
    }
}

