/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.io.internal.read.xgmml.handler.XGMMLParseUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCache {
    private Map<Long, Object> oldIdMap;
    private Map<Object, CyNetwork> networkByIdMap;
    private Map<Object, CyNetworkView> networkViewByIdMap;
    private Map<Object, CyNode> nodeByIdMap;
    private Map<Object, CyEdge> edgeByIdMap;
    private Map<Object, CyNode> nodeByNameMap;
    private Map<CyNetwork, Set<Long>> nodeLinkMap;
    private Map<CyNetwork, Set<Long>> edgeLinkMap;
    private Map<CySubNetwork, Set<CyNode>> unresolvedNodeMap;
    private Map<CyNode, Object> networkPointerMap;
    private boolean readingSessionFile;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public ReadCache(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.oldIdMap = new HashMap<Long, Object>();
            this.nodeByIdMap = new HashMap<Object, CyNode>();
            this.edgeByIdMap = new HashMap<Object, CyEdge>();
            this.networkByIdMap = new HashMap<Object, CyNetwork>();
            this.networkViewByIdMap = new HashMap<Object, CyNetworkView>();
            this.nodeByNameMap = new HashMap<Object, CyNode>();
            this.nodeLinkMap = new WeakHashMap<CyNetwork, Set<Long>>();
            this.edgeLinkMap = new WeakHashMap<CyNetwork, Set<Long>>();
            this.unresolvedNodeMap = new WeakHashMap<CySubNetwork, Set<CyNode>>();
            this.networkPointerMap = new WeakHashMap<CyNode, Object>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.nodeByIdMap = null;
            this.edgeByIdMap = null;
            this.networkByIdMap = null;
            this.networkViewByIdMap = null;
            this.nodeByNameMap = null;
            this.nodeLinkMap = null;
            this.edgeLinkMap = null;
            this.unresolvedNodeMap = null;
            this.networkPointerMap = null;
        }
    }

    public void cache(Object xgmmlId, CyIdentifiable element) {
        if (xgmmlId != null) {
            if (element instanceof CyNode) {
                this.nodeByIdMap.put(xgmmlId, (CyNode)element);
            } else if (element instanceof CyEdge) {
                this.edgeByIdMap.put(xgmmlId, (CyEdge)element);
            } else if (element instanceof CyNetwork) {
                this.networkByIdMap.put(xgmmlId, (CyNetwork)element);
            } else if (element instanceof CyNetworkView) {
                this.networkViewByIdMap.put(xgmmlId, (CyNetworkView)element);
            }
            this.oldIdMap.put(element.getSUID(), xgmmlId);
        }
    }

    public void cacheNodeByName(String name, CyNode node) {
        if (name != null && !name.isEmpty() && node != null) {
            this.nodeByNameMap.put(name, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkPointer(CyNode node, Object networkId) {
        if (node == null) {
            throw new NullPointerException("Cannot parse network pointer: node is null.");
        }
        if (networkId == null) {
            throw new NullPointerException("Cannot parse network pointer: network id is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.networkPointerMap.put(node, networkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNetworkPointerId(CyNode node) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkPointerMap.get(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNetworkPointers() {
        Object object = this.lock;
        synchronized (object) {
            return !this.networkPointerMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOldId(Long suid) {
        Object object = this.lock;
        synchronized (object) {
            return this.oldIdMap.get(suid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CyIdentifiable> T getObjectById(Object oldId, Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            if (type == CyNetwork.class) {
                return (T)((CyIdentifiable)this.networkByIdMap.get(oldId));
            }
            if (type == CyNetworkView.class) {
                return (T)((CyIdentifiable)this.networkViewByIdMap.get(oldId));
            }
            if (type == CyNode.class) {
                return (T)((CyIdentifiable)this.nodeByIdMap.get(oldId));
            }
            if (type == CyEdge.class) {
                return (T)((CyIdentifiable)this.edgeByIdMap.get(oldId));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetwork getNetwork(Object oldId) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkByIdMap.get(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CyNetwork> getNetworks() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<CyNetwork>(this.networkByIdMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetworkView getNetworkView(Object oldId) {
        Object object = this.lock;
        synchronized (object) {
            return this.networkViewByIdMap.get(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNode getNode(Object oldId) {
        Object object = this.lock;
        synchronized (object) {
            return this.nodeByIdMap.get(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyEdge getEdge(Object oldId) {
        Object object = this.lock;
        synchronized (object) {
            return this.edgeByIdMap.get(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNode getNodeByName(String nodeName) {
        Object object = this.lock;
        synchronized (object) {
            return this.nodeByNameMap.get(nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnresolvedNode(CyNode node, CySubNetwork net) {
        Object object = this.lock;
        synchronized (object) {
            Set<CyNode> nodes = this.unresolvedNodeMap.get(net);
            if (nodes == null) {
                nodes = new HashSet<CyNode>();
                this.unresolvedNodeMap.put(net, nodes);
            }
            nodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnresolvedNode(CyNode node, CySubNetwork net) {
        Object object = this.lock;
        synchronized (object) {
            Set<CyNode> nodes = this.unresolvedNodeMap.get(net);
            return nodes != null ? nodes.remove(node) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnresolvedNodes() {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<CySubNetwork, Set<CyNode>> entry : this.unresolvedNodeMap.entrySet()) {
                CySubNetwork net = entry.getKey();
                Set<CyNode> nodes = entry.getValue();
                if (net == null || nodes == null || nodes.isEmpty()) continue;
                logger.error("The following nodes can't be resolved and will be deleted from network \"" + net + "\": " + nodes);
                net.removeNodes(nodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementLink(String href, Class<? extends CyIdentifiable> clazz, CyNetwork net) {
        Map<CyNetwork, Set<Long>> map = null;
        Long id = XGMMLParseUtil.getIdFromXLink(href);
        Object object = this.lock;
        synchronized (object) {
            if (clazz == CyNode.class) {
                map = this.nodeLinkMap;
            } else if (clazz == CyEdge.class) {
                map = this.edgeLinkMap;
            }
            if (map != null && net != null) {
                Set<Long> idSet = map.get(net);
                if (idSet == null) {
                    idSet = new HashSet<Long>();
                    map.put(net, idSet);
                }
                idSet.add(id);
            }
        }
    }

    public Map<CyNetwork, Set<Long>> getNodeLinks() {
        return this.nodeLinkMap;
    }

    public Map<CyNetwork, Set<Long>> getEdgeLinks() {
        return this.edgeLinkMap;
    }

    public Map<Object, CyNetwork> getNetworkByIdMap() {
        return this.networkByIdMap;
    }

    public Map<Object, CyNetworkView> getNetworkViewByIdMap() {
        return this.networkViewByIdMap;
    }

    public Map<Object, CyNode> getNodeByIdMap() {
        return this.nodeByIdMap;
    }

    public Map<Object, CyEdge> getEdgeByIdMap() {
        return this.edgeByIdMap;
    }

    public Map<Object, CyNode> getNodeByNameMap() {
        return this.nodeByNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyTable> getNetworkTables() {
        HashSet<CyTable> tables = new HashSet<CyTable>();
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
        Class[] types = new Class[]{CyNetwork.class, CyNode.class, CyEdge.class};
        Object object = this.lock;
        synchronized (object) {
            if (this.networkByIdMap.values() != null) {
                networks.addAll(this.networkByIdMap.values());
            }
        }
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        for (CyNetwork n : networks) {
            for (Class t : types) {
                HashMap tblMap = new HashMap(netTblMgr.getTables(n, t));
                tblMap.remove("USER");
                if (tblMap != null) {
                    tables.addAll(tblMap.values());
                }
                if (!(n instanceof CySubNetwork)) continue;
                tblMap = new HashMap(netTblMgr.getTables((CyNetwork)((CySubNetwork)n).getRootNetwork(), t));
                tblMap.remove("USER");
                tblMap.remove("SHARED_DEFAULT_ATTRS");
                if (tblMap == null) continue;
                tables.addAll(tblMap.values());
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNetworkPointers() {
        Object object = this.lock;
        synchronized (object) {
            if (this.networkPointerMap == null) {
                return;
            }
            for (Map.Entry<CyNode, Object> entry : this.networkPointerMap.entrySet()) {
                CyNode node = entry.getKey();
                Object oldNetId = entry.getValue();
                CyNetwork network = this.getNetwork(oldNetId);
                if (network != null) {
                    node.setNetworkPointer(network);
                    continue;
                }
                logger.error("Cannot recreate network pointer: Cannot find network " + oldNetId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadingSessionFile() {
        Object object = this.lock;
        synchronized (object) {
            return this.readingSessionFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadingSessionFile(boolean readingSessionFile) {
        Object object = this.lock;
        synchronized (object) {
            this.readingSessionFile = readingSessionFile;
        }
    }
}

