/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ExportBitmapOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 5333484131669731753L;
    private JFormattedTextField zoomField;
    private JFormattedTextField widthInPixelsField;
    private JFormattedTextField heightInPixelsField;
    private JFormattedTextField widthInInchesField;
    private JFormattedTextField heightInInchesField;
    private JComboBox resolutionComboBox;
    private int originalWidth;
    private int originalHeight;

    public ExportBitmapOptionsPanel(int imageWidth, int imageHeight) {
        this.originalWidth = imageWidth;
        this.originalHeight = imageHeight;
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder(new EtchedBorder(), "Image Size"));
        sizePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel zoomLabel = new JLabel("Zoom: ");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)zoomLabel, c);
        this.zoomField = new JFormattedTextField(new DecimalFormat());
        this.zoomField.setColumns(3);
        ZoomListener zoomListener = new ZoomListener(this.zoomField);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.zoomField, c);
        JLabel zoomPercentLabel = new JLabel("%");
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)zoomPercentLabel, c);
        JSeparator separator0 = new JSeparator();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)separator0, c);
        JLabel widthInPixelsLabel = new JLabel("Width: ");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInPixelsLabel, c);
        this.widthInPixelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.widthInPixelsField.setColumns(4);
        new WidthInPixelsListener(this.widthInPixelsField);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.widthInPixelsField, c);
        JLabel widthPixelsLabel = new JLabel("pixels");
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthPixelsLabel, c);
        JLabel heightInPixelsLabel = new JLabel("Height:");
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInPixelsLabel, c);
        this.heightInPixelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.heightInPixelsField.setColumns(4);
        new HeightInPixelsListener(this.heightInPixelsField);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.heightInPixelsField, c);
        JLabel heightPixelsLabel = new JLabel("pixels");
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightPixelsLabel, c);
        JSeparator separator1 = new JSeparator();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)separator1, c);
        JLabel widthInInchesLabel = new JLabel("Width: ");
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInInchesLabel, c);
        this.widthInInchesField = new JFormattedTextField(new DecimalFormat());
        this.widthInInchesField.setColumns(4);
        new WidthInInchesListener(this.widthInInchesField);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.widthInInchesField, c);
        JLabel widthInchesLabel = new JLabel("inches");
        c.gridx = 2;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInchesLabel, c);
        JLabel heightInInchesLabel = new JLabel("Height:");
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInInchesLabel, c);
        this.heightInInchesField = new JFormattedTextField(new DecimalFormat());
        this.heightInInchesField.setColumns(4);
        new HeightInInchesListener(this.heightInInchesField);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.heightInInchesField, c);
        JLabel heightInchesLabel = new JLabel("inches");
        c.gridx = 2;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInchesLabel, c);
        JLabel resolutionLabel = new JLabel("Resolution:");
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)resolutionLabel, c);
        Integer[] resolutions = new Integer[]{72, 100, 150, 300, 600};
        this.resolutionComboBox = new JComboBox<Integer>(resolutions);
        this.resolutionComboBox.addActionListener(zoomListener);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.resolutionComboBox, c);
        JLabel dpiLabel = new JLabel("DPI");
        c.gridx = 2;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)dpiLabel, c);
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)sizePanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 14;
        this.updateOnZoom(1.0);
    }

    public double getZoom() {
        return ((Number)this.zoomField.getValue()).doubleValue() / 100.0;
    }

    public int getWidthPixels() {
        return ((Number)this.widthInPixelsField.getValue()).intValue();
    }

    public int getHeightPixels() {
        return ((Number)this.heightInPixelsField.getValue()).intValue();
    }

    public double getWidthInches() {
        return ((Number)this.widthInInchesField.getValue()).doubleValue();
    }

    public double getHeightInches() {
        return ((Number)this.heightInInchesField.getValue()).doubleValue();
    }

    private void updateOnZoom(double newZoom) {
        this.zoomField.setValue(new Double(newZoom * 100.0));
        int newWidth = (int)(newZoom * (double)this.originalWidth);
        int newHeight = (int)(newZoom * (double)this.originalHeight);
        this.widthInPixelsField.setValue(new Integer(newWidth));
        this.heightInPixelsField.setValue(new Integer(newHeight));
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        double newWidthInches = (double)newWidth / dpi;
        double newHeightInches = (double)newHeight / dpi;
        this.widthInInchesField.setValue(new Double(newWidthInches));
        this.heightInInchesField.setValue(new Double(newHeightInches));
    }

    private void updateOnWidthPixels(int newWidthPixels) {
        double newZoom = (double)newWidthPixels / (double)this.originalWidth;
        this.updateOnZoom(newZoom);
    }

    private void updateOnHeightPixels(int newHeightPixels) {
        double newZoom = (double)newHeightPixels / (double)this.originalHeight;
        this.updateOnZoom(newZoom);
    }

    private void updateOnWidthInches(double newWidthInches) {
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        this.updateOnWidthPixels((int)(newWidthInches * dpi));
    }

    private void updateOnHeightInches(double newHeightInches) {
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        this.updateOnHeightPixels((int)(newHeightInches * dpi));
    }

    private class ZoomListener
    extends FormattedFieldListener {
        public ZoomListener(JFormattedTextField field) {
            super(field);
        }

        @Override
        public void update() {
            double zoom = ((Number)ExportBitmapOptionsPanel.this.zoomField.getValue()).doubleValue();
            ExportBitmapOptionsPanel.this.updateOnZoom(zoom /= 100.0);
        }
    }

    private class WidthInPixelsListener
    extends FormattedFieldListener {
        public WidthInPixelsListener(JFormattedTextField field) {
            super(field);
        }

        @Override
        public void update() {
            int width = ((Number)ExportBitmapOptionsPanel.this.widthInPixelsField.getValue()).intValue();
            ExportBitmapOptionsPanel.this.updateOnWidthPixels(width);
        }
    }

    private class HeightInPixelsListener
    extends FormattedFieldListener {
        public HeightInPixelsListener(JFormattedTextField field) {
            super(field);
        }

        @Override
        public void update() {
            int height = ((Number)ExportBitmapOptionsPanel.this.heightInPixelsField.getValue()).intValue();
            ExportBitmapOptionsPanel.this.updateOnHeightPixels(height);
        }
    }

    private class WidthInInchesListener
    extends FormattedFieldListener {
        public WidthInInchesListener(JFormattedTextField field) {
            super(field);
        }

        @Override
        public void update() {
            double width = ((Number)ExportBitmapOptionsPanel.this.widthInInchesField.getValue()).doubleValue();
            ExportBitmapOptionsPanel.this.updateOnWidthInches(width);
        }
    }

    private class HeightInInchesListener
    extends FormattedFieldListener {
        public HeightInInchesListener(JFormattedTextField field) {
            super(field);
        }

        @Override
        public void update() {
            double height = ((Number)ExportBitmapOptionsPanel.this.heightInInchesField.getValue()).doubleValue();
            ExportBitmapOptionsPanel.this.updateOnHeightInches(height);
        }
    }

    private abstract class FormattedFieldListener
    extends FocusAdapter
    implements ActionListener {
        private JFormattedTextField field;

        public abstract void update();

        public FormattedFieldListener(JFormattedTextField field) {
            this.field = field;
            field.addActionListener(this);
            field.addFocusListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        @Override
        public void focusLost(FocusEvent l) {
            try {
                this.field.commitEdit();
            }
            catch (ParseException exp) {
                return;
            }
            this.update();
        }
    }
}

