/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.XGMMLParseUtil;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.internal.util.SUIDUpdater;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ReadDataManager {
    protected static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final String PATTERN2X = "type|fill|w|h|size|width|outline|(cy:)?((node|edge)Transparency|(node|edge)LabelFont|(border|edge)LineType)|(cy:)?(source|target)Arrow(Color)?";
    private static final String BG_COLOR_PATTERN = "backgroundColor";
    private static final Pattern P2X = Pattern.compile("type|fill|w|h|size|width|outline|(cy:)?((node|edge)Transparency|(node|edge)LabelFont|(border|edge)LineType)|(cy:)?(source|target)Arrow(Color)?");
    private static final Pattern PBG_COLOR = Pattern.compile("backgroundColor");
    protected String RDFDate;
    protected String RDFTitle;
    protected String RDFIdentifier;
    protected String RDFDescription;
    protected String RDFSource;
    protected String RDFType;
    protected String RDFFormat;
    private Set<CyNetwork> publicNetworks;
    private Stack<Object> networkStack;
    private Stack<CyNode> compoundNodeStack;
    protected ParseState attState = ParseState.NONE;
    protected String currentAttributeID;
    protected List<String> handleList;
    protected String edgeBendX;
    protected String edgeBendY;
    protected List<Object> listAttrHolder;
    protected boolean currentNetworkIsDirected = true;
    private Map<Long, Map<String, String>> networkGraphics;
    private Map<Long, Map<String, String>> nodeGraphics;
    private Map<Long, Map<String, String>> edgeGraphics;
    private Map<CyRow, Map<String, String>> equations;
    protected int graphCount;
    protected int graphDoneCount;
    private boolean viewFormat;
    private double documentVersion;
    private CyRootNetwork parentNetwork;
    private CyNetwork currentNetwork;
    private CyNode currentNode;
    private CyEdge currentEdge;
    private CyIdentifiable currentElement;
    private CyRow currentRow;
    private Object networkViewId;
    private Object networkId;
    private String visualStyleName;
    private String rendererId;
    private Object currentElementId;
    private Map<Object, Map<String, String>> viewGraphics;
    private Map<Object, Map<String, String>> viewLockedGraphics;
    private final ReadCache cache;
    private final SUIDUpdater suidUpdater;
    private final GroupUtil groupUtil;
    private final CyServiceRegistrar serviceRegistrar;
    private CyRootNetworkManager rootNetworkManager;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private Map<Object, CyNode> nMap;
    private CyRootNetwork rootNetwork = null;

    public ReadDataManager(ReadCache cache, SUIDUpdater suidUpdater, GroupUtil groupUtil, CyServiceRegistrar serviceRegistrar) {
        this.cache = cache;
        this.suidUpdater = suidUpdater;
        this.groupUtil = groupUtil;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public void init() {
        if (!this.cache.isReadingSessionFile()) {
            this.cache.init();
            this.suidUpdater.init();
        }
        this.viewFormat = false;
        this.graphCount = 0;
        this.graphDoneCount = 0;
        this.documentVersion = 0.0;
        this.RDFDate = null;
        this.RDFTitle = null;
        this.RDFIdentifier = null;
        this.RDFDescription = null;
        this.RDFSource = null;
        this.RDFType = null;
        this.RDFFormat = null;
        this.currentElement = null;
        this.currentNode = null;
        this.currentEdge = null;
        this.currentNetwork = null;
        this.parentNetwork = null;
        this.currentNetworkIsDirected = true;
        this.currentRow = null;
        this.attState = ParseState.NONE;
        this.currentAttributeID = null;
        this.handleList = null;
        this.edgeBendX = null;
        this.edgeBendY = null;
        this.networkStack = new Stack();
        this.compoundNodeStack = new Stack();
        this.publicNetworks = new LinkedHashSet<CyNetwork>();
        this.equations = new Hashtable<CyRow, Map<String, String>>();
        this.networkGraphics = new LinkedHashMap<Long, Map<String, String>>();
        this.nodeGraphics = new LinkedHashMap<Long, Map<String, String>>();
        this.edgeGraphics = new LinkedHashMap<Long, Map<String, String>>();
        this.networkViewId = null;
        this.networkId = null;
        this.visualStyleName = null;
        this.rendererId = null;
        this.viewGraphics = new LinkedHashMap<Object, Map<String, String>>();
        this.viewLockedGraphics = new LinkedHashMap<Object, Map<String, String>>();
    }

    public void dispose() {
        this.publicNetworks = null;
        this.equations = null;
        this.compoundNodeStack = null;
        this.currentElement = null;
        this.currentNetwork = null;
        this.currentNode = null;
        this.currentEdge = null;
        this.currentRow = null;
        if (!this.cache.isReadingSessionFile()) {
            this.cache.dispose();
            this.suidUpdater.dispose();
        }
    }

    public double getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = XGMMLParseUtil.parseDocumentVersion(documentVersion);
    }

    public boolean isSessionFormat() {
        return this.cache.isReadingSessionFile();
    }

    public boolean isViewFormat() {
        return this.viewFormat;
    }

    public void setViewFormat(boolean viewFormat) {
        this.viewFormat = viewFormat;
    }

    public Set<CyNetwork> getPublicNetworks() {
        return this.publicNetworks;
    }

    public ReadCache getCache() {
        return this.cache;
    }

    public SUIDUpdater getSUIDUpdater() {
        return this.suidUpdater;
    }

    protected void addGraphicsAttribute(CyIdentifiable element, String attName, String attValue) {
        if (!this.ignoreGraphicsAttribute(element, attName)) {
            Map<Long, Map<String, String>> graphics = null;
            if (element instanceof CyNode) {
                graphics = this.nodeGraphics;
            } else if (element instanceof CyEdge) {
                graphics = this.edgeGraphics;
            } else if (element instanceof CyNetwork) {
                graphics = this.networkGraphics;
            }
            Map<String, String> attributes = graphics.get(element.getSUID());
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                graphics.put(element.getSUID(), attributes);
            }
            attributes.put(attName, attValue);
        }
    }

    protected void addViewGraphicsAttribute(Object oldModelId, String attName, String attValue, boolean locked) {
        Map<Object, Map<String, String>> graphics = locked ? this.viewLockedGraphics : this.viewGraphics;
        Map<String, String> attributes = graphics.get(oldModelId);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            graphics.put(oldModelId, attributes);
        }
        attributes.put(attName, attValue);
    }

    protected void addGraphicsAttributes(CyIdentifiable element, Attributes atts) {
        if (element != null) {
            int attrLength = atts.getLength();
            for (int i = 0; i < attrLength; ++i) {
                if (element instanceof CyNode) {
                    this.addGraphicsAttribute(element, atts.getLocalName(i), atts.getValue(i));
                    continue;
                }
                if (element instanceof CyEdge) {
                    this.addGraphicsAttribute(element, atts.getLocalName(i), atts.getValue(i));
                    continue;
                }
                if (!(element instanceof CyNetwork)) continue;
                this.addGraphicsAttribute(element, atts.getLocalName(i), atts.getValue(i));
            }
        }
    }

    protected void addViewGraphicsAttributes(Object oldModelId, Attributes atts, boolean locked) {
        if (oldModelId != null) {
            int attrLength = atts.getLength();
            for (int i = 0; i < attrLength; ++i) {
                this.addViewGraphicsAttribute(oldModelId, atts.getLocalName(i), atts.getValue(i), locked);
            }
        }
    }

    public Map<String, String> getGraphicsAttributes(CyIdentifiable element) {
        if (element instanceof CyNetwork) {
            return this.networkGraphics.get(element.getSUID());
        }
        if (element instanceof CyNode) {
            return this.nodeGraphics.get(element.getSUID());
        }
        if (element instanceof CyEdge) {
            return this.edgeGraphics.get(element.getSUID());
        }
        return null;
    }

    public <T extends CyIdentifiable> Map<String, String> getViewGraphicsAttributes(Object oldId, boolean locked) {
        return locked ? this.viewLockedGraphics.get(oldId) : this.viewGraphics.get(oldId);
    }

    public void setParentNetwork(CyRootNetwork parent) {
        this.parentNetwork = parent;
    }

    public CyRootNetwork getParentNetwork() {
        return this.parentNetwork;
    }

    public void addEquationString(CyRow row, String columnName, String formula) {
        Map<String, String> colEquationMap = this.equations.get(row);
        if (colEquationMap == null) {
            colEquationMap = new HashMap<String, String>();
            this.equations.put(row, colEquationMap);
        }
        colEquationMap.put(columnName, formula);
    }

    protected void parseAllEquations() {
        EquationCompiler equationCompiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        for (Map.Entry<CyRow, Map<String, String>> entry : this.equations.entrySet()) {
            CyRow row = entry.getKey();
            Map<String, String> colEquationMap = entry.getValue();
            Hashtable<String, Class> colNameTypeMap = new Hashtable<String, Class>();
            Collection columns = row.getTable().getColumns();
            for (CyColumn cyColumn : columns) {
                colNameTypeMap.put(cyColumn.getName(), cyColumn.getType());
            }
            for (Map.Entry entry2 : colEquationMap.entrySet()) {
                String columnName = (String)entry2.getKey();
                String formula = (String)entry2.getValue();
                if (equationCompiler.compile(formula, colNameTypeMap)) {
                    Equation equation = equationCompiler.getEquation();
                    row.set(columnName, (Object)equation);
                    continue;
                }
                logger.error("Error parsing equation \"" + formula + "\": " + equationCompiler.getLastErrorMsg());
            }
        }
    }

    protected void setCurrentNetwork(CyNetwork network) {
        this.currentNetwork = network;
    }

    protected CyNetwork getCurrentNetwork() {
        return this.currentNetwork;
    }

    protected Stack<Object> getNetworkIDStack() {
        return this.networkStack;
    }

    public Stack<CyNode> getCompoundNodeStack() {
        return this.compoundNodeStack;
    }

    protected CyRootNetwork createRootNetwork() {
        if (this.rootNetwork != null) {
            return this.rootNetwork;
        }
        CyNetworkFactory networkFactory = (CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class);
        CyNetwork baseNet = networkFactory.createNetwork();
        CyRootNetworkManager rootNetworkManager = this.getRootNetworkManager();
        CyRootNetwork rootNetwork = rootNetworkManager.getRootNetwork(baseNet);
        return rootNetwork;
    }

    protected CyRootNetwork getRootNetwork() {
        return this.currentNetwork != null ? this.getRootNetworkManager().getRootNetwork(this.currentNetwork) : null;
    }

    private CyRootNetworkManager getRootNetworkManager() {
        if (this.rootNetworkManager == null) {
            this.rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        }
        return this.rootNetworkManager;
    }

    protected CyNode createNode(Object oldId, String label, CyNetwork net) {
        if (oldId == null) {
            throw new NullPointerException("'oldId' is null.");
        }
        CyNode node = null;
        if (net instanceof CySubNetwork && this.getParentNetwork() != null && (node = this.cache.getNode(oldId)) != null) {
            ((CySubNetwork)net).addNode(node);
        }
        if (node == null && (node = this.nMap.get(label)) == null) {
            node = net.addNode();
        }
        if (net instanceof CySubNetwork && this.getParentNetwork() != null) {
            CySubNetwork subnet = (CySubNetwork)net;
            node = subnet.getRootNetwork().getNode(node.getSUID().longValue());
        }
        this.cache.cache(oldId, (CyIdentifiable)node);
        this.cache.cacheNodeByName(label, node);
        this.mapSUIDs(oldId, node.getSUID());
        return node;
    }

    protected void addNode(CyNode node, String label, CySubNetwork net) {
        net.addNode(node);
        this.cache.cacheNodeByName(label, node);
        this.cache.removeUnresolvedNode(node, net);
    }

    protected CyEdge createEdge(CyNode source, CyNode target, Object id, String label, boolean directed, CyNetwork net) {
        CyEdge edge = null;
        if (id == null) {
            id = label;
        }
        if (net instanceof CySubNetwork && this.getParentNetwork() != null && (edge = this.cache.getEdge(id)) != null) {
            ((CySubNetwork)net).addEdge(edge);
        }
        if (edge == null) {
            CyNode actualSrc = net.getNode(source.getSUID().longValue());
            CyNode actualTgt = net.getNode(target.getSUID().longValue());
            List extEdgeIds = null;
            if (!(!(this.getDocumentVersion() < 3.0) && this.isSessionFormat() || actualSrc != null && actualTgt != null)) {
                CyRootNetwork rootNet = this.getRootNetwork();
                if (actualSrc == null) {
                    actualSrc = rootNet.getNode(source.getSUID().longValue());
                }
                if (actualTgt == null) {
                    actualTgt = rootNet.getNode(target.getSUID().longValue());
                }
                if (this.getDocumentVersion() < 3.0 && !this.compoundNodeStack.isEmpty() && this.networkStack.size() > 1) {
                    CyNode grNode = this.compoundNodeStack.peek();
                    CyNetwork parentNet = this.cache.getNetwork(this.networkStack.elementAt(this.networkStack.size() - 2));
                    CyRow gnhRow = parentNet.getRow((CyIdentifiable)grNode, "HIDDEN");
                    if (gnhRow.isSet("__groupState")) {
                        CyRow nphRow = net.getRow((CyIdentifiable)net, "HIDDEN");
                        if (nphRow.getTable().getColumn("__externalEdges.SUID") == null) {
                            nphRow.getTable().createListColumn("__externalEdges.SUID", Long.class, false);
                            this.suidUpdater.ignoreColumn(nphRow.getTable(), "__externalEdges.SUID");
                        }
                        if ((extEdgeIds = nphRow.getList("__externalEdges.SUID", Long.class)) == null) {
                            nphRow.set("__externalEdges.SUID", new ArrayList());
                            extEdgeIds = nphRow.getList("__externalEdges.SUID", Long.class);
                        }
                    }
                }
                net = rootNet;
            }
            edge = net.addEdge(actualSrc, actualTgt, directed);
            if (extEdgeIds != null) {
                extEdgeIds.add(edge.getSUID());
            }
            this.mapSUIDs(id, edge.getSUID());
        }
        this.cache.cache(id, (CyIdentifiable)edge);
        return edge;
    }

    protected CyEdge createEdge(Object sourceId, Object targetId, Object id, String label, boolean directed, CyNetwork net) {
        boolean haveSource;
        if (id == null) {
            id = label;
        }
        CyNode source = this.cache.getNode(sourceId);
        CyNode target = this.cache.getNode(targetId);
        boolean haveTarget = target != null;
        boolean bl = haveSource = source != null;
        if (!haveSource) {
            source = this.createNode(sourceId, null, net);
        }
        if (!haveTarget) {
            target = this.createNode(targetId, null, net);
        }
        CyNetwork curNet = this.getCurrentNetwork();
        CyEdge edge = this.createEdge(source, target, id, label, directed, net);
        if (curNet instanceof CySubNetwork) {
            if (!haveSource) {
                this.cache.addUnresolvedNode(source, (CySubNetwork)curNet);
            }
            if (!haveTarget) {
                this.cache.addUnresolvedNode(target, (CySubNetwork)curNet);
            }
        }
        return edge;
    }

    protected void createGroups() {
        this.groupUtil.createGroups(this.publicNetworks, null);
    }

    public void updateGroupNodes(CyNetworkView view) {
        this.groupUtil.updateGroupNodes(view);
    }

    protected void addNetwork(Object oldId, CyNetwork net, boolean isRegistered) {
        if (net != null) {
            if (isRegistered && !(net instanceof CyRootNetwork)) {
                this.publicNetworks.add(net);
            }
            this.cache.cache(oldId, (CyIdentifiable)net);
            this.mapSUIDs(oldId, net.getSUID());
        }
    }

    protected void addElementLink(String href, Class<? extends CyIdentifiable> clazz) {
        this.cache.addElementLink(href, clazz, this.getCurrentNetwork());
    }

    public Object getNetworkViewId() {
        return this.networkViewId;
    }

    protected void setNetworkViewId(Object networkViewId) {
        this.networkViewId = networkViewId;
    }

    public Object getNetworkId() {
        return this.networkId;
    }

    protected void setNetworkId(Object networkId) {
        this.networkId = networkId;
    }

    public String getVisualStyleName() {
        return this.visualStyleName;
    }

    protected void setVisualStyleName(String visualStyleName) {
        this.visualStyleName = visualStyleName;
    }

    public String getRendererId() {
        return this.rendererId;
    }

    protected void setRendererId(String rendererId) {
        this.rendererId = rendererId;
    }

    protected Object getCurrentElementId() {
        return this.currentElementId;
    }

    protected void setCurrentElementId(Object currentElementId) {
        this.currentElementId = currentElementId;
    }

    public CyNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(CyNode currentNode) {
        this.currentNode = currentNode;
    }

    public CyEdge getCurrentEdge() {
        return this.currentEdge;
    }

    public void setCurrentEdge(CyEdge currentEdge) {
        this.currentEdge = currentEdge;
    }

    public CyRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(CyRow row) {
        this.currentRow = row;
    }

    protected CyIdentifiable getCurrentElement() {
        return this.currentElement;
    }

    public void setCurrentElement(CyIdentifiable entry) {
        this.currentElement = entry;
        if (entry instanceof CyNetwork) {
            this.setCurrentNetwork((CyNetwork)entry);
        }
        if (entry instanceof CyNode) {
            this.setCurrentNode((CyNode)entry);
        }
        if (entry instanceof CyEdge) {
            this.setCurrentEdge((CyEdge)entry);
        }
    }

    private void mapSUIDs(Object oldId, Long newSUID) {
        if (oldId instanceof Long) {
            this.suidUpdater.addSUIDMapping((Long)oldId, newSUID);
        }
    }

    private final boolean ignoreGraphicsAttribute(CyIdentifiable element, String attName) {
        boolean b = false;
        if (this.isSessionFormat() && element != null && attName != null) {
            b = b || element instanceof CyNetwork && this.matchesBg(attName);
            b = b || (element instanceof CyNode || element instanceof CyEdge) && this.matches2x(attName);
        }
        return b;
    }

    private final boolean matches2x(String text) {
        Matcher matcher = P2X.matcher(text);
        return matcher.matches();
    }

    private final boolean matchesBg(String text) {
        Matcher matcher = PBG_COLOR.matcher(text);
        return matcher.matches();
    }

    public void setNodeMap(Map<Object, CyNode> nMap) {
        this.nMap = nMap;
    }
}

