/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AttributeValueUtil;
import org.cytoscape.io.internal.read.xgmml.handler.HandleGraph;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleNodeGraph
extends HandleGraph {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        ++this.manager.graphCount;
        CyNode node = this.manager.getCurrentNode();
        this.manager.getCompoundNodeStack().push(node);
        String href = atts.getValue("http://www.w3.org/1999/xlink", "href");
        Object netId = null;
        CySubNetwork network = null;
        if (href != null) {
            netId = AttributeValueUtil.getIdFromXLink(href);
            if (netId == null) {
                logger.error("The node's network pointer will not be created: the network ID cannot be parsed from the XLink reference.");
            }
            this.addCurrentNetwork(netId, (CyNetwork)network, atts, this.isRegistered(atts));
        } else {
            netId = this.getId(atts);
            CyRootNetwork rootNet = this.manager.getRootNetwork();
            network = rootNet.addSubNetwork();
            netId = this.addCurrentNetwork(netId, (CyNetwork)network, atts, this.isRegistered(atts));
        }
        if (netId != null) {
            this.manager.getCache().addNetworkPointer(node, netId);
        }
        return current;
    }

    @Override
    protected boolean isRegistered(Attributes atts) {
        return super.isRegistered(atts) && this.manager.getDocumentVersion() >= 3.0;
    }
}

