/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.cytoscape.io.internal.read.xgmml.handler.XGMMLParseUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleNode
extends AbstractHandler {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        String href = atts.getValue("http://www.w3.org/1999/xlink", "href");
        Object id = null;
        String label = null;
        CyNode node = null;
        CyNetwork curNet = this.manager.getCurrentNetwork();
        CyRootNetwork rootNet = this.manager.getRootNetwork();
        if (href == null) {
            id = this.getId(atts);
            label = atts.getValue("label");
            if (label == null) {
                label = atts.getValue("name");
            }
            if ((node = this.manager.getCache().getNode(id)) == null) {
                node = this.manager.createNode(id, label, curNet);
            } else if (curNet instanceof CySubNetwork) {
                this.manager.addNode(node, label, (CySubNetwork)curNet);
            }
            if (label != null && (!this.manager.isSessionFormat() || this.manager.getDocumentVersion() < 3.0)) {
                if (!this.manager.isSessionFormat() && !curNet.containsNode(node) && curNet instanceof CySubNetwork) {
                    CySubNetwork subnet = (CySubNetwork)curNet;
                    subnet.addNode(node);
                    node = subnet.getNode(node.getSUID().longValue());
                }
                curNet.getRow((CyIdentifiable)node).set("name", (Object)label);
                if (rootNet != null && curNet != rootNet) {
                    rootNet.getRow((CyIdentifiable)node).set("name", (Object)label);
                }
            }
        } else {
            id = XGMMLParseUtil.getIdFromXLink(href);
            node = this.manager.getCache().getNode(id);
            if (node != null) {
                if (curNet instanceof CySubNetwork) {
                    ((CySubNetwork)curNet).addNode(node);
                } else {
                    logger.error("Cannot add existing node \"" + id + "\" to a network which is not a CySubNetwork");
                }
            } else {
                this.manager.addElementLink(href, CyNode.class);
            }
        }
        if (node != null) {
            this.manager.setCurrentElement((CyIdentifiable)node);
        }
        return current;
    }
}

