/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleGraph
extends AbstractHandler {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        String docVersion;
        ++this.manager.graphCount;
        if (this.manager.graphCount == 1 && (docVersion = atts.getValue("cy:documentVersion")) != null) {
            this.manager.setDocumentVersion(docVersion);
        }
        if (this.manager.isSessionFormat()) {
            if (this.manager.getDocumentVersion() >= 3.0) {
                this.handleCy3Model(tag, atts, current);
            } else {
                this.handleCy2ModelAndView(tag, atts, current);
            }
        } else {
            this.handleGenericXGMMLGraph(tag, atts, current);
        }
        return current;
    }

    protected boolean isRegistered(Attributes atts) {
        String s = atts.getValue("cy:registered");
        return s == null || ObjectTypeMap.fromXGMMLBoolean(s);
    }

    private ParseState handleCy2ModelAndView(String tag, Attributes atts, ParseState current) throws SAXException {
        CySubNetwork currentNet;
        CyRootNetwork parent = this.manager.getParentNetwork();
        if (this.manager.graphCount == 1) {
            if (parent == null) {
                rootNet = this.manager.createRootNetwork();
                currentNet = rootNet.getBaseNetwork();
            } else {
                currentNet = parent.addSubNetwork();
            }
        } else {
            rootNet = this.manager.getRootNetwork();
            currentNet = rootNet.addSubNetwork();
        }
        String id = this.getLabel(atts);
        this.addCurrentNetwork(id, (CyNetwork)currentNet, atts, true);
        return current;
    }

    private ParseState handleCy3Model(String tag, Attributes atts, ParseState current) throws SAXException {
        CyRootNetwork currentNet;
        boolean register = this.isRegistered(atts);
        if (this.manager.graphCount == 1) {
            currentNet = this.manager.createRootNetwork();
            register = false;
        } else if (this.manager.graphCount == 2) {
            rootNet = this.manager.getRootNetwork();
            currentNet = rootNet.getBaseNetwork();
        } else {
            rootNet = this.manager.getRootNetwork();
            currentNet = rootNet.addSubNetwork();
        }
        Object id = this.getId(atts);
        this.addCurrentNetwork(id, (CyNetwork)currentNet, atts, register);
        return current;
    }

    private ParseState handleGenericXGMMLGraph(String tag, Attributes atts, ParseState current) throws SAXException {
        CySubNetwork currentNet;
        if (this.manager.graphCount == 1) {
            CyRootNetwork parentNet = this.manager.getParentNetwork();
            if (parentNet == null) {
                CyRootNetwork rootNet = this.manager.createRootNetwork();
                currentNet = rootNet.getBaseNetwork();
            } else {
                currentNet = parentNet.addSubNetwork();
            }
        } else {
            CyRootNetwork rootNet = this.manager.getRootNetwork();
            currentNet = rootNet.addSubNetwork();
        }
        Object id = this.getId(atts);
        this.addCurrentNetwork(id, (CyNetwork)currentNet, atts, true);
        return current;
    }

    protected Object addCurrentNetwork(Object oldId, CyNetwork net, Attributes atts, boolean register) {
        if (oldId == null) {
            oldId = String.format("_graph%s_%s", this.manager.graphCount, net.getSUID());
        }
        this.manager.setCurrentElement((CyIdentifiable)net);
        this.manager.getNetworkIDStack().push(oldId);
        if (net != null) {
            this.manager.addNetwork(oldId, net, register);
            if (!this.manager.isSessionFormat() || this.manager.getDocumentVersion() < 3.0) {
                this.setNetworkName(net, atts);
            }
        } else {
            this.manager.setCurrentNetwork(null);
        }
        return oldId;
    }

    protected void setNetworkName(CyNetwork net, Attributes atts) {
        Object name = this.getLabel(atts);
        if (name == null || ((String)name).trim().isEmpty()) {
            if (net instanceof CyRootNetwork) {
                name = "Root-Network " + net.getSUID();
            } else if (this.manager.graphCount == 1) {
                name = "Network " + net.getSUID();
            } else {
                CyRootNetwork root = this.manager.getRootNetwork();
                if (root != null && ((name = (String)root.getBaseNetwork().getRow((CyIdentifiable)root.getBaseNetwork()).get("name", String.class)) == null || ((String)name).trim().isEmpty())) {
                    name = (String)root.getRow((CyIdentifiable)root).get("name", String.class);
                }
            }
            if (name == null || ((String)name).trim().isEmpty()) {
                name = "Network " + net.getSUID();
            }
            name = (String)name + " - " + this.manager.graphCount;
        }
        if (net != null && name != null) {
            CyRow netRow = net.getRow((CyIdentifiable)net);
            netRow.set("name", name);
        }
    }
}

