/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.util.Stack;
import org.cytoscape.io.internal.read.xgmml.Handler;
import org.cytoscape.io.internal.read.xgmml.HandlerFactory;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.SAXState;
import org.cytoscape.io.internal.read.xgmml.handler.ReadDataManager;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XGMMLParser
extends DefaultHandler {
    private Locator locator;
    private String currentCData;
    private ParseState parseState;
    private Stack<ParseState> stateStack;
    private final HandlerFactory handlerFactory;
    private final ReadDataManager readDataManager;

    public XGMMLParser(HandlerFactory handlerFactory, ReadDataManager readDataManager) {
        this.handlerFactory = handlerFactory;
        this.readDataManager = readDataManager;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stateStack = new Stack();
        this.parseState = ParseState.NONE;
        this.handlerFactory.init();
        super.startDocument();
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        ParseState nextState = this.handleStartState(this.parseState, localName, atts);
        this.stateStack.push(this.parseState);
        this.parseState = nextState;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndState(this.parseState, localName, null);
        this.parseState = this.stateStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentCData = new String(ch, start, length);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String err = "Fatal parsing error on line " + e.getLineNumber() + " -- '" + e.getMessage() + "'";
        throw new SAXException(err);
    }

    @Override
    public void error(SAXParseException e) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private ParseState handleStartState(ParseState currentState, String tag, Attributes atts) throws SAXException {
        return this.handleState(currentState, tag, atts, this.handlerFactory.getStartHandler(currentState, tag));
    }

    private ParseState handleEndState(ParseState currentState, String tag, Attributes atts) throws SAXException {
        return this.handleState(currentState, tag, atts, this.handlerFactory.getEndHandler(currentState, tag));
    }

    private ParseState handleState(ParseState currentState, String tag, Attributes atts, SAXState state) throws SAXException {
        if (state != null) {
            Handler handler = state.getHandler();
            if (handler != null) {
                return handler.handle(tag, atts, state.getEndState());
            }
            return state.getEndState();
        }
        return currentState;
    }
}

