/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.io.InputStream;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.read.xgmml.GenericXGMMLFileFilter;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.util.StreamUtil;

public class SessionXGMMLNetworkViewFileFilter
extends GenericXGMMLFileFilter {
    protected static final Pattern SESSION_XGMML_VIEW_PATTERN = Pattern.compile("cy:view=[\\'\"](1|true)[\\'\"]");

    public SessionXGMMLNetworkViewFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, ReadCache cache, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, cache, streamUtil);
    }

    public SessionXGMMLNetworkViewFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, ReadCache cache, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, cache, streamUtil);
    }

    @Override
    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != this.category || !this.cache.isReadingSessionFile()) {
            return false;
        }
        String root = this.getXGMMLRootElement(stream);
        if (root != null) {
            Matcher matcher = SESSION_XGMML_VIEW_PATTERN.matcher(root);
            return matcher.find();
        }
        return false;
    }
}

