/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.io.internal.read.xgmml.XGMMLParser;
import org.cytoscape.io.internal.read.xgmml.handler.ReadDataManager;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.EdgeBendVisualProperty;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class GenericXGMMLReader
extends AbstractCyNetworkReader {
    public static final String REPAIR_BARE_AMPERSANDS_PROPERTY = "cytoscape.xgmml.repair.bare.ampersands";
    protected final ReadDataManager readDataMgr;
    protected final XGMMLParser parser;
    protected final UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr;
    protected final CyServiceRegistrar serviceRegistrar;
    private VisualLexicon visualLexicon;
    private static final Map<String, String> legacyArrowShapes = new HashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Pattern DIRECT_NODE_PROPS_PATTERN;
    private static final Pattern DIRECT_NET_PROPS_PATTERN;
    private static final Pattern XGMML_TRANSPARENCY_PATTERN;
    private static final Pattern OLD_ARROW_SHAPE_PATTERN;
    private static final Pattern OLD_FONT_PATTERN;

    public GenericXGMMLReader(InputStream inputStream, ReadDataManager readDataMgr, XGMMLParser parser, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, CyApplicationManager applicationManager, CyNetworkFactory netFactory, CyNetworkManager netManager, CyRootNetworkManager rootNetManager, CyServiceRegistrar serviceRegistrar) {
        super(inputStream, applicationManager, netFactory, netManager, rootNetManager);
        List selectedNetworks;
        this.readDataMgr = readDataMgr;
        this.parser = parser;
        this.unrecognizedVisualPropertyMgr = unrecognizedVisualPropertyMgr;
        this.serviceRegistrar = serviceRegistrar;
        boolean attemptRepair = Boolean.getBoolean(REPAIR_BARE_AMPERSANDS_PROPERTY);
        if (attemptRepair) {
            this.inputStream = new RepairBareAmpersandsInputStream(inputStream, 512);
        }
        if (!readDataMgr.getCache().isReadingSessionFile() && (selectedNetworks = this.cyApplicationManager.getSelectedNetworks()) != null && selectedNetworks.size() > 0) {
            CyNetwork selectedNetwork = (CyNetwork)this.cyApplicationManager.getSelectedNetworks().get(0);
            String rootName = "";
            if (selectedNetwork instanceof CySubNetwork) {
                CySubNetwork subnet = (CySubNetwork)selectedNetwork;
                CyRootNetwork rootNet = subnet.getRootNetwork();
                rootName = (String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class);
            } else {
                rootName = (String)selectedNetwork.getRow((CyIdentifiable)selectedNetwork).get("name", String.class);
            }
            this.getRootNetworkList().setSelectedValue((Object)rootName);
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        this.init(tm);
        try {
            this.readXGMML(tm);
            this.complete(tm);
        }
        catch (Exception e) {
            throw new IOException("Could not parse XGMML file.", e);
        }
        finally {
            this.readDataMgr.dispose();
        }
        tm.setProgress(1.0);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        NetworkViewRenderer networkViewRenderer = null;
        if (this.readDataMgr.getRendererId() != null) {
            networkViewRenderer = this.cyApplicationManager.getNetworkViewRenderer(this.readDataMgr.getRendererId());
        }
        CyNetworkViewFactory netViewFactory = networkViewRenderer != null ? networkViewRenderer.getNetworkViewFactory() : this.getNetworkViewFactory();
        CyNetworkView netView = netViewFactory.createNetworkView(network);
        this.setNetworkViewProperties(netView);
        if (((CyNetwork)netView.getModel()).getNodeCount() > 0) {
            Iterable nodes = netView.getNodeViewsIterable();
            Iterable edges = netView.getEdgeViewsIterable();
            for (View nodeView : nodes) {
                this.setNodeViewProperties(netView, (View<CyNode>)nodeView);
            }
            for (View edgeView : edges) {
                this.setEdgeViewProperties(netView, (View<CyEdge>)edgeView);
            }
        }
        if (!this.readDataMgr.isSessionFormat()) {
            this.readDataMgr.updateGroupNodes(netView);
        }
        return netView;
    }

    protected void init(TaskMonitor tm) {
        this.readDataMgr.init();
        this.readDataMgr.setViewFormat(false);
        CyRootNetwork networkCollection = this.getRootNetwork();
        Map nMap = this.getNodeMap();
        this.readDataMgr.setNodeMap(nMap);
        this.readDataMgr.setParentNetwork(networkCollection);
    }

    protected void complete(TaskMonitor tm) {
        Set<CyNetwork> netSet = this.readDataMgr.getPublicNetworks();
        this.networks = netSet.toArray(new CyNetwork[netSet.size()]);
    }

    protected void readXGMML(TaskMonitor tm) throws SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            XMLReader reader = sp.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            ParserAdapter pa = new ParserAdapter(sp.getParser());
            pa.setContentHandler(this.parser);
            pa.setErrorHandler(this.parser);
            pa.parse(new InputSource(this.inputStream));
        }
        catch (OutOfMemoryError oe) {
            System.gc();
            throw new RuntimeException("Out of memory error caught. The network being loaded is too large for the current memory allocation.  Use the -Xmx flag for the java virtual machine to increase the amount of memory available, e.g. java -Xmx1G cytoscape.jar -p apps ....");
        }
        catch (ParserConfigurationException e) {
            logger.error("XGMMLParser: " + e.getMessage());
        }
        catch (SAXParseException e) {
            logger.error("XGMMLParser: fatal parsing error on line " + e.getLineNumber() + " -- '" + e.getMessage() + "'");
            throw e;
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (Exception e) {
                    logger.warn("Cannot close XGMML input stream", (Throwable)e);
                }
            }
        }
    }

    protected void setNetworkViewProperties(CyNetworkView netView) {
        CyNetwork network = (CyNetwork)netView.getModel();
        String name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        if (name != null) {
            netView.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, (Object)name);
        }
        Map<String, String> atts = this.readDataMgr.getGraphicsAttributes((CyIdentifiable)network);
        this.setVisualProperties(netView, (View<? extends CyIdentifiable>)netView, atts);
    }

    protected void setNodeViewProperties(CyNetworkView netView, View<CyNode> nodeView) {
        CyNode node = (CyNode)nodeView.getModel();
        Map<String, String> atts = this.readDataMgr.getGraphicsAttributes((CyIdentifiable)node);
        this.setVisualProperties(netView, nodeView, atts);
    }

    protected void setEdgeViewProperties(CyNetworkView netView, View<CyEdge> edgeView) {
        CyEdge edge = (CyEdge)edgeView.getModel();
        Map<String, String> atts = this.readDataMgr.getGraphicsAttributes((CyIdentifiable)edge);
        this.setVisualProperties(netView, edgeView, atts);
        Bend bend = (Bend)edgeView.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND);
        if (bend != null && bend != EdgeBendVisualProperty.DEFAULT_EDGE_BEND) {
            List handles = bend.getAllHandles();
            for (Handle handle : handles) {
                handle.defineHandle(netView, edgeView, Double.NaN, Double.NaN);
            }
        }
    }

    protected void setVisualProperties(CyNetworkView netView, View<? extends CyIdentifiable> view, Map<String, String> atts) {
        if (view != null && atts != null) {
            CyIdentifiable model = (CyIdentifiable)view.getModel();
            Class<CyNetwork> type = CyNetwork.class;
            if (model instanceof CyNode) {
                type = CyNode.class;
            } else if (model instanceof CyEdge) {
                type = CyEdge.class;
            }
            Set<String> attSet = atts.keySet();
            for (String attName : attSet) {
                String attValue = atts.get(attName);
                VisualProperty vp = this.getVisualLexicon().lookup(type, attName);
                if (vp != null) {
                    Object parsedValue;
                    if (GenericXGMMLReader.isXGMMLTransparency(attName)) {
                        attValue = GenericXGMMLReader.convertXGMMLTransparencyValue(attValue);
                    } else if (GenericXGMMLReader.isOldArrowShape(attName)) {
                        attValue = GenericXGMMLReader.convertOldArrowShapeValue(attValue);
                    }
                    if ((parsedValue = vp.parseSerializableString(attValue)) == null) continue;
                    if (this.isLockedVisualProperty(model, attName)) {
                        view.setLockedValue(vp, parsedValue);
                        continue;
                    }
                    view.setVisualProperty(vp, parsedValue);
                    continue;
                }
                if (this.readDataMgr.isSessionFormat() && this.readDataMgr.getDocumentVersion() < 3.0) continue;
                this.unrecognizedVisualPropertyMgr.addUnrecognizedVisualProperty(netView, view, attName, attValue);
            }
        }
    }

    protected VisualLexicon getVisualLexicon() {
        if (this.visualLexicon == null) {
            this.visualLexicon = ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getDefaultVisualLexicon();
        }
        return this.visualLexicon;
    }

    protected boolean isLockedVisualProperty(CyIdentifiable element, String attName) {
        boolean locked = true;
        if (element instanceof CyNetwork) {
            Matcher netMatcher = DIRECT_NET_PROPS_PATTERN.matcher(attName);
            locked = !netMatcher.matches();
        } else if (element instanceof CyNode) {
            Matcher nodeMatcher = DIRECT_NODE_PROPS_PATTERN.matcher(attName);
            locked = !nodeMatcher.matches();
        } else if (element instanceof CyEdge) {
            // empty if block
        }
        return locked;
    }

    static boolean isXGMMLTransparency(String attName) {
        Matcher matcher = XGMML_TRANSPARENCY_PATTERN.matcher(attName);
        return matcher.matches();
    }

    static boolean isOldArrowShape(String attName) {
        Matcher matcher = OLD_ARROW_SHAPE_PATTERN.matcher(attName);
        return matcher.matches();
    }

    static boolean isOldFont(String attName) {
        Matcher matcher = OLD_FONT_PATTERN.matcher(attName);
        return matcher.matches();
    }

    static String convertXGMMLTransparencyValue(String s) {
        try {
            float f = Float.valueOf(s).floatValue();
            return "" + Math.round(f * 255.0f);
        }
        catch (Exception e) {
            logger.warn("Cannot convert XGMML transparency value: " + s, (Throwable)e);
            return "255";
        }
    }

    static String convertOldArrowShapeValue(String s) {
        String value = legacyArrowShapes.get(s);
        if (value == null) {
            value = s;
        }
        return value;
    }

    static String convertOldFontValue(String s) {
        if (s.matches("(?i)[^\\-]+(-bold)?-\\d+(\\.\\d+)?-\\d+(\\.\\d+)?")) {
            String name = s.replaceAll("(?i)(\\.bold)?(-bold)?-\\d+(\\.\\d+)?-\\d+(\\.\\d+)?", "");
            String weight = s.matches("(?i)[^\\-]+(\\.|-)bold-.*") ? "bold" : "plain";
            String size = s.replaceAll("(?i)[^\\-]+(-bold)?-\\d+(\\.\\d+)?-", "").replaceAll("\\.\\d+", "");
            return name + "," + weight + "," + size;
        }
        return s;
    }

    static {
        legacyArrowShapes.put("0", "NONE");
        legacyArrowShapes.put("1", "DELTA");
        legacyArrowShapes.put("2", "DELTA");
        legacyArrowShapes.put("3", "DELTA");
        legacyArrowShapes.put("4", "ARROW");
        legacyArrowShapes.put("5", "ARROW");
        legacyArrowShapes.put("6", "ARROW");
        legacyArrowShapes.put("7", "DIAMOND");
        legacyArrowShapes.put("8", "DIAMOND");
        legacyArrowShapes.put("9", "DIAMOND");
        legacyArrowShapes.put("10", "CIRCLE");
        legacyArrowShapes.put("11", "CIRCLE");
        legacyArrowShapes.put("12", "CIRCLE");
        legacyArrowShapes.put("13", "T");
        legacyArrowShapes.put("14", "T");
        legacyArrowShapes.put("15", "T");
        legacyArrowShapes.put("16", "HALF_TOP");
        legacyArrowShapes.put("17", "HALF_BOTTOM");
        legacyArrowShapes.put("HALF_ARROW_TOP", "HALF_TOP");
        legacyArrowShapes.put("HALF_ARROW_BOTTOM", "HALF_BOTTOM");
        DIRECT_NODE_PROPS_PATTERN = Pattern.compile("x|y|z");
        DIRECT_NET_PROPS_PATTERN = Pattern.compile("GRAPH_VIEW_(ZOOM|CENTER_(X|Y))|NETWORK_(WIDTH|HEIGHT|SCALE_FACTOR|CENTER_(X|Y|Z)_LOCATION)");
        XGMML_TRANSPARENCY_PATTERN = Pattern.compile("(cy:)?(node|edge)Transparency");
        OLD_ARROW_SHAPE_PATTERN = Pattern.compile("(?i)(cy:|edge)?(source|target)Arrow(Shape)?");
        OLD_FONT_PATTERN = Pattern.compile("(cy:)?(node|edge)LabelFont");
    }

    private static class RepairBareAmpersandsInputStream
    extends PushbackInputStream {
        private final byte[] encodedAmpersand = new byte[]{97, 109, 112, 59};

        public RepairBareAmpersandsInputStream(InputStream in) {
            super(in);
        }

        public RepairBareAmpersandsInputStream(InputStream in, int size) {
            super(in, size);
        }

        @Override
        public int read() throws IOException {
            byte[] b;
            int cnt;
            int c = super.read();
            if (c == 38 && (cnt = this.read(b = new byte[7])) > 0) {
                boolean isEntity = false;
                for (int i = 0; i < cnt && !isEntity; ++i) {
                    isEntity = b[i] == 59;
                }
                byte[] pb = new byte[cnt];
                for (int p = 0; p < cnt; ++p) {
                    pb[p] = b[p];
                }
                this.unread(pb);
                if (!isEntity) {
                    this.unread(this.encodedAmpersand);
                }
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int cnt;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = -1;
            for (cnt = 0; cnt < len && (c = this.read()) != -1; ++cnt) {
                b[off] = (byte)c;
                ++off;
            }
            if (c == -1 && cnt == 0) {
                cnt = -1;
            }
            return cnt;
        }
    }
}

