/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericXGMMLFileFilter
extends BasicCyFileFilter {
    public static final Pattern XGMML_HEADER_PATTERN = Pattern.compile("<graph[\\s]+[^<>]*[\\'\"]http://www.cs.rpi.edu/XGMML[\\'\"][^<>]*>|<!DOCTYPE[\\s]+graph[\\s]+[^<>]*[\\'\"][^<>]*xgmml.dtd[\\'\"][^<>]*>");
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected final ReadCache cache;

    public GenericXGMMLFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, ReadCache cache, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.cache = cache;
    }

    public GenericXGMMLFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, ReadCache cache, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
        this.cache = cache;
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != this.category || this.cache.isReadingSessionFile()) {
            return false;
        }
        return this.getXGMMLRootElement(stream) != null;
    }

    public boolean accepts(URI uri, DataCategory category) {
        boolean bl;
        block8: {
            InputStream is = uri.toURL().openStream();
            try {
                bl = this.accepts(is, category);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while opening stream: " + uri, (Throwable)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    protected String getXGMMLRootElement(InputStream stream) {
        String header = this.getHeader(stream, 20);
        Matcher matcher = XGMML_HEADER_PATTERN.matcher(header);
        String root = null;
        if (matcher.find()) {
            root = matcher.group(0);
        }
        return root;
    }
}

