/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.io.internal.read.datatable.CSVCyReaderFactory;
import org.cytoscape.io.internal.read.datatable.CyTablesXMLReader;
import org.cytoscape.io.internal.read.session.AbstractSessionReader;
import org.cytoscape.io.internal.read.session.CyTableMetadataImpl;
import org.cytoscape.io.internal.read.xgmml.SessionXGMMLNetworkViewReader;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.internal.util.SUIDUpdater;
import org.cytoscape.io.internal.util.cytables.model.BypassValue;
import org.cytoscape.io.internal.util.cytables.model.ColumnView;
import org.cytoscape.io.internal.util.cytables.model.CyTables;
import org.cytoscape.io.internal.util.cytables.model.RowView;
import org.cytoscape.io.internal.util.cytables.model.TableView;
import org.cytoscape.io.internal.util.cytables.model.VirtualColumn;
import org.cytoscape.io.internal.util.session.SessionUtil;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.io.read.CyPropertyReader;
import org.cytoscape.io.read.CyPropertyReaderManager;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.io.read.VizmapReader;
import org.cytoscape.io.read.VizmapReaderManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.SimpleCyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.table.CyColumnViewMetadata;
import org.cytoscape.view.model.table.CyRowViewMetadata;
import org.cytoscape.view.model.table.CyTableViewMetadata;
import org.cytoscape.work.TaskMonitor;

public class Cy3SessionReaderImpl
extends AbstractSessionReader {
    private static final String TEMP_DIR = "java.io.tmpdir";
    public static final Pattern NETWORK_PATTERN = Pattern.compile(".*/networks/(([^/]+)[.]xgmml)");
    public static final Pattern NETWORK_NAME_PATTERN = Pattern.compile("(\\d+)(-(.+))?");
    public static final Pattern NETWORK_VIEW_PATTERN = Pattern.compile(".*/views/(([^/]+)[.]xgmml)");
    public static final Pattern NETWORK_VIEW_NAME_PATTERN = Pattern.compile("(\\d+)-(\\d+)(-(.+))?");
    public static final Pattern NETWORK_TABLE_PATTERN = Pattern.compile(".*/(([^/]+)/([^/]+)-([^/]+)-([^/]+)[.]cytable)");
    public static final Pattern GLOBAL_TABLE_PATTERN = Pattern.compile(".*/(global/(\\d+)-([^/]+)[.]cytable)");
    public static final Pattern PROPERTIES_PATTERN = Pattern.compile(".*/properties/?(([^/]+)[.](props|properties))");
    private static final String THUMBNAIL_FILE = "session_thumbnail.png";
    private final Map<Long, CyNetwork> networkLookup = new LinkedHashMap<Long, CyNetwork>();
    private final Map<Long, Set<CyTableMetadataImpl.CyTableMetadataBuilder>> networkTableMap = new HashMap<Long, Set<CyTableMetadataImpl.CyTableMetadataBuilder>>();
    private final SUIDUpdater suidUpdater;
    private final CyNetworkReaderManager networkReaderMgr;
    private final CyPropertyReaderManager propertyReaderMgr;
    private final VizmapReaderManager vizmapReaderMgr;
    private final CSVCyReaderFactory csvCyReaderFactory;
    protected final Map<String, CyTable> filenameTableMap;
    private Map<CyTableMetadataImpl.CyTableMetadataBuilder, String> builderFilenameMap;
    protected final List<VirtualColumn> virtualColumns;
    private boolean networksExtracted;

    public Cy3SessionReaderImpl(InputStream sourceInputStream, ReadCache cache, GroupUtil groupUtil, SUIDUpdater suidUpdater, CyNetworkReaderManager networkReaderMgr, CyPropertyReaderManager propertyReaderMgr, VizmapReaderManager vizmapReaderMgr, CSVCyReaderFactory csvCyReaderFactory, CyServiceRegistrar serviceRegistrar) {
        super(sourceInputStream, cache, groupUtil, serviceRegistrar);
        if (suidUpdater == null) {
            throw new NullPointerException("SUID updater is null.");
        }
        this.suidUpdater = suidUpdater;
        if (networkReaderMgr == null) {
            throw new NullPointerException("network reader manager is null.");
        }
        this.networkReaderMgr = networkReaderMgr;
        if (propertyReaderMgr == null) {
            throw new NullPointerException("property reader manager is null.");
        }
        this.propertyReaderMgr = propertyReaderMgr;
        if (vizmapReaderMgr == null) {
            throw new NullPointerException("vizmap reader manager is null.");
        }
        this.vizmapReaderMgr = vizmapReaderMgr;
        if (csvCyReaderFactory == null) {
            throw new NullPointerException("table reader manager is null.");
        }
        this.csvCyReaderFactory = csvCyReaderFactory;
        this.virtualColumns = new LinkedList<VirtualColumn>();
        this.filenameTableMap = new HashMap<String, CyTable>();
        this.builderFilenameMap = new HashMap<CyTableMetadataImpl.CyTableMetadataBuilder, String>();
    }

    @Override
    protected void init(TaskMonitor tm) throws Exception {
        super.init(tm);
        this.suidUpdater.init();
    }

    @Override
    protected void handleEntry(InputStream is, String entryName) throws Exception {
        if (!this.networksExtracted) {
            if (entryName.contains("/apps/")) {
                this.extractAppEntry(is, entryName);
            } else if (entryName.endsWith("vizmap.xml")) {
                this.extractVizmap(is, entryName);
            } else if (entryName.contains("/properties/")) {
                this.extractProperties(is, entryName);
            } else if (entryName.endsWith(".xgmml")) {
                Matcher matcher = NETWORK_PATTERN.matcher(entryName);
                if (matcher.matches()) {
                    this.extractNetworks(is, entryName);
                }
            } else if (entryName.endsWith(".cytable")) {
                this.extractTable(is, entryName);
            } else if (entryName.endsWith("cytables.xml")) {
                this.extractCyTableSessionState(is, entryName);
            } else if (!entryName.endsWith(".version") && !entryName.endsWith("/session_thumbnail.png")) {
                this.logger.warn("Unknown entry found in session zip file!\n" + entryName);
            }
        } else if (!entryName.contains("/apps/") && entryName.endsWith(".xgmml")) {
            Matcher matcher = NETWORK_VIEW_PATTERN.matcher(entryName);
            if (matcher.matches()) {
                this.extractNetworkView(is, entryName);
            }
        } else if (entryName.endsWith("cytables.xml")) {
            this.extractTableViews(is, entryName);
        }
    }

    @Override
    protected void complete(TaskMonitor tm) throws Exception {
        tm.setProgress(0.4);
        tm.setTitle("Set network tables");
        tm.setStatusMessage("Setting network tables...");
        this.mergeNetworkTables();
        tm.setProgress(0.5);
        tm.setTitle("Restore virtual columns");
        tm.setStatusMessage("Restoring virtual columns...");
        this.restoreVirtualColumns();
        tm.setProgress(0.55);
        tm.setTitle("Restore equations");
        tm.setStatusMessage("Restoring equations...");
        this.restoreEquations();
        tm.setProgress(0.6);
        tm.setTitle("Update network columns");
        tm.setStatusMessage("Moving column \"Cy2 Parent Network.SUID\"...");
        this.moveParentNetworkColumn();
        tm.setProgress(0.65);
        tm.setTitle("Extract network views");
        tm.setStatusMessage("Extracting network views...");
        this.networksExtracted = true;
        this.readSessionFile(tm);
        tm.setProgress(0.8);
        tm.setTitle("Update SUID columns");
        tm.setStatusMessage("Updating SUID columns...");
        this.updateSUIDColumns();
        super.complete(tm);
    }

    @Override
    protected void createObjectMap() {
        this.objectMap.put(CyNetwork.class, this.cache.getNetworkByIdMap());
        this.objectMap.put(CyNetworkView.class, this.cache.getNetworkViewByIdMap());
        this.objectMap.put(CyNode.class, this.cache.getNodeByIdMap());
        this.objectMap.put(CyEdge.class, this.cache.getEdgeByIdMap());
    }

    private void extractCyTableSessionState(InputStream is, String entryName) throws IOException {
        CyTablesXMLReader reader = new CyTablesXMLReader(is);
        try {
            reader.run(this.taskMonitor);
            CyTables cyTables = reader.getCyTables();
            this.virtualColumns.addAll(cyTables.getVirtualColumns().getVirtualColumn());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void extractTable(InputStream stream, String entryName) throws Exception {
        CyTableReader reader = (CyTableReader)this.csvCyReaderFactory.createTaskIterator(stream, entryName).next();
        reader.run((TaskMonitor)this.taskMonitor);
        CyTable table = reader.getTables()[0];
        Matcher matcher = NETWORK_TABLE_PATTERN.matcher(entryName);
        if (matcher.matches()) {
            String networkName = SessionUtil.unescape(matcher.group(2));
            Long oldNetId = this.getOldNetworkId(networkName);
            if (oldNetId == null) {
                throw new NullPointerException("Cannot extract table. Network SUID is null for entry: " + entryName);
            }
            String namespace = SessionUtil.unescape(matcher.group(3));
            Class<?> type = Class.forName(SessionUtil.unescape(matcher.group(4)));
            String title = SessionUtil.unescape(matcher.group(5));
            table.setTitle(title);
            CyTableMetadataImpl.CyTableMetadataBuilder builder = new CyTableMetadataImpl.CyTableMetadataBuilder().setCyTable(table).setNamespace(namespace).setType(type);
            Set<CyTableMetadataImpl.CyTableMetadataBuilder> builders = this.networkTableMap.get(oldNetId);
            if (builders == null) {
                builders = new HashSet<CyTableMetadataImpl.CyTableMetadataBuilder>();
                this.networkTableMap.put(oldNetId, builders);
            }
            builders.add(builder);
            String filename = matcher.group(1);
            this.filenameTableMap.put(filename, table);
            this.builderFilenameMap.put(builder, filename);
            return;
        }
        matcher = GLOBAL_TABLE_PATTERN.matcher(entryName);
        if (matcher.matches()) {
            String title = SessionUtil.unescape(matcher.group(3));
            table.setTitle(title);
            CyTableMetadataImpl.CyTableMetadataBuilder builder = new CyTableMetadataImpl.CyTableMetadataBuilder().setCyTable(table).setNetwork(null);
            this.tableMetadata.add(builder.build());
            String filename = matcher.group(1);
            this.filenameTableMap.put(filename, table);
            this.builderFilenameMap.put(builder, filename);
            long tableSUID = Long.parseLong(matcher.group(2));
            this.suidUpdater.addSUIDMapping(tableSUID, table.getSUID());
            this.suidUpdater.addTable(table);
        }
    }

    private void extractNetworks(InputStream is, String entryName) throws Exception {
        CyNetwork[] netArray;
        CyNetworkReader reader = this.networkReaderMgr.getReader(is, entryName);
        reader.run((TaskMonitor)this.taskMonitor);
        CyRootNetworkManager rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        for (CyNetwork net : netArray = reader.getNetworks()) {
            CyRootNetwork rootNet = rootNetworkManager.getRootNetwork(net);
            if (!this.networkLookup.containsKey(rootNet.getSUID())) {
                // empty if block
            }
            this.networkLookup.put(rootNet.getSUID(), (CyNetwork)rootNet);
            this.networkLookup.put(net.getSUID(), net);
            this.networks.add(net);
        }
    }

    private void extractNetworkView(InputStream is, String entryName) throws Exception {
        String netViewToken;
        Matcher matcher = NETWORK_VIEW_PATTERN.matcher(entryName);
        Long oldNetId = null;
        if (matcher.matches() && (matcher = NETWORK_VIEW_NAME_PATTERN.matcher(netViewToken = matcher.group(2))).matches()) {
            try {
                oldNetId = Long.valueOf(matcher.group(1));
            }
            catch (NumberFormatException nfe) {
                this.logger.error("Cannot extract network view SUID from: " + netViewToken);
            }
        }
        if (oldNetId != null) {
            CyNetwork network = this.cache.getNetwork(oldNetId);
            if (network != null && !this.cancelled) {
                String vsName;
                CyNetworkReader reader = this.networkReaderMgr.getReader(is, entryName);
                reader.run((TaskMonitor)this.taskMonitor);
                CyNetworkView view = reader.buildCyNetworkView(network);
                this.networkViews.add(view);
                if (reader instanceof SessionXGMMLNetworkViewReader && (vsName = ((SessionXGMMLNetworkViewReader)reader).getVisualStyleName()) != null && !vsName.isEmpty()) {
                    this.visualStyleMap.put(view, vsName);
                }
            }
        } else {
            this.logger.error("The network view cannot be recreated. The network view entry is invalid: " + entryName);
        }
    }

    private void extractTableViews(InputStream is, String entryName) throws Exception {
        CyTables xmlTables;
        CyTablesXMLReader reader = new CyTablesXMLReader(is);
        try {
            reader.run(this.taskMonitor);
            xmlTables = reader.getCyTables();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (xmlTables.getTableViews() != null) {
            List<TableView> xmlTableViews = xmlTables.getTableViews().getTableView();
            for (TableView xmlTableView : xmlTableViews) {
                CyTableMetadata table = this.lookupTable(xmlTableView);
                CyColumn keyCol = table.getTable().getPrimaryKey();
                String rendererId = xmlTableView.getRendererId();
                String namespace = xmlTableView.getTableNamespace();
                ArrayList<CyColumnViewMetadata> columnViews = new ArrayList<CyColumnViewMetadata>();
                for (ColumnView xmlColView : xmlTableView.getColumnView()) {
                    String styleTitle = xmlColView.getStyleTitle();
                    String string = xmlColView.getColumnName();
                    HashMap<String, String> colBypasses = new HashMap<String, String>();
                    for (BypassValue xmlBypass : xmlColView.getBypassValue()) {
                        colBypasses.put(xmlBypass.getName(), xmlBypass.getValue());
                    }
                    columnViews.add(new CyColumnViewMetadata(string, styleTitle, colBypasses));
                }
                boolean isSuid = Cy3SessionReaderImpl.primaryKeyIsSUID(table.getTable());
                ArrayList<CyRowViewMetadata> rowViews = new ArrayList<CyRowViewMetadata>();
                for (RowView rowView : xmlTableView.getRowView()) {
                    Object keyVal = Cy3SessionReaderImpl.deserializeKey(rowView.getKey(), keyCol);
                    if (isSuid) {
                        keyVal = this.suidUpdater.getNewSUID((Long)keyVal);
                    }
                    HashMap<String, String> rowBypasses = new HashMap<String, String>();
                    for (BypassValue xmlBypass : rowView.getBypassValue()) {
                        rowBypasses.put(xmlBypass.getName(), xmlBypass.getValue());
                    }
                    rowViews.add(new CyRowViewMetadata(keyVal, rowBypasses));
                }
                HashMap<String, String> tableBypasses = new HashMap<String, String>();
                for (BypassValue xmlBypass : xmlTableView.getBypassValue()) {
                    tableBypasses.put(xmlBypass.getName(), xmlBypass.getValue());
                }
                CyTableViewMetadata cyTableViewMetadata = new CyTableViewMetadata(-1L, namespace, rendererId, tableBypasses, columnViews, rowViews, keyCol.getType(), keyCol.getListElementType());
                cyTableViewMetadata.setUnderlyingTable(table);
                this.tableViews.add(cyTableViewMetadata);
            }
        }
    }

    private static boolean primaryKeyIsSUID(CyTable table) {
        CyColumn pk = table.getPrimaryKey();
        return pk.getName().equals("SUID") && pk.getType().equals(Long.class);
    }

    private static Object deserializeKey(String key, CyColumn primaryKeyColumn) {
        Class type = primaryKeyColumn.getType();
        if (type.equals(List.class)) {
            String[] values;
            Class listElementType = primaryKeyColumn.getListElementType();
            ArrayList<Object> list = new ArrayList<Object>();
            for (String item : values = key.split("|")) {
                list.add(Cy3SessionReaderImpl.deserializeNonListValue(item, listElementType));
            }
            if (list.size() == 1 && list.get(0) == null) {
                return null;
            }
            return list;
        }
        return Cy3SessionReaderImpl.deserializeNonListValue(key, type);
    }

    private static Object deserializeNonListValue(String value, Class<?> type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (value.isEmpty()) {
            return null;
        }
        try {
            if (type.equals(Long.class)) {
                return Long.valueOf(value);
            }
            if (type.equals(Boolean.class)) {
                return Boolean.valueOf(value);
            }
            if (type.equals(Double.class)) {
                return Double.valueOf(value);
            }
            if (type.equals(Integer.class)) {
                return Integer.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private CyTableMetadata lookupTable(TableView xmlTableView) {
        CyTable table = this.filenameTableMap.get(xmlTableView.getTable());
        if (table == null) {
            return null;
        }
        for (CyTableMetadata tableMetadata : this.tableMetadata) {
            if (!tableMetadata.getTable().equals(table)) continue;
            return tableMetadata;
        }
        return null;
    }

    private void extractAppEntry(InputStream is, String entryName) {
        String[] items = entryName.split("/");
        if (items.length < 3) {
            return;
        }
        String appName = items[2];
        String fileName = items[items.length - 1];
        String tmpDir = System.getProperty(TEMP_DIR);
        File file = new File(tmpDir, fileName);
        try {
            file.deleteOnExit();
        }
        catch (Exception e) {
            this.logger.warn("This temporary app file may not be deleted on exit: " + file.getAbsolutePath(), (Throwable)e);
        }
        try {
            int len;
            BufferedInputStream bin = new BufferedInputStream(is);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[256];
            while ((len = bin.read(buf)) != -1 && !this.cancelled) {
                output.write(buf, 0, len);
            }
            output.flush();
            output.close();
            bin.close();
        }
        catch (IOException e) {
            this.logger.error("Error: read from zip: " + entryName, (Throwable)e);
            return;
        }
        if (this.cancelled) {
            return;
        }
        if (!this.appFileListMap.containsKey(appName)) {
            this.appFileListMap.put(appName, new ArrayList());
        }
        List fileList = (List)this.appFileListMap.get(appName);
        fileList.add(file);
    }

    private void extractVizmap(InputStream is, String entryName) throws Exception {
        Set associations;
        VizmapReader reader = this.vizmapReaderMgr.getReader(is, entryName);
        reader.run((TaskMonitor)this.taskMonitor);
        this.networkStyles.addAll(reader.getVisualStyles());
        Set tableVisualStyles = reader.getTableVisualStyles();
        if (tableVisualStyles != null) {
            this.tableStyles.addAll(tableVisualStyles);
        }
        if ((associations = reader.getColumnStyleAssociations()) != null) {
            this.columnStyleAssociations.addAll(associations);
        }
    }

    private void extractProperties(InputStream is, String entryName) throws Exception {
        CyPropertyReader reader = this.propertyReaderMgr.getReader(is, entryName);
        if (reader == null) {
            return;
        }
        reader.run((TaskMonitor)this.taskMonitor);
        SimpleCyProperty cyProps = null;
        Object obj = reader.getProperty();
        if (obj instanceof Properties) {
            String propsName;
            Properties props = (Properties)obj;
            Matcher matcher = PROPERTIES_PATTERN.matcher(entryName);
            if (matcher.matches() && (propsName = matcher.group(2)) != null) {
                cyProps = new SimpleCyProperty(propsName, (Object)props, Properties.class, CyProperty.SavePolicy.SESSION_FILE);
            }
        } else if (obj instanceof Bookmarks) {
            cyProps = new SimpleCyProperty("bookmarks", (Object)((Bookmarks)obj), Bookmarks.class, CyProperty.SavePolicy.SESSION_FILE);
        } else {
            this.logger.error("Cannot extract CyProperty name from: " + entryName);
        }
        if (cyProps != null) {
            this.properties.add(cyProps);
        }
    }

    protected void restoreVirtualColumns() throws Exception {
        if (this.virtualColumns == null) {
            return;
        }
        LinkedList<VirtualColumn> queue = new LinkedList<VirtualColumn>();
        queue.addAll(this.virtualColumns);
        VirtualColumn markedColumn = null;
        int lastSize = queue.size();
        while (!queue.isEmpty()) {
            String colName;
            if (this.cancelled) {
                return;
            }
            VirtualColumn vcData = (VirtualColumn)queue.poll();
            CyTable tgtTable = this.filenameTableMap.get(vcData.getTargetTable());
            if (tgtTable.getColumn(colName = vcData.getName()) != null) continue;
            CyTable srcTable = this.filenameTableMap.get(vcData.getSourceTable());
            String srcColName = vcData.getSourceColumn();
            String tgtJoinKey = vcData.getTargetJoinKey();
            if (srcTable.getColumn(srcColName) != null && tgtTable.getColumn(tgtJoinKey) != null) {
                try {
                    tgtTable.addVirtualColumn(colName, srcColName, srcTable, tgtJoinKey, vcData.isImmutable());
                    markedColumn = null;
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Error restoring virtual column \"" + colName + "\" in table \"" + tgtTable + "\"(" + vcData.getTargetTable() + ")--source table: \"" + srcTable + "\"(" + vcData.getSourceTable() + ")", e);
                }
            }
            queue.add(vcData);
            if (markedColumn == null) {
                markedColumn = vcData;
                lastSize = queue.size();
                continue;
            }
            if (vcData != markedColumn || queue.size() != lastSize) continue;
            StringBuilder msg = new StringBuilder("Cannot restore the following virtual columns because of missing or circular dependencies: ");
            String prefix = "";
            for (VirtualColumn vc : queue) {
                msg.append(prefix + vc.getTargetTable() + "." + vc.getName());
                prefix = ", ";
            }
            throw new Exception(msg.toString());
        }
    }

    private final void mergeNetworkTables() throws UnsupportedEncodingException {
        CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        for (Map.Entry<Long, Set<CyTableMetadataImpl.CyTableMetadataBuilder>> entry : this.networkTableMap.entrySet()) {
            Long oldId = entry.getKey();
            Set<CyTableMetadataImpl.CyTableMetadataBuilder> builders = entry.getValue();
            CyNetwork network = this.cache.getNetwork(oldId);
            if (network == null) {
                this.logger.error("Cannot merge network tables: Cannot find network " + oldId);
                continue;
            }
            for (CyTableMetadataImpl.CyTableMetadataBuilder builder : builders) {
                if (this.cancelled) {
                    return;
                }
                builder.setNetwork(network);
                this.mergeNetworkTable(network, builder, networkTableManager);
                CyTableMetadata metadata = builder.build();
                this.tableMetadata.add(metadata);
                String filename = this.builderFilenameMap.get(builder);
                this.filenameTableMap.put(filename, metadata.getTable());
            }
        }
    }

    private final void mergeNetworkTable(CyNetwork network, CyTableMetadataImpl.CyTableMetadataBuilder builder, CyNetworkTableManager networkTableMgr) {
        Class<?> type = builder.getType();
        String namespace = builder.getNamespace();
        CyTable src = builder.getTable();
        CyTable tgt = networkTableMgr.getTable(network, type, namespace);
        if (tgt == null) {
            networkTableMgr.setTable(network, type, namespace, src);
            builder.setCyTable(src);
            this.suidUpdater.addTable(src);
        } else {
            this.mergeTables(src, tgt, type);
            builder.setCyTable(tgt);
            this.suidUpdater.addTable(tgt);
        }
    }

    private void mergeTables(CyTable source, CyTable target, Class<? extends CyIdentifiable> type) {
        CyColumn sourceKey = source.getPrimaryKey();
        CyColumn targetKey = target.getPrimaryKey();
        String keyName = sourceKey.getName();
        if (keyName.equals(targetKey.getName())) {
            this.mergeColumns(keyName, source, target);
            for (CyRow sourceRow : source.getAllRows()) {
                Long mappedKey;
                if (this.cancelled) {
                    return;
                }
                Long key = (Long)sourceRow.get(keyName, Long.class);
                CyIdentifiable entry = this.cache.getObjectById(key, type);
                Long l = mappedKey = entry != null ? entry.getSUID() : null;
                if (mappedKey == null) {
                    mappedKey = key;
                }
                CyRow targetRow = target.getRow((Object)mappedKey);
                this.mergeRow(keyName, sourceRow, targetRow);
            }
        }
    }

    private void mergeColumns(String keyName, CyTable source, CyTable target) {
        for (CyColumn column : source.getColumns()) {
            String columnName = column.getName();
            if (columnName.equals(keyName) || target.getColumn(columnName) != null) continue;
            Class type = column.getType();
            boolean immutable = column.isImmutable();
            if (type.equals(List.class)) {
                Class elementType = column.getListElementType();
                target.createListColumn(columnName, elementType, immutable);
                continue;
            }
            target.createColumn(columnName, type, immutable);
        }
    }

    private void mergeRow(String keyName, CyRow sourceRow, CyRow targetRow) {
        for (CyColumn column : sourceRow.getTable().getColumns()) {
            if (this.cancelled) {
                return;
            }
            String columnName = column.getName();
            if (columnName.equals(keyName)) continue;
            Object value = sourceRow.getRaw(columnName);
            targetRow.set(columnName, value);
        }
    }

    private void updateSUIDColumns() {
        this.suidUpdater.updateSUIDColumns();
    }

    private Long getOldNetworkId(String networkToken) {
        Long id = null;
        Matcher matcher = NETWORK_NAME_PATTERN.matcher(networkToken);
        if (matcher.matches()) {
            String s = matcher.group(1);
            try {
                id = Long.valueOf(s);
            }
            catch (NumberFormatException nfe) {
                this.logger.error("Cannot extract network SUID from: " + networkToken);
            }
        }
        return id;
    }

    private void restoreEquations() {
        EquationCompiler compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        for (CyNetwork network : this.networkLookup.values()) {
            EquationUtil.refreshEquations((CyTable)network.getDefaultNetworkTable(), (EquationCompiler)compiler);
            EquationUtil.refreshEquations((CyTable)network.getDefaultNodeTable(), (EquationCompiler)compiler);
            EquationUtil.refreshEquations((CyTable)network.getDefaultEdgeTable(), (EquationCompiler)compiler);
        }
    }

    private void moveParentNetworkColumn() {
        for (CyNetwork net : this.networks) {
            try {
                CyTable tbl = net.getRow((CyIdentifiable)net, "LOCAL_ATTRS").getTable();
                if (tbl.getColumn("Cy2 Parent Network.SUID") == null) continue;
                CyRow row = tbl.getRow((Object)net.getSUID());
                Long parentSUID = (Long)row.get("Cy2 Parent Network.SUID", Long.class);
                CyRow hRow = net.getRow((CyIdentifiable)net, "HIDDEN");
                CyTable hTbl = hRow.getTable();
                if (hTbl.getColumn("__parentNetwork.SUID") == null) {
                    hTbl.createColumn("__parentNetwork.SUID", Long.class, false);
                }
                if (parentSUID != null) {
                    hRow.set("__parentNetwork.SUID", (Object)parentSUID);
                }
                tbl.deleteColumn("Cy2 Parent Network.SUID");
            }
            catch (Exception e) {
                this.logger.error("Unexpected error while moving column \"Cy2 Parent Network.SUID\"", (Throwable)e);
            }
        }
    }
}

