/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.cytoscape.io.internal.read.session.AbstractSessionReader;
import org.cytoscape.io.internal.read.xgmml.SessionXGMMLNetworkReader;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.internal.util.session.model.Child;
import org.cytoscape.io.internal.util.session.model.Cysession;
import org.cytoscape.io.internal.util.session.model.Cytopanel;
import org.cytoscape.io.internal.util.session.model.Cytopanels;
import org.cytoscape.io.internal.util.session.model.Desktop;
import org.cytoscape.io.internal.util.session.model.Edge;
import org.cytoscape.io.internal.util.session.model.Network;
import org.cytoscape.io.internal.util.session.model.NetworkFrame;
import org.cytoscape.io.internal.util.session.model.NetworkFrames;
import org.cytoscape.io.internal.util.session.model.Node;
import org.cytoscape.io.internal.util.session.model.SessionState;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.io.read.CyPropertyReader;
import org.cytoscape.io.read.CyPropertyReaderManager;
import org.cytoscape.io.read.VizmapReader;
import org.cytoscape.io.read.VizmapReaderManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.SimpleCyProperty;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;

public class Cy2SessionReaderImpl
extends AbstractSessionReader {
    private static final String TEMP_DIR = "java.io.tmpdir";
    private static final String DING_CG_MANAGER_NAME = "org.cytoscape.ding.customgraphicsmgr";
    public static final String CY_PROPS_FILE = "session_cytoscape.props";
    public static final Pattern NETWORK_PATTERN = Pattern.compile(".*/(([^/]+)[.]xgmml)");
    public static final Pattern PROPERTIES_PATTERN = Pattern.compile(".*/(([^/]+)[.]xgmml)");
    public static final String IGNORED_PROPS = "(cytoscape|proxy|logger|render|undo|vizmapper|nodelinkouturl|edgelinkouturl)\\.[^\\.]+.*|canonicalizeNames|defaultPluginDownloadUrl|defaultVisualStyle|defaultWebBrowser|exportTextAsShape|Linkout\\.externalLinkName|maximizeViewOnCreate|moduleNetworkViewCreationThreshold|nestedNetwork\\.imageScaleFactor|nestedNetworkSnapshotSize|preferredLayoutAlgorithm|secondaryViewThreshold|showQuickStartAtStartup|viewThreshold";
    public static final String PLUGINS_FOLDER = "plugins/";
    private final CyNetworkReaderManager networkReaderMgr;
    private final CyPropertyReaderManager propertyReaderMgr;
    private final VizmapReaderManager vizmapReaderMgr;
    protected Cysession cysession;
    private final Map<String, CyNetwork> networkLookup = new HashMap<String, CyNetwork>();
    private final Map<String, CyNetworkView> networkViewLookup = new HashMap<String, CyNetworkView>();
    private final Map<String, List<Node>> nodeSelectionLookup = new HashMap<String, List<Node>>();
    private final Map<String, List<Edge>> edgeSelectionLookup = new HashMap<String, List<Edge>>();
    private Map<String, String> xgmmlEntries;

    public Cy2SessionReaderImpl(InputStream sourceInputStream, ReadCache cache, GroupUtil groupUtil, CyNetworkReaderManager networkReaderMgr, CyPropertyReaderManager propertyReaderMgr, VizmapReaderManager vizmapReaderMgr, CyServiceRegistrar serviceRegistrar) {
        super(sourceInputStream, cache, groupUtil, serviceRegistrar);
        if (networkReaderMgr == null) {
            throw new NullPointerException("network reader manager is null.");
        }
        this.networkReaderMgr = networkReaderMgr;
        if (propertyReaderMgr == null) {
            throw new NullPointerException("property reader manager is null.");
        }
        this.propertyReaderMgr = propertyReaderMgr;
        if (vizmapReaderMgr == null) {
            throw new NullPointerException("vizmap reader manager is null.");
        }
        this.vizmapReaderMgr = vizmapReaderMgr;
        this.xgmmlEntries = new HashMap<String, String>();
    }

    @Override
    protected void handleEntry(InputStream is, String entryName) throws Exception {
        if (entryName.contains("/plugins/")) {
            this.extractPluginEntry(is, entryName);
        } else if (entryName.endsWith("cysession.xml")) {
            this.extractSessionState(is, entryName);
        } else if (entryName.endsWith("vizmap.props")) {
            this.extractVizmap(is, entryName);
        } else if (entryName.endsWith(CY_PROPS_FILE)) {
            this.extractProperties(is, entryName);
        } else if (entryName.endsWith(".xgmml")) {
            Matcher matcher = NETWORK_PATTERN.matcher(entryName);
            if (matcher.matches()) {
                String fileName = matcher.group(1);
                this.xgmmlEntries.put(fileName, entryName);
            }
        } else if (entryName.endsWith("session_bookmarks.xml")) {
            this.extractBookmarks(is, entryName);
        } else if (entryName.contains("/images/")) {
            this.extractImages(is, entryName);
        } else {
            this.logger.warn("Unknown entry found in session zip file!\n" + entryName);
        }
    }

    @Override
    protected void complete(TaskMonitor tm) throws Exception {
        if (this.cancelled) {
            return;
        }
        if (this.cysession == null) {
            throw new FileNotFoundException("Cannot find the cysession.xml file.");
        }
        tm.setProgress(0.4);
        tm.setTitle("Recreate networks");
        tm.setStatusMessage("Recreating networks...");
        this.extractNetworks(tm);
        tm.setProgress(0.8);
        tm.setTitle("Process networks");
        tm.setStatusMessage("Processing networks...");
        this.processNetworks();
        super.complete(tm);
    }

    @Override
    protected void createObjectMap() {
        this.objectMap.put(CyNetwork.class, this.cache.getNetworkByIdMap());
        this.objectMap.put(CyNetworkView.class, this.cache.getNetworkViewByIdMap());
        this.objectMap.put(CyNode.class, this.cache.getNodeByNameMap());
        this.objectMap.put(CyEdge.class, this.cache.getEdgeByIdMap());
    }

    private void extractNetworks(TaskMonitor tm) throws JAXBException, IOException {
        HashMap<String, Network> netMap = new HashMap<String, Network>();
        for (Network curNet : this.cysession.getNetworkTree().getNetwork()) {
            netMap.put(curNet.getId(), curNet);
        }
        CyRootNetworkManager rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        this.walkNetworkTree((Network)netMap.get("Network Root"), null, netMap, tm, rootNetworkManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void walkNetworkTree(Network net, CyNetwork parent, Map<String, Network> netMap, TaskMonitor tm, CyRootNetworkManager rootNetworkManager) {
        List<Child> children = net.getChild();
        int numChildren = children.size();
        Child child = null;
        Network childNet = null;
        for (int i = 0; i < numChildren; ++i) {
            CyNetwork cy2Parent;
            InputStream is;
            block17: {
                if (this.cancelled) {
                    return;
                }
                child = children.get(i);
                childNet = netMap.get(child.getId());
                String entryName = this.xgmmlEntries.get(childNet.getFilename());
                is = null;
                cy2Parent = null;
                is = this.findEntry(entryName);
                if (is != null) {
                    tm.setStatusMessage("Extracting network: " + entryName);
                    cy2Parent = this.extractNetworksAndViews(is, entryName, parent, childNet.isViewAvailable());
                    if (parent == null) {
                        parent = rootNetworkManager.getRootNetwork(cy2Parent);
                    }
                } else {
                    this.logger.error("Cannot find network file \"" + entryName + "\": ");
                }
                if (is == null) break block17;
                try {
                    is.close();
                }
                catch (Exception ex) {
                    this.logger.error("Unable to close XGMML input stream.", (Throwable)ex);
                }
                is = null;
            }
            if (this.cancelled || childNet.getChild().size() == 0) continue;
            this.walkNetworkTree(childNet, cy2Parent, netMap, tm, rootNetworkManager);
            continue;
            catch (Exception e) {
                block18: {
                    try {
                        String message = "Unable to read XGMML file \"" + childNet.getFilename() + "\": " + e.getMessage();
                        this.logger.error(message, (Throwable)e);
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception ex) {
                                this.logger.error("Unable to close XGMML input stream.", (Throwable)ex);
                            }
                            is = null;
                        }
                        if (!this.cancelled && childNet.getChild().size() != 0) {
                            this.walkNetworkTree(childNet, cy2Parent, netMap, tm, rootNetworkManager);
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (Exception ex) {
                        this.logger.error("Unable to close XGMML input stream.", (Throwable)ex);
                    }
                    is = null;
                }
                if (this.cancelled || childNet.getChild().size() == 0) continue;
                this.walkNetworkTree(childNet, cy2Parent, netMap, tm, rootNetworkManager);
                continue;
            }
        }
    }

    private CyNetwork extractNetworksAndViews(InputStream is, String entryName, CyNetwork parent, boolean createView) throws Exception {
        CyNetwork topNetwork = null;
        CyNetworkReader reader = this.networkReaderMgr.getReader(is, entryName);
        if (parent != null) {
            if (reader instanceof SessionXGMMLNetworkReader) {
                ((SessionXGMMLNetworkReader)reader).setParent(parent);
            } else {
                this.logger.error("CyNetworkReader should be an instance of XGMMLNetworkReader. Cannot extract network as sub-nertwork of: " + entryName);
            }
        }
        reader.run((TaskMonitor)this.taskMonitor);
        CyNetwork[] netArray = reader.getNetworks();
        if (netArray != null && netArray.length > 0) {
            topNetwork = netArray[0];
            for (int i = 0; i < netArray.length; ++i) {
                CyTable tbl;
                CyNetwork net = netArray[i];
                String netName = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
                this.networkLookup.put(netName, net);
                CyRow hRow = net.getRow((CyIdentifiable)net, "HIDDEN");
                CyTable hTbl = hRow.getTable();
                if (parent instanceof CySubNetwork) {
                    if (hTbl.getColumn("__parentNetwork.SUID") == null) {
                        hTbl.createColumn("__parentNetwork.SUID", Long.class, false);
                    }
                    hRow.set("__parentNetwork.SUID", (Object)parent.getSUID());
                }
                if ((tbl = net.getRow((CyIdentifiable)net, "LOCAL_ATTRS").getTable()).getColumn("Cy2 Parent Network.SUID") != null && !(parent instanceof CySubNetwork)) {
                    tbl.deleteColumn("Cy2 Parent Network.SUID");
                }
                List<Node> selNodes = this.nodeSelectionLookup.get(netName);
                List<Edge> selEdges = this.edgeSelectionLookup.get(netName);
                if (selNodes != null) {
                    this.setBooleanNodeAttr(net, selNodes, "selected", "USER");
                }
                if (selEdges != null) {
                    this.setBooleanEdgeAttr(net, selEdges, "selected", "USER");
                }
                this.networks.add(net);
                if (this.cancelled || i != 0 || !createView) continue;
                CyNetworkView view = reader.buildCyNetworkView(net);
                this.networkViewLookup.put(netName, view);
                this.networkViews.add(view);
                this.cache.cache(netName, (CyIdentifiable)view);
            }
        }
        return topNetwork;
    }

    private void extractPluginEntry(InputStream is, String entryName) {
        String[] items = entryName.split("/");
        if (items.length < 3) {
            return;
        }
        String appName = items[2];
        String fileName = items[items.length - 1];
        String tmpDir = System.getProperty(TEMP_DIR);
        File file = new File(tmpDir, fileName);
        try {
            file.deleteOnExit();
        }
        catch (Exception e) {
            this.logger.warn("This temporary app file may not be deleted on exit: " + file.getAbsolutePath(), (Throwable)e);
        }
        try {
            String inputLine;
            BufferedWriter out = null;
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8").newDecoder()));
            out = new BufferedWriter(new FileWriter(file));
            while ((inputLine = in.readLine()) != null && !this.cancelled) {
                out.write(inputLine);
                out.newLine();
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            this.logger.error("Error: read from zip: " + entryName, (Throwable)e);
            return;
        }
        if (this.cancelled) {
            return;
        }
        if (!this.appFileListMap.containsKey(appName)) {
            this.appFileListMap.put(appName, new ArrayList());
        }
        List fileList = (List)this.appFileListMap.get(appName);
        fileList.add(file);
    }

    private void extractVizmap(InputStream is, String entryName) throws Exception {
        VizmapReader reader = this.vizmapReaderMgr.getReader(is, entryName);
        reader.run((TaskMonitor)this.taskMonitor);
        this.networkStyles.addAll(reader.getVisualStyles());
    }

    private void extractProperties(InputStream is, String entryName) throws Exception {
        CyPropertyReader reader = this.propertyReaderMgr.getReader(is, entryName);
        if (reader == null) {
            return;
        }
        reader.run((TaskMonitor)this.taskMonitor);
        Properties props = (Properties)reader.getProperty();
        Properties newProps = new Properties();
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                if (!this.isSessionProperty(key)) continue;
                String value = props.getProperty(key);
                newProps.put(key, value);
            }
            SimpleCyProperty cyProps = new SimpleCyProperty("session", (Object)newProps, Properties.class, CyProperty.SavePolicy.SESSION_FILE);
            this.properties.add(cyProps);
        }
    }

    private void extractBookmarks(InputStream is, String entryName) throws Exception {
        CyPropertyReader reader = this.propertyReaderMgr.getReader(is, entryName);
        reader.run((TaskMonitor)this.taskMonitor);
        Bookmarks bookmarks = (Bookmarks)reader.getProperty();
        SimpleCyProperty cyProps = new SimpleCyProperty("bookmarks", (Object)bookmarks, Bookmarks.class, CyProperty.SavePolicy.SESSION_FILE);
        this.properties.add(cyProps);
    }

    private void extractImages(InputStream is, String entryName) {
        String[] items = entryName.split("/");
        if (items.length < 3) {
            return;
        }
        String fileName = items[items.length - 1];
        String tmpDir = System.getProperty(TEMP_DIR);
        File file = new File(tmpDir, fileName);
        try {
            int len;
            BufferedInputStream bin = new BufferedInputStream(is);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[256];
            while ((len = bin.read(buf)) != -1) {
                output.write(buf, 0, len);
            }
            output.flush();
            output.close();
            bin.close();
        }
        catch (IOException e) {
            this.logger.error("Error: read from zip: " + entryName, (Throwable)e);
            return;
        }
        if (!this.appFileListMap.containsKey(DING_CG_MANAGER_NAME)) {
            this.appFileListMap.put(DING_CG_MANAGER_NAME, new ArrayList());
        }
        List fileList = (List)this.appFileListMap.get(DING_CG_MANAGER_NAME);
        fileList.add(file);
    }

    private void extractSessionState(InputStream is, String entryName) throws Exception {
        CyPropertyReader reader = this.propertyReaderMgr.getReader(is, entryName);
        reader.run((TaskMonitor)this.taskMonitor);
        this.cysession = (Cysession)reader.getProperty();
        if (this.cysession != null) {
            Cytopanels cytopanels;
            NetworkFrames netFrames;
            if (this.cysession.getNetworkTree() != null) {
                for (Network net : this.cysession.getNetworkTree().getNetwork()) {
                    if (net.getId().equals("Network Root")) continue;
                    String netName = net.getId();
                    List<Node> selNodes = null;
                    List<Edge> selEdges = null;
                    if (net.getSelectedNodes() != null) {
                        selNodes = net.getSelectedNodes().getNode();
                    }
                    if (net.getSelectedEdges() != null) {
                        selEdges = net.getSelectedEdges().getEdge();
                    }
                    this.nodeSelectionLookup.put(netName, selNodes);
                    this.edgeSelectionLookup.put(netName, selEdges);
                }
            }
            StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            sb.append("<sessionState documentVersion=\"1.0\">\n");
            sb.append("    <networkFrames>\n");
            if (this.cysession.getSessionState() != null && this.cysession.getSessionState().getDesktop() != null && (netFrames = this.cysession.getSessionState().getDesktop().getNetworkFrames()) != null) {
                for (NetworkFrame nf : netFrames.getNetworkFrame()) {
                    String id = nf.getFrameID();
                    String x = nf.getX() != null ? nf.getX().toString() : "0";
                    String y = nf.getY() != null ? nf.getY().toString() : "0";
                    sb.append("        <networkFrame networkViewID=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\"/>\n");
                }
            }
            sb.append("    </networkFrames>\n");
            sb.append("    <cytopanels>\n");
            SessionState sessionState = this.cysession.getSessionState();
            if (sessionState != null && (cytopanels = sessionState.getCytopanels()) != null) {
                List<Cytopanel> cytopanelsList = cytopanels.getCytopanel();
                for (Cytopanel cytopanel : cytopanelsList) {
                    String id = cytopanel.getId();
                    String state = cytopanel.getPanelState();
                    String selection = cytopanel.getSelectedPanel();
                    sb.append("        <cytopanel id=\"" + id + "\">\n");
                    sb.append("            <panelState>" + state + "</panelState>\n");
                    sb.append("            <selectedPanel>" + selection + "</selectedPanel>\n");
                    sb.append("        </cytopanel>\n");
                }
            }
            sb.append("    </cytopanels>\n");
            sb.append("</sessionState>");
            ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            this.extractPluginEntry(bais, this.cysession.getId() + "/plugins/org.cytoscape.swing-application/session_state.xml");
        }
    }

    private void processNetworks() throws Exception {
        Desktop desktop;
        if (this.cysession == null) {
            return;
        }
        if (this.cysession.getNetworkTree() != null) {
            for (Network net : this.cysession.getNetworkTree().getNetwork()) {
                String name;
                Object netName;
                CyNetworkView view;
                if (this.cancelled) {
                    return;
                }
                if (net.getId().equals("Network Root") || (view = this.getNetworkView((String)(netName = net.getId()))) == null) continue;
                String vsName = net.getVisualStyle();
                if (vsName != null) {
                    this.visualStyleMap.put(view, vsName);
                }
                if (net.getHiddenEdges() != null) {
                    for (Edge edgeObject : net.getHiddenEdges().getEdge()) {
                        if (this.cancelled) {
                            return;
                        }
                        name = edgeObject.getId();
                        CyEdge e = this.cache.getEdge(name);
                        if (e != null) {
                            View ev = view.getEdgeView(e);
                            if (ev != null) {
                                ev.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
                                continue;
                            }
                            this.logger.error("Cannot restore hidden state of edge \"" + name + "\": Edge view not found.");
                            continue;
                        }
                        this.logger.error("Cannot restore hidden state of edge \"" + name + "\": Edge not found.");
                    }
                }
                if (net.getHiddenNodes() == null) continue;
                for (Node nodeObject : net.getHiddenNodes().getNode()) {
                    if (this.cancelled) {
                        return;
                    }
                    name = nodeObject.getId();
                    CyNode n = this.cache.getNodeByName(name);
                    if (n != null) {
                        View nv = view.getNodeView(n);
                        if (nv != null) {
                            nv.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)false);
                            continue;
                        }
                        this.logger.error("Cannot restore hidden state of node \"" + name + "\": Node view not found.");
                        continue;
                    }
                    this.logger.error("Cannot restore hidden state of node \"" + name + "\": Node not found.");
                }
            }
        }
        if (this.cysession.getSessionState() != null && (desktop = this.cysession.getSessionState().getDesktop()) != null && desktop.getNetworkFrames() != null) {
            List<NetworkFrame> frames = desktop.getNetworkFrames().getNetworkFrame();
            for (NetworkFrame nf : frames) {
                if (this.cancelled) {
                    return;
                }
                CyNetworkView view = this.getNetworkView(nf.getFrameID());
                if (view == null) continue;
                BigInteger w = nf.getWidth();
                BigInteger h = nf.getHeight();
                if (w != null) {
                    view.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)w.doubleValue());
                }
                if (h == null) continue;
                view.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)h.doubleValue());
            }
        }
        if (!this.networks.isEmpty()) {
            CyNetwork[] array = this.networks.toArray(new CyNetwork[this.networks.size()]);
            for (int i = array.length - 1; i >= 0; --i) {
                CyNetwork net = array[i];
                CyRow row = net.getRow((CyIdentifiable)net);
                String netName = (String)row.get("name", String.class);
                CyNetworkView view = this.networkViewLookup.get(netName);
                if (view == null) continue;
                row.set("selected", (Object)true);
                break;
            }
        }
    }

    private CyNetworkView getNetworkView(String name) {
        return this.networkViewLookup.get(name);
    }

    private void setBooleanNodeAttr(CyNetwork net, List<Node> nodes, String attrName, String tableName) {
        if (net != null && nodes != null) {
            for (Node nodeObject : nodes) {
                if (this.cancelled) {
                    return;
                }
                String name = nodeObject.getId();
                CyNode n = this.cache.getNodeByName(name);
                if (n != null) {
                    net.getRow((CyIdentifiable)n, tableName).set(attrName, (Object)true);
                    continue;
                }
                this.logger.error("Cannot restore boolean node attr \"" + name + "\": node not found.");
            }
        }
    }

    private void setBooleanEdgeAttr(CyNetwork net, List<Edge> edges, String attrName, String tableName) {
        if (net != null && edges != null) {
            for (Edge edgeObject : edges) {
                if (this.cancelled) {
                    return;
                }
                String name = edgeObject.getId();
                CyEdge e = this.cache.getEdge(name);
                if (e != null) {
                    net.getRow((CyIdentifiable)e, tableName).set(attrName, (Object)true);
                    continue;
                }
                this.logger.error("Cannot restore boolean edge attr \"" + name + "\": node not found.");
            }
        }
    }

    boolean isSessionProperty(String key) {
        return !key.matches(IGNORED_PROPS);
    }
}

