/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.cytoscape.group.CyGroup;
import org.cytoscape.io.internal.read.MarkSupportedInputStream;
import org.cytoscape.io.internal.read.ZipInputStreamWrapper;
import org.cytoscape.io.internal.util.GroupUtil;
import org.cytoscape.io.internal.util.ReadCache;
import org.cytoscape.io.read.CySessionReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.table.CyTableViewMetadata;
import org.cytoscape.view.vizmap.StyleAssociation;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionReader
extends AbstractTask
implements CySessionReader {
    public static final String CY2_PARENT_NETWORK_COLUMN = "Cy2 Parent Network.SUID";
    public static final String CY3_PARENT_NETWORK_COLUMN = "__parentNetwork.SUID";
    protected final Logger logger;
    protected InputStream sourceInputStream;
    protected final ReadCache cache;
    protected final GroupUtil groupUtil;
    protected final CyServiceRegistrar serviceRegistrar;
    protected DummyTaskMonitor taskMonitor;
    protected Set<CyProperty<?>> properties = new HashSet();
    protected final Set<CyNetwork> networks = new LinkedHashSet<CyNetwork>();
    protected final Set<CyNetworkView> networkViews = new LinkedHashSet<CyNetworkView>();
    protected final Set<CyTableViewMetadata> tableViews = new LinkedHashSet<CyTableViewMetadata>();
    protected final Set<VisualStyle> networkStyles = new HashSet<VisualStyle>();
    protected final Set<VisualStyle> tableStyles = new HashSet<VisualStyle>();
    protected final Set<StyleAssociation> columnStyleAssociations = new HashSet<StyleAssociation>();
    protected final Map<CyNetworkView, String> visualStyleMap = new WeakHashMap<CyNetworkView, String>();
    protected final Set<CyTableMetadata> tableMetadata = new HashSet<CyTableMetadata>();
    protected final Map<String, List<File>> appFileListMap = new HashMap<String, List<File>>();
    protected final Map<Class<? extends CyIdentifiable>, Map<Object, ? extends CyIdentifiable>> objectMap = new HashMap<Class<? extends CyIdentifiable>, Map<Object, ? extends CyIdentifiable>>();
    private boolean inputStreamRead;

    public AbstractSessionReader(InputStream sourceInputStream, ReadCache cache, GroupUtil groupUtil, CyServiceRegistrar serviceRegistrar) {
        assert (sourceInputStream != null);
        assert (cache != null);
        assert (groupUtil != null);
        assert (serviceRegistrar != null);
        this.sourceInputStream = new ReusableInputStream(sourceInputStream);
        this.cache = cache;
        this.groupUtil = groupUtil;
        this.serviceRegistrar = serviceRegistrar;
        this.logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    }

    public void run(TaskMonitor tm) throws Exception {
        try {
            this.init(tm);
            this.readSessionFile(tm);
            this.complete(tm);
        }
        finally {
            this.cleanUp(tm);
        }
    }

    public CySession getSession() {
        CySession sess = new CySession.Builder().networks(this.networks).networkViews(this.networkViews).viewVisualStyleMap(this.visualStyleMap).tableViews(this.tableViews).tableStyles(this.tableStyles).columnStyleAssociations(this.columnStyleAssociations).properties(this.properties).visualStyles(this.networkStyles).appFileListMap(this.appFileListMap).tables(this.tableMetadata).objectMap(this.objectMap).build();
        return sess;
    }

    protected void init(TaskMonitor tm) throws Exception {
        this.inputStreamRead = false;
        this.cache.setReadingSessionFile(true);
        this.cache.init();
        this.logger.debug("Reading CYS file...");
        this.taskMonitor = new DummyTaskMonitor();
        tm.setProgress(0.0);
        tm.setTitle("Read Session File");
        tm.setStatusMessage("Preparing...");
    }

    protected void complete(TaskMonitor tm) throws Exception {
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.9);
        tm.setTitle("Process network pointers");
        tm.setStatusMessage("Processing network pointers...");
        this.processNetworkPointers();
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.95);
        tm.setTitle("Finalize");
        tm.setStatusMessage("Finalizing...");
        this.createObjectMap();
        this.createGroups();
        tm.setProgress(1.0);
    }

    protected void cleanUp(TaskMonitor tm) {
        try {
            ((ReusableInputStream)this.sourceInputStream).reallyClose();
        }
        catch (Exception e) {
            this.logger.error("Error closing source input stream.", (Throwable)e);
        }
        if (this.cancelled) {
            Set<CyGroup> groups = this.groupUtil.getGroups(this.cache.getNetworks());
            this.groupUtil.destroyGroups(groups);
            for (CyNetworkView view : this.networkViews) {
                view.dispose();
            }
            CyRootNetworkManager rootNetworkManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
            HashSet<CyRootNetwork> rootNetworks = new HashSet<CyRootNetwork>();
            for (CyNetwork net : this.cache.getNetworks()) {
                net.dispose();
                rootNetworks.add(rootNetworkManager.getRootNetwork(net));
            }
            for (CyRootNetwork rootNet : rootNetworks) {
                rootNet.dispose();
            }
            this.networkViews.clear();
            this.networks.clear();
        }
        this.cache.dispose();
        this.cache.setReadingSessionFile(false);
    }

    protected void processNetworkPointers() {
        this.cache.createNetworkPointers();
    }

    protected void readSessionFile(TaskMonitor tm) throws Exception {
        if (!this.sourceInputStream.markSupported()) {
            throw new RuntimeException("Mark/Reset not supported.");
        }
        if (this.inputStreamRead) {
            this.sourceInputStream.reset();
        }
        this.sourceInputStream.mark(Integer.MAX_VALUE);
        this.inputStreamRead = true;
        boolean count = false;
        try (ZipInputStream zis = new ZipInputStream(this.sourceInputStream);){
            ZipEntry zen = null;
            while ((zen = zis.getNextEntry()) != null && !this.cancelled) {
                String entryName = zen.getName();
                try {
                    ZipInputStreamWrapper wrapper = new ZipInputStreamWrapper(zis);
                    this.handleEntry(wrapper, entryName);
                }
                catch (Exception e) {
                    this.logger.error("Failed reading session entry: " + entryName, (Throwable)e);
                }
            }
        }
    }

    abstract void handleEntry(InputStream var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected InputStream findEntry(String entry) throws IOException {
        MarkSupportedInputStream is = null;
        ZipInputStream zis = null;
        try {
            this.sourceInputStream.reset();
            zis = new ZipInputStream(this.sourceInputStream);
            ZipEntry zen = null;
            boolean found = false;
            while (!found && (zen = zis.getNextEntry()) != null) {
                String name = zen.getName();
                is = new MarkSupportedInputStream(zis);
                if (name.equals(entry)) {
                    found = true;
                }
                zis.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception ex) {
                    this.logger.error("Unable to close zip input stream.", (Throwable)ex);
                }
                zis = null;
            }
        }
        return is;
    }

    abstract void createObjectMap();

    protected void createGroups() {
        this.groupUtil.createGroups(this.networks, this.networkViews);
    }

    private class ReusableInputStream
    extends InputStream {
        private InputStream stream;

        public ReusableInputStream(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public void close() {
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public void reallyClose() throws IOException {
            this.stream.close();
        }
    }

    protected class DummyTaskMonitor
    implements TaskMonitor {
        protected DummyTaskMonitor() {
        }

        public void setTitle(String title) {
        }

        public void setProgress(double progress) {
        }

        public void setStatusMessage(String statusMessage) {
        }

        public void showMessage(TaskMonitor.Level level, String message, int wait) {
        }

        public void showMessage(TaskMonitor.Level level, String message) {
        }
    }
}

