/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.gml;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.read.gml.KeyValue;

public class GMLParser {
    static int QUOTE_CHAR = 34;
    static String QUOTE_STRING = "\"";
    static Pattern keyPattern = Pattern.compile("\\w+");
    static Pattern integerPattern = Pattern.compile("(\\+|\\-){0,1}\\d+");
    static Pattern realPattern = Pattern.compile("(\\+|\\-){0,1}\\d+\\.\\d+((E|e)(\\+|\\-){0,1}\\d+){0,1}");
    static String LIST_OPEN = "[";
    static String LIST_CLOSE = "]";
    StreamTokenizer tokenizer;

    public GMLParser(StreamTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public GMLParser(InputStream stream) throws IOException, Exception {
        this.tokenizer = GMLParser.createTokenizer(stream);
        this.tokenizer.nextToken();
    }

    static StreamTokenizer createTokenizer(InputStream stream) {
        StreamTokenizer tokenizer = new StreamTokenizer(new FilterNewlineReader(new InputStreamReader(stream, Charset.forName("UTF-8").newDecoder())));
        tokenizer.resetSyntax();
        tokenizer.commentChar(35);
        tokenizer.quoteChar(34);
        tokenizer.eolIsSignificant(false);
        tokenizer.wordChars(32, 33);
        tokenizer.wordChars(36, 126);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        return tokenizer;
    }

    public static void printList(List<KeyValue> list, Writer writer) throws IOException {
        GMLParser.printList(list, "", writer);
    }

    protected static void printList(List<KeyValue> list, String indent, Writer writer) throws IOException {
        for (KeyValue keyVal : list) {
            if (keyVal.value instanceof List) {
                writer.write(indent + keyVal.key + "\t");
                writer.write(LIST_OPEN + "\n");
                GMLParser.printList((List)keyVal.value, indent + "\t", writer);
                writer.write(indent + LIST_CLOSE + "\n");
                continue;
            }
            if (keyVal.value instanceof String) {
                writer.write(indent + keyVal.key + "\t");
                writer.write(QUOTE_STRING + keyVal.value + QUOTE_STRING + "\n");
                continue;
            }
            if (keyVal.value instanceof Double) {
                Double value = (Double)keyVal.value;
                if (value.isNaN() || value.isInfinite()) continue;
                writer.write(indent + keyVal.key + "\t");
                writer.write(keyVal.value + "\n");
                continue;
            }
            if (!(keyVal.value instanceof Integer)) continue;
            writer.write(indent + keyVal.key + "\t");
            writer.write(keyVal.value + "\n");
        }
    }

    public Vector<KeyValue> parseList() throws IOException, ParseException {
        Vector<KeyValue> result = new Vector<KeyValue>();
        while (this.isKey()) {
            String key = this.parseKey();
            if (key == null) {
                throw new ParseException("Bad key", this.tokenizer.lineno());
            }
            this.tokenizer.nextToken();
            Object value = this.parseValue();
            if (value == null) {
                throw new ParseException("Bad value associated with key " + key, this.tokenizer.lineno());
            }
            result.add(new KeyValue(key, value));
            this.tokenizer.nextToken();
        }
        return result;
    }

    private boolean isKey() {
        if (this.tokenizer.ttype != -3) {
            return false;
        }
        return keyPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isInteger() {
        return integerPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isReal() {
        return realPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isString() {
        return this.tokenizer.ttype == QUOTE_CHAR;
    }

    private boolean isList() {
        return this.tokenizer.sval.equals(LIST_OPEN);
    }

    private String parseKey() {
        if (this.isKey()) {
            return this.tokenizer.sval;
        }
        return null;
    }

    private Object parseValue() throws IOException, ParseException {
        Object result = null;
        if (this.tokenizer.ttype == 10) {
            return result;
        }
        if (this.isString()) {
            return this.tokenizer.sval;
        }
        if (this.isInteger()) {
            return Integer.valueOf(this.tokenizer.sval);
        }
        if (this.isReal()) {
            return new Double(this.tokenizer.sval);
        }
        if (this.isList()) {
            this.tokenizer.nextToken();
            Vector<KeyValue> list = this.parseList();
            if (!this.tokenizer.sval.equals(LIST_CLOSE)) {
                throw new ParseException("Unterminated list", this.tokenizer.lineno());
            }
            return list;
        }
        return result;
    }

    private static class FilterNewlineReader
    extends FilterReader {
        boolean inComment = false;
        boolean inQuote = false;
        int inListOpen = 0;
        int inListClose = 0;

        public FilterNewlineReader(Reader r) {
            super(r);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.inListOpen == 1) {
                this.inListOpen = 2;
                return 91;
            }
            if (this.inListClose == 1) {
                this.inListClose = 2;
                return 93;
            }
            if (this.inListOpen == 2) {
                this.inListOpen = 0;
                return 32;
            }
            if (this.inListClose == 2) {
                this.inListClose = 0;
                return 32;
            }
            int c = super.read();
            if (c == 91 && !this.inQuote && !this.inComment) {
                this.inListOpen = 1;
                return 32;
            }
            if (c == 93 && !this.inQuote && !this.inComment) {
                this.inListClose = 1;
                return 32;
            }
            if (c == 10 || c == 13) {
                if (!this.inComment) return 32;
                this.inComment = false;
                return c;
            } else if (c == 35 && !this.inQuote) {
                this.inComment = true;
                return c;
            } else {
                if (c != 34 || this.inComment) return c;
                this.inQuote = !this.inQuote;
            }
            return c;
        }
    }
}

