/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.gml;

import java.io.InputStream;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.read.gml.GMLParser;
import org.cytoscape.io.internal.read.gml.KeyValue;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLNetworkReader
extends AbstractCyNetworkReader {
    private static String TITLE = "Title";
    private static String GRAPH = "graph";
    private static String NODE = "node";
    private static String EDGE = "edge";
    private static String GRAPHICS = "graphics";
    private static String LABEL = "label";
    private static String SOURCE = "source";
    private static String TARGET = "target";
    private static String IS_DIRECTED = "directed";
    private static String ID = "id";
    private static String ROOT_INDEX = "root_index";
    private static String LINE = "Line";
    private static String FILL = "fill";
    private static String WIDTH = "width";
    private static String SOURCE_ARROW = "source_arrow";
    private static String TARGET_ARROW = "target_arrow";
    private static final String YED_ARROW = "arrow";
    private static final String YED_SOURCE_ARROW = "sourceArrow";
    private static final String YED_TARGET_ARROW = "targetArrow";
    private static String ARROW = "arrow";
    private static String ARROW_NONE = "none";
    private static String ARROW_FIRST = "first";
    private static String ARROW_LAST = "last";
    private static String OUTLINE_WIDTH = "outline_width";
    private static String DEFAULT_EDGE_INTERACTION = "interacts with";
    private static final String VIZMAP_PREFIX = "vizmap:";
    private static Map<String, ArrowShape> legacyArrowShapes = new HashMap<String, ArrowShape>();
    private static Map<String, ArrowShape> yedArrowShapes = new HashMap<String, ArrowShape>();
    private List<KeyValue> keyVals;
    private Map<Integer, CyNode> nodeIDMap;
    private List<Integer> nodes;
    private List<Integer> sources;
    private List<Integer> targets;
    private List<Boolean> directionalityFlags;
    private Vector<String> nodeLabels;
    private Vector<String> edgeLabels;
    private Vector<KeyValue> edgeRootIndexPairs;
    private Vector<KeyValue> nodeRootIndexPairs;
    private Vector<CyEdge> edgeNames;
    private Vector<String> nodeNames;
    private List<Map<String, Object>> nodeAttributes;
    private List<Map<String, Object>> edgeAttributes;
    private boolean graphDirected = true;
    private final UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr;
    private final CyServiceRegistrar serviceRegistrar;
    private CyNetworkView view;
    private CySubNetwork network;
    private VisualLexicon visualLexicon;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GMLNetworkReader(InputStream inputStream, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, CyServiceRegistrar serviceRegistrar) {
        super(inputStream, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class), (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class), (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class));
        this.unrecognizedVisualPropertyMgr = unrecognizedVisualPropertyMgr;
        this.serviceRegistrar = serviceRegistrar;
        this.edgeNames = new Vector();
        this.nodeNames = new Vector();
        this.nodeAttributes = new ArrayList<Map<String, Object>>();
        this.edgeAttributes = new ArrayList<Map<String, Object>>();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        try {
            this.keyVals = new GMLParser(this.inputStream).parseList();
        }
        catch (Exception io) {
            io.printStackTrace();
            throw new RuntimeException(io.getMessage());
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (Exception e) {
                    logger.warn("Cannot close GML input stream", (Throwable)e);
                }
            }
        }
        taskMonitor.setProgress(0.05);
        this.initializeStructures();
        taskMonitor.setProgress(0.1);
        this.readGML(this.keyVals, taskMonitor);
        taskMonitor.setProgress(0.3);
        CyRootNetwork rootNetwork = this.getRootNetwork();
        this.network = rootNetwork != null ? rootNetwork.addSubNetwork() : (CySubNetwork)this.cyNetworkFactory.createNetwork();
        this.createGraph(taskMonitor);
        taskMonitor.setProgress(0.8);
        this.networks = new CyNetwork[]{this.network};
        taskMonitor.setProgress(1.0);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        this.view = this.getNetworkViewFactory().createNetworkView(network);
        this.releaseStructures();
        this.layout(this.view);
        return this.view;
    }

    public void cancel() {
    }

    protected void initializeStructures() {
        this.nodes = new ArrayList<Integer>();
        this.sources = new ArrayList<Integer>();
        this.targets = new ArrayList<Integer>();
        this.directionalityFlags = new ArrayList<Boolean>();
        this.nodeLabels = new Vector();
        this.edgeLabels = new Vector();
        this.edgeRootIndexPairs = new Vector();
        this.nodeRootIndexPairs = new Vector();
    }

    protected void releaseStructures() {
        this.nodes = null;
        this.sources = null;
        this.targets = null;
        this.directionalityFlags = null;
        this.nodeLabels = null;
        this.edgeLabels = null;
        this.edgeRootIndexPairs = null;
        this.nodeRootIndexPairs = null;
    }

    protected void createGraph(TaskMonitor taskMonitor) {
        this.nodeIDMap = new HashMap<Integer, CyNode>(this.nodes.size());
        Map nMap = this.getNodeMap();
        HashMap<Integer, Integer> gml_id2order = new HashMap<Integer, Integer>(this.nodes.size());
        HashSet<String> nodeNameSet = new HashSet<String>(this.nodes.size());
        if (this.network.getDefaultNodeTable().getColumn(LABEL) == null) {
            this.network.getDefaultNodeTable().createColumn(LABEL, String.class, false);
        }
        for (int idx = 0; idx < this.nodes.size(); ++idx) {
            CyNode node;
            if (taskMonitor != null) {
                // empty if block
            }
            String label = this.nodeLabels.get(idx);
            nodeNameSet.add(label);
            if (nMap.get(label) != null) {
                node = (CyNode)nMap.get(label);
                if (!this.network.containsNode(node)) {
                    this.network.addNode(node);
                }
            } else {
                node = this.network.addNode();
            }
            CyRow row = this.network.getRow((CyIdentifiable)node);
            row.set("name", (Object)label);
            row.set(LABEL, (Object)label);
            this.setAttributes((CyIdentifiable)node, (CyNetwork)this.network, this.nodeAttributes.get(idx));
            this.nodeIDMap.put(this.nodes.get(idx), node);
            gml_id2order.put(this.nodes.get(idx), idx);
            this.nodeRootIndexPairs.get((int)idx).value = node.getSUID();
        }
        nodeNameSet = null;
        HashSet<CallSite> edgeNameSet = new HashSet<CallSite>(this.sources.size());
        for (int idx = 0; idx < this.sources.size(); ++idx) {
            Boolean isDirected;
            String edgeName;
            String label;
            if (taskMonitor != null) {
                // empty if block
            }
            Integer sourceNode = (Integer)gml_id2order.get(this.sources.get(idx));
            Integer targetNode = (Integer)gml_id2order.get(this.targets.get(idx));
            if (sourceNode != null && targetNode != null) {
                label = this.edgeLabels.get(idx);
                String sourceName = this.nodeLabels.get(sourceNode);
                String targetName = this.nodeLabels.get(targetNode);
                edgeName = sourceName + " (" + label + ") " + targetName;
                isDirected = this.directionalityFlags.get(idx);
                int duplicateCount = 1;
                while (!edgeNameSet.add((CallSite)((Object)edgeName))) {
                    edgeName = sourceName + " (" + label + ") " + targetName + "_" + duplicateCount;
                    ++duplicateCount;
                }
            } else {
                throw new RuntimeException("Non-existant source/target node for edge with gml (source,target): " + this.sources.get(idx) + "," + this.targets.get(idx));
            }
            CyNode node1 = this.nodeIDMap.get(this.sources.get(idx));
            CyNode node2 = this.nodeIDMap.get(this.targets.get(idx));
            CyEdge edge = this.network.addEdge(node1, node2, isDirected.booleanValue());
            this.network.getRow((CyIdentifiable)edge).set("name", (Object)edgeName);
            this.network.getRow((CyIdentifiable)edge).set("interaction", (Object)label);
            this.setAttributes((CyIdentifiable)edge, (CyNetwork)this.network, this.edgeAttributes.get(idx));
            this.edgeNames.add(idx, edge);
            this.edgeRootIndexPairs.get((int)idx).value = edge.getSUID();
        }
        edgeNameSet = null;
    }

    protected void readGML(List<KeyValue> list, TaskMonitor taskMonitor) {
        int counter = 0;
        for (KeyValue keyVal : list) {
            if (taskMonitor != null) {
                ++counter;
            }
            if (!keyVal.key.equals(GRAPH)) continue;
            this.readGraph((List)keyVal.value);
        }
    }

    protected void readGraph(List<KeyValue> list) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.readNode((List)keyVal.value);
                continue;
            }
            if (keyVal.key.equals(EDGE)) {
                this.readEdge((List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(IS_DIRECTED)) continue;
            this.graphDirected = (Integer)keyVal.value == 1;
        }
    }

    protected void readNode(List<KeyValue> list) {
        String label = "";
        boolean containsId = false;
        int id = 0;
        KeyValue rootIndexPair = null;
        HashMap<String, Object> attr = new HashMap<String, Object>();
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ID)) {
                containsId = true;
                id = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(ROOT_INDEX)) {
                rootIndexPair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS) || keyVal.key.startsWith(VIZMAP_PREFIX)) continue;
            attr.put(keyVal.key, keyVal.value);
        }
        if (label.equals("") || label.matches("\\s+")) {
            label = String.valueOf(id);
        }
        if (rootIndexPair == null) {
            rootIndexPair = new KeyValue(ROOT_INDEX, null);
            list.add(rootIndexPair);
        }
        if (!containsId) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new RuntimeException("The node-associated list\n" + stringWriter + "is missing an id field");
        }
        this.nodeRootIndexPairs.add(rootIndexPair);
        this.nodes.add(id);
        this.nodeLabels.add(label);
        this.nodeNames.add(label);
        this.nodeAttributes.add(attr);
    }

    protected void readEdge(List<KeyValue> list) {
        String label = DEFAULT_EDGE_INTERACTION;
        boolean containsSource = false;
        boolean containsTarget = false;
        boolean isDirected = this.graphDirected;
        int source = 0;
        int target = 0;
        KeyValue rootIndexPair = null;
        HashMap<String, Object> attr = new HashMap<String, Object>();
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(SOURCE)) {
                containsSource = true;
                source = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(TARGET)) {
                containsTarget = true;
                target = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(ROOT_INDEX)) {
                rootIndexPair = keyVal;
                continue;
            }
            if (keyVal.key.equals(IS_DIRECTED)) {
                if (keyVal.value instanceof Integer) {
                    isDirected = (Integer)keyVal.value == 1;
                    continue;
                }
                if (keyVal.value instanceof String) {
                    String v = (String)keyVal.value;
                    isDirected = v.equalsIgnoreCase("y") || v.equalsIgnoreCase("yes") || v.equalsIgnoreCase("true") || v.equals("1");
                    continue;
                }
                isDirected = false;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS) || keyVal.key.startsWith(VIZMAP_PREFIX)) continue;
            attr.put(keyVal.key, keyVal.value);
        }
        if (rootIndexPair == null) {
            rootIndexPair = new KeyValue(ROOT_INDEX, null);
            list.add(rootIndexPair);
        }
        if (!containsSource || !containsTarget) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new RuntimeException("The edge-associated list\n" + stringWriter + " is missing a source or target key");
        }
        this.sources.add(source);
        this.targets.add(target);
        this.directionalityFlags.add(isDirected);
        this.edgeLabels.add(label);
        this.edgeRootIndexPairs.add(rootIndexPair);
        this.edgeAttributes.add(attr);
    }

    public void layout(CyNetworkView view) {
        if (view == null || this.network.getNodeCount() == 0) {
            return;
        }
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (keyVal.key.equals(GRAPH)) {
                this.layoutGraph(view, (List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(TITLE) || keyVal.value == null) continue;
            CyRow netRow = ((CyNetwork)view.getModel()).getRow((CyIdentifiable)view.getModel());
            String title = keyVal.value.toString();
            netRow.set("name", (Object)title);
            view.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, (Object)title);
        }
    }

    private void setAttributes(CyIdentifiable obj, CyNetwork network, Map<String, Object> attrMap) {
        for (String name : attrMap.keySet()) {
            Object val = attrMap.get(name);
            if (val == null) continue;
            Class type = val instanceof Double ? Double.class : (val instanceof Integer ? Integer.class : String.class);
            CyRow row = network.getRow(obj);
            CyTable table = row.getTable();
            CyColumn column = table.getColumn(name);
            if (column == null) {
                table.createColumn(name, type, false);
            }
            try {
                if (type == Double.class) {
                    row.set(name, (Object)((Double)val));
                    continue;
                }
                if (type == Integer.class) {
                    row.set(name, (Object)((Integer)val));
                    continue;
                }
                row.set(name, (Object)val.toString());
            }
            catch (Exception e) {
                logger.error("Cannot set value \"" + val + "\" (" + type + ") to column \"" + name + "\" of table \"" + table + "\".", (Throwable)e);
            }
        }
    }

    private void layoutGraph(CyNetworkView myView, List<KeyValue> list) {
        CyEdge edge = null;
        int ePtr = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.layoutNode(myView, (List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(EDGE)) continue;
            edge = this.edgeNames.get(ePtr);
            ++ePtr;
            this.layoutEdge(myView, (List)keyVal.value, edge);
        }
    }

    private void layoutNode(CyNetworkView netView, List<KeyValue> list) {
        Long rootIndex = null;
        ArrayList<KeyValue> graphicsList = new ArrayList<KeyValue>();
        String label = null;
        int tempid = 0;
        for (KeyValue keyVal : list) {
            String key = keyVal.key;
            Object value = keyVal.value;
            if (key.equals(ROOT_INDEX)) {
                if (value == null) {
                    return;
                }
                rootIndex = (Long)value;
                continue;
            }
            if (key.equals(GRAPHICS)) {
                graphicsList.addAll((List)value);
                continue;
            }
            if (key.equals(LABEL)) {
                label = (String)value;
                graphicsList.add(new KeyValue("nodeLabel", label));
                continue;
            }
            if (!key.equals(ID)) continue;
            tempid = (Integer)value;
        }
        View nodeView = netView.getNodeView(this.network.getNode(rootIndex.longValue()));
        if (nodeView != null && !graphicsList.isEmpty()) {
            this.layoutGraphics(netView, graphicsList, (View<? extends CyIdentifiable>)nodeView);
        }
    }

    private void layoutEdge(CyNetworkView myView, List<KeyValue> list, CyEdge edge) {
        View edgeView = null;
        List graphicsList = null;
        for (KeyValue keyVal : list) {
            String key = keyVal.key;
            Object value = keyVal.value;
            if (key.equals(ROOT_INDEX)) {
                if (value == null) {
                    return;
                }
                edgeView = myView.getEdgeView(this.network.getEdge(((Long)keyVal.value).longValue()));
                continue;
            }
            if (!key.equals(GRAPHICS)) continue;
            graphicsList = (List)value;
        }
        if (edgeView != null && graphicsList != null) {
            this.layoutGraphics(myView, graphicsList, edgeView);
        }
    }

    private void layoutGraphics(CyNetworkView netView, List<KeyValue> list, View<? extends CyIdentifiable> view) {
        CyIdentifiable model = (CyIdentifiable)view.getModel();
        Class<CyNetwork> type = CyNetwork.class;
        if (model instanceof CyNode) {
            type = CyNode.class;
        } else if (model instanceof CyEdge) {
            type = CyEdge.class;
        }
        boolean srcArrowParsed = false;
        boolean tgtArrowParsed = false;
        for (KeyValue keyVal : list) {
            Set<VisualProperty<?>> vpSet;
            String key = keyVal.key;
            Object value = keyVal.value;
            Object vpValue = null;
            if (type == CyNode.class) {
                if (key.equals(OUTLINE_WIDTH)) {
                    key = WIDTH;
                }
            } else if (type == CyEdge.class) {
                if (key.equals(LINE)) {
                    this.layoutEdgeGraphicsLine(netView, (List)value, view);
                    continue;
                }
                if (key.equals(YED_ARROW) && !srcArrowParsed && !tgtArrowParsed) {
                    if (value.toString().equals(ARROW_NONE)) continue;
                    if (value.toString().equals(ARROW_FIRST)) {
                        key = YED_SOURCE_ARROW;
                    } else if (value.toString().equals(ARROW_LAST)) {
                        key = YED_TARGET_ARROW;
                    }
                    vpValue = ArrowShapeVisualProperty.ARROW;
                } else {
                    if (key.equals(YED_SOURCE_ARROW) || key.equals(YED_TARGET_ARROW)) {
                        vpValue = yedArrowShapes.get(value.toString());
                    } else if (key.equals(SOURCE_ARROW) || key.equals(TARGET_ARROW)) {
                        key = key.replace("_arrow", "Arrow");
                        vpValue = legacyArrowShapes.get(value.toString());
                    }
                    if (key.equals(YED_SOURCE_ARROW)) {
                        srcArrowParsed = true;
                    }
                    if (key.equals(YED_TARGET_ARROW)) {
                        tgtArrowParsed = true;
                    }
                }
            }
            if ((vpSet = this.getVisualProperties(type, key)).isEmpty()) {
                this.unrecognizedVisualPropertyMgr.addUnrecognizedVisualProperty(netView, view, key, value.toString());
                continue;
            }
            for (VisualProperty<?> vp : vpSet) {
                if (vpValue == null) {
                    vpValue = vp.parseSerializableString(value.toString());
                }
                if (vpValue == null) continue;
                if (this.isLockedVisualProperty(model, key)) {
                    if (vp == BasicVisualLexicon.NODE_LABEL) continue;
                    view.setLockedValue(vp, vpValue);
                    continue;
                }
                view.setVisualProperty(vp, vpValue);
            }
        }
    }

    private Set<VisualProperty<?>> getVisualProperties(Class<? extends CyIdentifiable> type, String key) {
        LinkedHashSet set = new LinkedHashSet();
        if (type == CyEdge.class && key.equals(FILL)) {
            set.add(BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
            set.add(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        } else if (type == CyEdge.class && key.equals(ARROW)) {
            set.add(BasicVisualLexicon.EDGE_SOURCE_ARROW_SHAPE);
            set.add(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE);
        } else {
            VisualProperty vp = this.getVisualLexicon().lookup(type, key);
            if (vp != null) {
                set.add(vp);
            }
        }
        return set;
    }

    private void layoutEdgeGraphicsLine(CyNetworkView myView, List<KeyValue> list, View<CyEdge> edgeView) {
    }

    private VisualLexicon getVisualLexicon() {
        if (this.visualLexicon == null) {
            this.visualLexicon = ((RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getDefaultVisualLexicon();
        }
        return this.visualLexicon;
    }

    protected boolean isLockedVisualProperty(CyIdentifiable element, String attName) {
        boolean b = !(element instanceof CyNode) || !attName.matches("x|y|z");
        return b;
    }

    static {
        legacyArrowShapes.put("0", ArrowShapeVisualProperty.NONE);
        legacyArrowShapes.put("1", ArrowShapeVisualProperty.DELTA);
        legacyArrowShapes.put("2", ArrowShapeVisualProperty.DELTA);
        legacyArrowShapes.put("3", ArrowShapeVisualProperty.DELTA);
        legacyArrowShapes.put("4", ArrowShapeVisualProperty.ARROW);
        legacyArrowShapes.put("5", ArrowShapeVisualProperty.ARROW);
        legacyArrowShapes.put("6", ArrowShapeVisualProperty.ARROW);
        legacyArrowShapes.put("7", ArrowShapeVisualProperty.DIAMOND);
        legacyArrowShapes.put("8", ArrowShapeVisualProperty.DIAMOND);
        legacyArrowShapes.put("9", ArrowShapeVisualProperty.DIAMOND);
        legacyArrowShapes.put("10", ArrowShapeVisualProperty.CIRCLE);
        legacyArrowShapes.put("11", ArrowShapeVisualProperty.CIRCLE);
        legacyArrowShapes.put("12", ArrowShapeVisualProperty.CIRCLE);
        legacyArrowShapes.put("13", ArrowShapeVisualProperty.T);
        legacyArrowShapes.put("14", ArrowShapeVisualProperty.T);
        legacyArrowShapes.put("15", ArrowShapeVisualProperty.T);
        legacyArrowShapes.put("16", ArrowShapeVisualProperty.HALF_TOP);
        legacyArrowShapes.put("17", ArrowShapeVisualProperty.HALF_BOTTOM);
        yedArrowShapes.put("none", ArrowShapeVisualProperty.NONE);
        yedArrowShapes.put("delta", ArrowShapeVisualProperty.DELTA);
        yedArrowShapes.put("white_delta", ArrowShapeVisualProperty.DELTA);
        yedArrowShapes.put("diamond", ArrowShapeVisualProperty.DIAMOND);
        yedArrowShapes.put("white_diamond", ArrowShapeVisualProperty.DIAMOND);
        yedArrowShapes.put("short", ArrowShapeVisualProperty.ARROW);
        yedArrowShapes.put("standard", ArrowShapeVisualProperty.ARROW);
    }
}

