/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.expression;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cytoscape.io.internal.read.AbstractTableReader;
import org.cytoscape.io.internal.read.expression.mRNAMeasurement;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskMonitor;

public class ExpressionReader
extends AbstractTableReader {
    public static final int MAX_LINE_SIZE = 8192;
    public static final int PVAL = 0;
    public static final int LAMBDA = 1;
    public static final int NONE = 2;
    public static final int UNKNOWN = 3;
    protected int significanceType = 3;
    int numGenes = 0;
    int numConds = 0;
    int extraTokens = 0;
    boolean haveSigValues = false;
    Vector<String> geneNames;
    Vector<String> geneDescripts;
    Vector<String> condNames;
    Map<String, Integer> geneNameToIndex;
    Map<String, Integer> condNameToIndex;
    double minExp;
    double maxExp;
    double minSig;
    double maxSig;
    Vector<Vector<mRNAMeasurement>> allMeasurements;
    private boolean isCancelled = false;
    private CyTable table = null;

    public ExpressionReader(InputStream stream, CyServiceRegistrar serviceRegistrar) {
        super(stream, serviceRegistrar);
        this.initDataStructures();
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private void initDataStructures() {
        int expand = 1000;
        if (this.geneNames != null) {
            this.geneNames.clear();
        }
        this.geneNames = new Vector(0, expand);
        if (this.geneDescripts != null) {
            this.geneDescripts.clear();
        }
        this.geneDescripts = new Vector(0, expand);
        if (this.condNames != null) {
            this.condNames.clear();
        }
        this.condNames = new Vector();
        if (this.geneNameToIndex != null) {
            this.geneNameToIndex.clear();
        }
        this.geneNameToIndex = new HashMap<String, Integer>();
        if (this.condNameToIndex != null) {
            this.condNameToIndex.clear();
        }
        this.condNameToIndex = new HashMap<String, Integer>();
        this.minExp = Double.MAX_VALUE;
        this.maxExp = Double.MIN_VALUE;
        this.minSig = Double.MAX_VALUE;
        this.maxSig = Double.MIN_VALUE;
        if (this.allMeasurements != null) {
            this.allMeasurements.clear();
        }
        this.allMeasurements = new Vector(0, expand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8").newDecoder()));){
            int i;
            int numberOfConditions;
            String line;
            int lineCount = 0;
            while ((line = input.readLine()) != null && line.startsWith("#")) {
                ++lineCount;
            }
            String headerLine = line;
            ++lineCount;
            if (headerLine == null || headerLine.length() == 0) {
                taskMonitor.setStatusMessage("Missing header in input file.");
                return;
            }
            taskMonitor.setProgress(0.1);
            if (this.isHeaderLineMTXHeader(headerLine)) {
                this.significanceType = 1;
                headerLine = input.readLine();
                ++lineCount;
                if (headerLine == null) {
                    taskMonitor.setStatusMessage("Missing header in input file.");
                    return;
                }
            }
            boolean hasCOMMON = this.doesHeaderLineHasCOMMON(headerLine);
            boolean expectPvals = this.doesHeaderLineHaveDuplicates(headerLine, hasCOMMON);
            taskMonitor.setProgress(0.2);
            if (this.significanceType != 1 && !expectPvals) {
                this.significanceType = 2;
            }
            StringTokenizer headerTok = new StringTokenizer(headerLine);
            int numTokens = headerTok.countTokens();
            int minTokens = 2;
            if (hasCOMMON) {
                minTokens = 3;
            }
            if (numTokens < minTokens || numTokens < minTokens + 1 && expectPvals) {
                StringBuffer msg = new StringBuffer("Invalid header format in data file.");
                msg.append("\nNumber of tokens parsed: " + numTokens);
                for (int i2 = 0; i2 < numTokens; ++i2) {
                    msg.append("\nToken " + i2 + ": " + headerTok.nextToken());
                }
                throw new IOException(msg.toString());
            }
            double tmpF = (double)numTokens / 2.0;
            int tmpI = (int)Math.rint(tmpF);
            int haveExtraTokens = 0;
            if (expectPvals) {
                if ((double)tmpI == tmpF) {
                    numberOfConditions = (numTokens - 2) / 2;
                    haveExtraTokens = 0;
                } else {
                    numberOfConditions = (numTokens - 3) / 2;
                    haveExtraTokens = 1;
                }
            } else {
                numberOfConditions = numTokens - 2;
            }
            if (!hasCOMMON) {
                if (expectPvals) {
                    if ((double)tmpI == tmpF) {
                        numberOfConditions = (numTokens - 2) / 2;
                        haveExtraTokens = 1;
                    } else {
                        numberOfConditions = (numTokens - 1) / 2;
                        haveExtraTokens = 0;
                    }
                } else {
                    numberOfConditions = numTokens - 1;
                }
            }
            headerTok.nextToken();
            if (hasCOMMON) {
                headerTok.nextToken();
            }
            Vector<String> cNames = new Vector<String>(numberOfConditions);
            for (i = 0; i < numberOfConditions; ++i) {
                cNames.add(headerTok.nextToken());
            }
            if (expectPvals) {
                for (i = 0; i < numberOfConditions; ++i) {
                    String title = headerTok.nextToken();
                    if (title.equals(cNames.get(i))) continue;
                    String msg = "Expecting both ratios and p-values.\nCondition name mismatch in header line of expression matrix data file :" + (String)cNames.get(i) + " vs. " + title;
                    throw new IOException(msg);
                }
            }
            taskMonitor.setProgress(0.25);
            this.numConds = numberOfConditions;
            this.extraTokens = haveExtraTokens;
            this.haveSigValues = expectPvals;
            this.initDataStructures();
            this.condNames = cNames;
            for (i = 0; i < this.numConds; ++i) {
                this.condNameToIndex.put(this.condNames.get(i), i);
            }
            if (taskMonitor != null) {
                taskMonitor.setStatusMessage("Reading in Data...");
            }
            boolean mappingByKeyAttribute = false;
            HashMap<String, List<String>> attributeToId = new HashMap<String, List<String>>();
            while ((line = input.readLine()) != null) {
                this.parseOneLine(line, ++lineCount, expectPvals, false, attributeToId, hasCOMMON);
                if (!this.isCancelled) continue;
                return;
            }
            taskMonitor.setProgress(0.9);
            this.numGenes = this.geneNames.size();
            for (int i3 = 0; i3 < this.geneNames.size(); ++i3) {
                if (this.geneNames.get(i3) == null) continue;
                this.geneNameToIndex.put(this.geneNames.get(i3), i3);
            }
            this.geneNames.trimToSize();
            this.geneDescripts.trimToSize();
            this.allMeasurements.trimToSize();
            this.copyToAttribs(taskMonitor);
        }
        taskMonitor.setProgress(1.0);
    }

    private Map<String, List<String>> getAttributeToIdList(CyNetwork network, String keyAttributeName) throws IOException {
        HashMap<String, List<String>> attributeToIdList = new HashMap<String, List<String>>();
        List allNodes = network.getNodeList();
        for (CyNode node : allNodes) {
            String attributeValue;
            String nodeName = (String)network.getRow((CyIdentifiable)node).get("name", String.class);
            Object attrValue = network.getRow((CyIdentifiable)node).getRaw(keyAttributeName);
            if (attrValue == null || (attributeValue = attrValue.toString()) == null) continue;
            ArrayList<String> genesThisAttribute = (ArrayList<String>)attributeToIdList.get(attributeValue);
            if (genesThisAttribute == null) {
                genesThisAttribute = new ArrayList<String>();
                genesThisAttribute.add(nodeName);
                attributeToIdList.put(attributeValue, genesThisAttribute);
            }
            genesThisAttribute.add(nodeName);
        }
        return attributeToIdList;
    }

    private boolean doesHeaderLineHasCOMMON(String hline) {
        StringTokenizer headerTok = new StringTokenizer(hline);
        if (headerTok.countTokens() < 2) {
            return false;
        }
        headerTok.nextToken();
        String secondColHeader = headerTok.nextToken();
        return secondColHeader.equalsIgnoreCase("COMMON") || secondColHeader.equalsIgnoreCase("DESCRIPT");
    }

    private boolean doesHeaderLineHaveDuplicates(String hline, boolean hasCOMMON) {
        boolean retval = false;
        StringTokenizer headerTok = new StringTokenizer(hline);
        int numTokens = headerTok.countTokens();
        int minTokens = 2;
        if (hasCOMMON) {
            minTokens = 3;
        }
        if (numTokens < minTokens) {
            retval = false;
        } else {
            headerTok.nextToken();
            if (hasCOMMON) {
                headerTok.nextToken();
            }
            HashMap<String, String> names = new HashMap<String, String>();
            while (!retval && headerTok.hasMoreTokens()) {
                String title = headerTok.nextToken();
                String titleObject = title;
                if (names.get(titleObject) == null) {
                    names.put(titleObject, titleObject);
                    continue;
                }
                retval = true;
            }
        }
        return retval;
    }

    private boolean isHeaderLineMTXHeader(String hline) {
        boolean b = false;
        String pattern = "\t+RATIOS\t+LAMBDAS";
        b = hline.matches(pattern);
        return b;
    }

    private void parseOneLine(String line, int lineCount, boolean sig_vals, boolean mappingByAttribute, Map<String, List<String>> attributeToId, boolean hasCOMMON) throws IOException {
        int numPreCols;
        StringTokenizer strtok = new StringTokenizer(line);
        int numTokens = strtok.countTokens();
        if (numTokens == 0) {
            return;
        }
        String firstToken = strtok.nextToken();
        if (firstToken.startsWith("NumSigGenes")) {
            return;
        }
        int n = numPreCols = hasCOMMON ? 2 : 1;
        if (sig_vals && numTokens < 2 * this.numConds + numPreCols || !sig_vals && numTokens < this.numConds + numPreCols) {
            throw new IOException("Warning: parse error on line " + lineCount + "  tokens read: " + numTokens);
        }
        String geneDescript = hasCOMMON ? strtok.nextToken() : "";
        String[] expData = new String[this.numConds];
        for (int i = 0; i < this.numConds; ++i) {
            expData[i] = strtok.nextToken();
        }
        String[] sigData = new String[this.numConds];
        if (sig_vals) {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = strtok.nextToken();
            }
        } else {
            for (i = 0; i < this.numConds; ++i) {
                sigData[i] = expData[i];
            }
        }
        List<Object> gNames = new ArrayList<String>();
        if (mappingByAttribute) {
            List<String> names = attributeToId.get(firstToken);
            if (names != null) {
                gNames = names;
            }
        } else {
            gNames = new ArrayList();
            gNames.add(firstToken);
        }
        for (int ii = 0; ii < gNames.size(); ++ii) {
            this.geneNames.add((String)gNames.get(ii));
            this.geneDescripts.add(geneDescript);
            Vector<mRNAMeasurement> measurements = new Vector<mRNAMeasurement>(this.numConds);
            for (int jj = 0; jj < this.numConds; ++jj) {
                mRNAMeasurement m = new mRNAMeasurement(expData[jj], sigData[jj]);
                measurements.add(m);
                double ratio = m.getRatio();
                double signif = m.getSignificance();
                if (ratio < this.minExp) {
                    this.minExp = ratio;
                }
                if (ratio > this.maxExp) {
                    this.maxExp = ratio;
                }
                if (signif < this.minSig) {
                    this.minSig = signif;
                }
                if (!(signif > this.maxSig)) continue;
                this.maxSig = signif;
                if (this.significanceType == 1 || !sig_vals || !(this.maxSig > 1.0)) continue;
                this.significanceType = 1;
            }
            if (this.significanceType != 1 && sig_vals && this.minSig > 0.0) {
                this.significanceType = 0;
            }
            this.allMeasurements.add(measurements);
        }
    }

    public void convertLambdasToPvals() {
        for (Vector<mRNAMeasurement> v : this.allMeasurements) {
            for (mRNAMeasurement m : v) {
                double pval = ExpressionReader.getPvalueFromLambda(m.getSignificance());
                m.setSignificance(pval);
            }
        }
    }

    public static double getPvalueFromLambda(double lambda) {
        double x = StrictMath.sqrt(lambda) / 2.0;
        double t = 1.0 / (1.0 + 0.3275911 * x);
        double erfc = StrictMath.exp(-(x * x)) * (0.254829592 * t + -0.284496736 * StrictMath.pow(t, 2.0) + 1.421413741 * StrictMath.pow(t, 3.0) + -1.453152027 * StrictMath.pow(t, 4.0) + 1.061405429 * StrictMath.pow(t, 5.0));
        if ((erfc /= 2.0) < 0.0 || erfc > 1.0) {
            throw new IllegalStateException("The calculated pvalue for lambda = " + lambda + " is " + erfc);
        }
        return erfc;
    }

    private String[] getConditionNames() {
        return this.condNames.toArray(new String[0]);
    }

    private Vector<mRNAMeasurement> getMeasurements(String gene) {
        if (gene == null) {
            return null;
        }
        Integer geneIndex = this.geneNameToIndex.get(gene);
        if (geneIndex == null) {
            return null;
        }
        return this.allMeasurements.get(geneIndex);
    }

    private mRNAMeasurement getMeasurement(String gene, String condition) {
        Integer condIndex = this.condNameToIndex.get(condition);
        if (condIndex == null) {
            return null;
        }
        Vector<mRNAMeasurement> measurements = this.getMeasurements(gene);
        if (measurements == null) {
            return null;
        }
        mRNAMeasurement returnVal = measurements.get(condIndex);
        return returnVal;
    }

    private void copyToAttribs(TaskMonitor taskMonitor) {
        String[] condNames = this.getConditionNames();
        CyTableFactory tableFactory = (CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class);
        this.table = tableFactory.createTable("Expression Matrix", "geneName", String.class, true, true);
        for (int condNum = 0; condNum < condNames.length; ++condNum) {
            String condName = condNames[condNum];
            String eStr = condName + "exp";
            String sStr = condName + "sig";
            this.table.createColumn(eStr, Double.class, false);
            this.table.createColumn(sStr, Double.class, false);
        }
        for (int i = 0; i < this.geneNames.size(); ++i) {
            String canName = this.geneNames.get(i);
            CyRow row = this.table.getRow((Object)canName);
            for (int condNum = 0; condNum < condNames.length; ++condNum) {
                String condName = condNames[condNum];
                String eStr = condName + "exp";
                String sStr = condName + "sig";
                mRNAMeasurement mm = this.getMeasurement(canName, condName);
                if (mm != null) {
                    row.set(eStr, (Object)new Double(mm.getRatio()));
                    row.set(sStr, (Object)new Double(mm.getSignificance()));
                }
                if (taskMonitor == null) continue;
                int currentCoordinate = condNum * this.geneNames.size() + i;
                int matrixSize = condNames.length * this.geneNames.size();
                double percent = (double)currentCoordinate / (double)matrixSize * 100.0;
                taskMonitor.setProgress(percent);
            }
        }
    }

    @Override
    public CyTable[] getTables() {
        if (this.table == null) {
            return null;
        }
        return new CyTable[]{this.table};
    }
}

