/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.datatable;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.io.internal.read.datatable.ColumnInfo;
import org.cytoscape.io.internal.read.datatable.TableInfo;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskMonitor;

public class CSVCyReader
implements CyTableReader {
    private static final Pattern classPattern = Pattern.compile("([^<>]+)(<(.*?)>)?");
    private final InputStream stream;
    private final boolean readSchema;
    private final boolean handleEquations;
    private final String encoding;
    private boolean isCanceled;
    private CyTable table;
    private final CyServiceRegistrar serviceRegistrar;

    public CSVCyReader(InputStream stream, boolean readSchema, boolean handleEquations, String encoding, CyServiceRegistrar serviceRegistrar) {
        this.stream = stream;
        this.readSchema = readSchema;
        this.handleEquations = handleEquations;
        this.encoding = encoding;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(this.stream, this.encoding), ',', '\"', '\u0000');
        taskMonitor.setProgress(0.2);
        TableInfo info = this.readHeader(reader);
        this.table = this.createTable(reader, info);
        taskMonitor.setProgress(1.0);
    }

    CyTable createTable(CSVReader reader, TableInfo info) throws IOException, SecurityException {
        ColumnInfo[] columns = info.getColumns();
        CyTableFactory tableFactory = (CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class);
        CyTable table = tableFactory.createTable(info.getTitle(), columns[0].getName(), columns[0].getType(), info.isPublic(), true);
        HashMap<String, Class> variableNameToTypeMap = new HashMap<String, Class>();
        for (ColumnInfo colInfo : columns) {
            variableNameToTypeMap.put(colInfo.getName(), colInfo.getType() == Integer.class ? Long.class : colInfo.getType());
        }
        for (int i = 1; i < columns.length; ++i) {
            ColumnInfo column = columns[i];
            Class<?> type = column.getType();
            if (type.equals(List.class)) {
                table.createListColumn(column.getName(), column.getListElementType(), !column.isMutable());
                continue;
            }
            table.createColumn(column.getName(), type, !column.isMutable());
        }
        EquationCompiler compiler = (EquationCompiler)this.serviceRegistrar.getService(EquationCompiler.class);
        String[] values = reader.readNext();
        while (values != null) {
            if (this.isCanceled) {
                return null;
            }
            Object key = this.parseValue(columns[0].getType(), null, values[0]);
            CyRow row = table.getRow(key);
            for (int i = 1; i < values.length; ++i) {
                ColumnInfo column = columns[i];
                String name = column.getName();
                Class<?> columnType = column.getType();
                Class<?> columnListElementType = column.getListElementType();
                if (this.handleEquations && values[i].startsWith("=")) {
                    Class expectedType = (Class)variableNameToTypeMap.remove(name);
                    try {
                        Equation equation;
                        if (compiler.compile(values[i], variableNameToTypeMap)) {
                            Class eqnType = compiler.getEquation().getType();
                            if (EquationUtil.eqnTypeIsCompatible(columnType, columnListElementType, (Class)eqnType)) {
                                equation = compiler.getEquation();
                            } else {
                                String errorMsg = "Equation result type is " + EquationUtil.getUnqualifiedName((Class)eqnType) + ", column type is " + EquationUtil.getUnqualifiedName(columnType) + ".";
                                equation = compiler.getErrorEquation(values[i], expectedType, errorMsg);
                            }
                        } else {
                            equation = compiler.getErrorEquation(values[i], expectedType, compiler.getLastErrorMsg());
                        }
                        row.set(name, (Object)equation);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage(), e.getCause());
                    }
                    variableNameToTypeMap.put(name, expectedType);
                    continue;
                }
                Object value = this.parseValue(columnType, columnListElementType, values[i]);
                if (value == null) continue;
                row.set(name, value);
            }
            values = reader.readNext();
        }
        return table;
    }

    Object parseValue(Class<?> type, Class<?> listElementType, String value) {
        if (type.equals(List.class)) {
            String[] values;
            ArrayList<Object> list = new ArrayList<Object>();
            for (String item : values = value.split("\n")) {
                list.add(this.parseValue(listElementType, null, item));
            }
            if (list.size() == 1 && list.get(0) == null) {
                return null;
            }
            return list;
        }
        if (type.equals(String.class)) {
            return value;
        }
        if (value.isEmpty()) {
            return null;
        }
        try {
            if (type.equals(Long.class)) {
                return Long.valueOf(value);
            }
            if (type.equals(Boolean.class)) {
                return Boolean.valueOf(value);
            }
            if (type.equals(Double.class)) {
                return Double.valueOf(value);
            }
            if (type.equals(Integer.class)) {
                return Integer.valueOf(value);
            }
            Method method = type.getMethod("valueOf", String.class);
            return method.invoke(null, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    TableInfo readHeader(CSVReader reader) throws IOException, ClassNotFoundException {
        int schemaVersion;
        String[] values = reader.readNext();
        if (values.length == 2 && "CyCSV-Version".equals(values[0])) {
            schemaVersion = Integer.parseInt(values[1]);
            values = reader.readNext();
        } else {
            schemaVersion = 0;
        }
        TableInfo table = new TableInfo();
        ColumnInfo[] columns = new ColumnInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            ColumnInfo column = new ColumnInfo();
            column.setName(values[i]);
            columns[i] = column;
        }
        table.setColumns(columns);
        if (!this.readSchema) {
            return table;
        }
        SchemaDelegate delegate = this.getSchemaDelegate(schemaVersion);
        delegate.readSchema(reader, table);
        return table;
    }

    private SchemaDelegate getSchemaDelegate(int schemaVersion) {
        switch (schemaVersion) {
            case 0: {
                return new SchemaDelegate0();
            }
            case 1: {
                return new SchemaDelegate1();
            }
        }
        throw new IllegalArgumentException("Unsupported CyCSV version: " + schemaVersion);
    }

    public CyTable[] getTables() {
        if (this.table == null) {
            return null;
        }
        return new CyTable[]{this.table};
    }

    static interface SchemaDelegate {
        public void readSchema(CSVReader var1, TableInfo var2) throws IOException, ClassNotFoundException;
    }

    static class SchemaDelegate0
    extends AbstractSchemaDelegate {
        SchemaDelegate0() {
        }

        @Override
        protected void handleColumnOptions(CSVReader reader, TableInfo table) throws IOException, ClassNotFoundException {
            ColumnInfo[] columns = table.getColumns();
            for (int i = 1; i < columns.length; ++i) {
                columns[i].setMutable(true);
            }
        }
    }

    static class SchemaDelegate1
    extends AbstractSchemaDelegate {
        SchemaDelegate1() {
        }
    }

    static class AbstractSchemaDelegate
    implements SchemaDelegate {
        AbstractSchemaDelegate() {
        }

        @Override
        public void readSchema(CSVReader reader, TableInfo table) throws IOException, ClassNotFoundException {
            this.handleColumnTypes(reader, table);
            this.handleColumnOptions(reader, table);
            this.handleTableOptions(reader, table);
        }

        protected void handleTableOptions(CSVReader reader, TableInfo table) throws IOException {
            String[] values = reader.readNext();
            table.setTitle(values[0]);
            for (String option : values[1].split(",")) {
                if ("public".equals(option)) {
                    table.setPublic(true);
                    continue;
                }
                if (!"mutable".equals(option)) continue;
                table.setMutable(true);
            }
        }

        protected void handleColumnOptions(CSVReader reader, TableInfo table) throws IOException, ClassNotFoundException {
            ColumnInfo[] columns = table.getColumns();
            String[] values = reader.readNext();
            for (int i = 0; i < values.length; ++i) {
                for (String option : values[i].split(",")) {
                    if (!"mutable".equals(option)) continue;
                    columns[i].setMutable(true);
                }
            }
        }

        protected void handleColumnTypes(CSVReader reader, TableInfo table) throws IOException, ClassNotFoundException {
            ColumnInfo[] columns = table.getColumns();
            String[] values = reader.readNext();
            for (int i = 0; i < values.length; ++i) {
                Matcher matcher = classPattern.matcher(values[i]);
                matcher.matches();
                String typeName = matcher.group(1);
                Class<?> type = Class.forName(typeName);
                if (type.equals(List.class)) {
                    String elementName = matcher.group(3);
                    Class<?> elementType = Class.forName(elementName);
                    columns[i].setListElementType(elementType);
                    continue;
                }
                columns[i].setType(type);
            }
        }
    }
}

