/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.event.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.internal.ServiceComparator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final ServiceComparator serviceComparator = new ServiceComparator();
    private static final Object DUMMY = new Object();
    private final Map<Class<?>, ServiceTracker> serviceTrackers;
    private final BundleContext bc;
    private final Map<Object, Object> silencedSources;
    private final StringBuilder traceString;
    private final boolean printEventTrace;
    private int fireCount;
    private final Object lock = new Object();

    public CyListenerAdapter(BundleContext bc) {
        this.bc = bc;
        this.serviceTrackers = new ConcurrentHashMap(16, 0.75f, 2);
        this.silencedSources = new WeakHashMap<Object, Object>();
        this.fireCount = 0;
        this.traceString = new StringBuilder();
        this.printEventTrace = Boolean.parseBoolean(System.getProperty("printEventTrace", "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends CyEvent<?>> void fireEvent(E event) {
        if (event == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.silencedSources.containsKey(event.getSource())) {
                return;
            }
        }
        Class listenerClass = event.getListenerClass();
        Object[] listeners = this.getListeners(listenerClass);
        if (listeners == null) {
            return;
        }
        Object lastListener = null;
        long begin = 0L;
        if (this.printEventTrace) {
            ++this.fireCount;
            this.printTrace(this.fireCount, "EVENT START: " + event.getClass().getName());
        }
        try {
            Method method = listenerClass.getMethod("handleEvent", event.getClass());
            for (Object listener : listeners) {
                try {
                    lastListener = listener;
                    if (this.printEventTrace) {
                        this.printTrace(this.fireCount, "listener: " + listener.getClass().getName());
                        begin = System.currentTimeMillis();
                    }
                    method.invoke(listenerClass.cast(listener), event);
                    if (!this.printEventTrace) continue;
                    long end = System.currentTimeMillis();
                    this.printTrace(this.fireCount, "listener: " + listener.getClass().getName() + " duration: " + (end - begin));
                }
                catch (Exception e) {
                    logger.error("Unexpected exception while handling listener: " + listenerClass.getName(), (Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("Listener doesn't implement \"handleEvent\" method: " + listenerClass.getName(), (Throwable)e);
        }
        if (this.printEventTrace) {
            this.printTrace(this.fireCount, "EVENT END  : " + event.getClass().getName());
            --this.fireCount;
        }
    }

    private Object[] getListeners(Class<?> listenerClass) {
        Object[] services;
        ServiceTracker tracker = this.serviceTrackers.get(listenerClass);
        if (tracker == null) {
            tracker = new ServiceTracker(this.bc, listenerClass.getName(), null);
            tracker.open();
            this.serviceTrackers.put(listenerClass, tracker);
        }
        if ((services = tracker.getServices()) == null) {
            return null;
        }
        Arrays.sort(services, serviceComparator);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void silenceEventSource(Object eventSource) {
        Object object = this.lock;
        synchronized (object) {
            this.silencedSources.put(eventSource, DUMMY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsilenceEventSource(Object eventSource) {
        Object object = this.lock;
        synchronized (object) {
            this.silencedSources.remove(eventSource);
        }
    }

    private void printTrace(int indent, String message) {
        this.traceString.delete(0, this.traceString.length());
        for (int i = 0; i < indent; ++i) {
            this.traceString.append("    ");
        }
        this.traceString.append(message);
        System.out.println(this.traceString.toString());
    }
}

